/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.network;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.utils.ArrUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Stream;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;

public class BatchedPayload {
    public static final int DEFAULT_BATCH_SIZE = (int)Math.pow(2.0, 18.0);
    public final StreamCodec<RegistryFriendlyByteBuf, Payload> CODEC = StreamCodec.of((b, v) -> {
        b.writeInt(v.remainingBatches());
        b.writeByteArray(v.bytes());
    }, b -> {
        int i = b.readInt();
        byte[] a = b.readByteArray();
        return new Payload(a, i);
    });
    public final CustomPacketPayload.Type<Payload> TYPE;

    BatchedPayload(CustomPacketPayload.Type<Payload> type) {
        this.TYPE = type;
    }

    public Payload payload(byte[] bytes) {
        return this.payload(bytes);
    }

    public Payload payload(byte[] bytes, int remainingBatches) {
        return new Payload(bytes, remainingBatches);
    }

    public Payload[] payloads(byte[] bytes) {
        return this.payloads(bytes, DEFAULT_BATCH_SIZE);
    }

    public Payload[] payloads(byte[] bytes, int batchSize) {
        List<byte[]> batches = ArrUtils.split(bytes, batchSize);
        Payload[] pls = new Payload[batches.size()];
        int i = 0;
        for (byte[] b : batches) {
            pls[i] = new Payload(b, batches.size() - (i + 1));
            ++i;
        }
        return pls;
    }

    public <T extends Serializable> Payload[] payloads(T obj) {
        return this.payloads(obj, DEFAULT_BATCH_SIZE);
    }

    public <T extends Serializable> Payload[] payloads(T obj, int batchSize) {
        Payload[] payloadArray;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bytes);
        try {
            oos.writeObject(obj);
            payloadArray = this.payloads(bytes.toByteArray(), batchSize);
        }
        catch (Throwable throwable) {
            try {
                try {
                    oos.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                ModCommon.LOG.error(e.getMessage(), (Throwable)e);
                return new Payload[0];
            }
        }
        oos.close();
        return payloadArray;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T extends Serializable> T from(Payload[] payloads) {
        ByteArrayInputStream bytes = new ByteArrayInputStream(ArrUtils.combine(Stream.of(payloads).map(pl -> pl.bytes).toList()));
        try (ObjectInputStream ois = new ObjectInputStream(bytes);){
            Serializable serializable = (Serializable)ois.readObject();
            return (T)serializable;
        }
        catch (IOException | ClassNotFoundException e) {
            ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static BatchedPayload create(String id) {
        return new BatchedPayload((CustomPacketPayload.Type<Payload>)new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)id)));
    }

    public class Payload
    implements CustomPacketPayload {
        private byte[] bytes;
        private int remainingBatches;

        Payload(byte[] bytes, int remainingBatches) {
            this.bytes = bytes;
            this.remainingBatches = remainingBatches;
        }

        public byte[] bytes() {
            return this.bytes;
        }

        public int remainingBatches() {
            return this.remainingBatches;
        }

        public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
            return BatchedPayload.this.TYPE;
        }
    }
}

