/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;

public class ForceIntoBattleGoal
extends Goal {
    private static final int TIMEOUT_TICKS = 60;
    private static final float CANCEL_PROBABILITY = 0.005f;
    private static final double BB_HEIGHT = 3.0;
    private int tickOfLastAttempt;
    private int tickOfLookAt;
    private TrainerManager tm;
    private TrainerMob mob;
    private final Class<? extends LivingEntity> lookAtType;
    private Entity lookAt;

    public ForceIntoBattleGoal(TrainerMob mob, Class<? extends LivingEntity> clazz) {
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.tm = RCTMod.getInstance().getTrainerManager();
        this.mob = mob;
        this.lookAtType = clazz;
    }

    public void start() {
        this.tickOfLookAt = this.mob.tickCount;
        this.mob.getNavigation().stop();
    }

    public void stop() {
        this.lookAt = null;
    }

    public boolean canUse() {
        TargetingConditions lookAtContext;
        if (this.mob.getRandom().nextFloat() < this.mob.getForceBattleChance() && this.mob.tickCount - this.tickOfLastAttempt > 60 && (lookAtContext = this.initContext()) != null) {
            if (this.mob.getTarget() != null) {
                this.lookAt = this.mob.getTarget();
            }
            if (this.lookAtType == Player.class) {
                this.lookAt = this.mob.level().getNearestPlayer(lookAtContext, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
            } else {
                double d = this.mob.getForceBattleMaxDistance();
                this.lookAt = this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(this.lookAtType, this.mob.getBoundingBox().inflate(d, 3.0, d), le -> true), lookAtContext, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
            }
            if (this.lookAt != null) {
                return this.isInLevelRange(this.lookAt) && this.mob.canBattleAgainst(this.lookAt);
            }
        }
        return false;
    }

    public boolean canContinueToUse() {
        double d = this.mob.getForceBattleMaxDistance();
        if (this.lookAt != null && this.lookAt.isAlive() && !this.mob.isInBattle() && this.mob.getCooldown() == 0 && this.mob.distanceToSqr(this.lookAt) < d * d) {
            return true;
        }
        this.stop();
        return false;
    }

    public void tick() {
        if (this.lookAt != null && this.lookAt.isAlive()) {
            this.mob.getLookControl().setLookAt(this.lookAt.getX(), this.mob.getEyeY(), this.lookAt.getZ());
        }
        if (this.lookAt instanceof Player) {
            Vec3 from = this.lookAt.getEyePosition();
            Vec3 to = from.add(this.lookAt.getForward().scale((double)this.mob.getForceBattleMaxDistance()));
            EntityHitResult hit = ProjectileUtil.getEntityHitResult((Level)this.mob.level(), (Entity)this.lookAt, (Vec3)from, (Vec3)to, (AABB)AABB.ofSize((Vec3)from, (double)0.15, (double)0.15, (double)0.15).expandTowards(to.subtract(from)), e -> true);
            if (hit == null || hit.getEntity() != this.mob) {
                if (this.mob.getRandom().nextFloat() < 0.005f) {
                    this.tickOfLastAttempt = this.mob.tickCount;
                    this.stop();
                    return;
                }
                this.tickOfLookAt = this.mob.tickCount;
            }
        }
        if (this.mob.tickCount - this.tickOfLookAt > this.mob.getForceBattleLookTicks()) {
            this.tryStartBattle();
            this.stop();
        }
    }

    private void tryStartBattle() {
        Player player;
        Entity entity = this.lookAt;
        if (entity instanceof Player && this.isInLevelRange((Entity)(player = (Player)entity))) {
            this.mob.startBattleWith(player);
        }
        this.tickOfLastAttempt = this.mob.tickCount;
    }

    private TargetingConditions initContext() {
        return this.lookAtType == Player.class ? TargetingConditions.forNonCombat().range((double)this.mob.getForceBattleMaxDistance()).selector(le -> EntitySelector.notRiding((Entity)this.mob).test(le)) : TargetingConditions.forNonCombat().range((double)this.mob.getForceBattleMaxDistance());
    }

    private boolean isInLevelRange(Entity entity) {
        Player player;
        return entity instanceof Player ? Math.abs(this.tm.getPlayerLevel(player = (Player)entity) - this.tm.getData(this.mob).getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0)) <= this.mob.getForceBattleMaxLevelDiff() : false;
    }
}

