/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;

public class LookAtPlayerAndWaitGoal
extends LookAtPlayerGoal {
    private int minLookTime;
    private int maxLookTime;
    private int lookTime;

    public LookAtPlayerAndWaitGoal(Mob mob, Class<? extends LivingEntity> class_, float distance) {
        this(mob, class_, distance, 0.02f, 80, 160);
    }

    public LookAtPlayerAndWaitGoal(Mob mob, Class<? extends LivingEntity> class_, float distance, float propability, int minLookTime, int maxLookTime) {
        super(mob, class_, distance, propability);
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
        this.minLookTime = minLookTime;
        this.maxLookTime = maxLookTime;
    }

    public void start() {
        this.lookTime = this.adjustedTickDelay(this.minLookTime + this.mob.getRandom().nextInt(this.maxLookTime - this.minLookTime));
        this.mob.getNavigation().stop();
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public boolean canContinueToUse() {
        if (!this.lookAt.isAlive()) {
            return false;
        }
        if (this.mob.distanceToSqr(this.lookAt) > 2.0 * (double)(this.lookDistance * this.lookDistance)) {
            return false;
        }
        return this.lookTime > 0;
    }

    public void tick() {
        if (this.lookAt.isAlive()) {
            double d = this.lookAt.getEyeY();
            this.mob.getLookControl().setLookAt(this.lookAt.getX(), d, this.lookAt.getZ());
            --this.lookTime;
        }
    }
}

