/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import java.util.EnumSet;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;

public class PokemonBattleGoal
extends LookAtPlayerGoal {
    private static final float LOOK_AT_SWITCH_CHANCE = 0.015f;
    private TrainerMob trainer;
    private boolean lookAtPlayer;

    public PokemonBattleGoal(TrainerMob trainer) {
        super((Mob)trainer, Mob.class, 8.0f, 1.0f, false);
        this.trainer = trainer;
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        if (this.trainer.isInBattle()) {
            if (this.lookAtPlayer) {
                this.lookAt = this.mob.level().getNearestPlayer(this.lookAtContext, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
            } else if (this.lookAt == null || this.mob.distanceToSqr(this.lookAt) > (double)(this.lookDistance * this.lookDistance) || this.mob.getRandom().nextFloat() < 0.015f) {
                this.lookAt = this.mob.level().getNearestEntity(this.mob.level().getEntitiesOfClass(this.lookAtType, this.mob.getBoundingBox().inflate((double)this.lookDistance, 3.0, (double)this.lookDistance), livingEntity -> true), this.lookAtContext, (LivingEntity)this.mob, this.mob.getX(), this.mob.getEyeY(), this.mob.getZ());
            }
            if (this.lookAt == null || this.mob.getRandom().nextFloat() < 0.015f) {
                this.lookAtPlayer = !this.lookAtPlayer;
            }
            return true;
        }
        return false;
    }

    public boolean canContinueToUse() {
        return this.canUse();
    }

    public void start() {
        this.trainer.getNavigation().stop();
    }

    public void stop() {
        this.lookAt = null;
    }

    public void tick() {
        if (this.lookAt != null && this.lookAt.isAlive()) {
            this.mob.getLookControl().setLookAt(this.lookAt.getX(), this.lookAt.getEyeY(), this.lookAt.getZ());
        }
    }
}

