/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.phys.Vec3;

public class RandomStrollAwayGoal
extends RandomStrollGoal {
    private static final float STROLL_CHANCE = 0.0015f;
    private static final int MAX_TARGET_FAILS = 16;
    private int[] direction;
    private float probability;
    private int failCount;

    public RandomStrollAwayGoal(PathfinderMob pathfinderMob, double d) {
        this(pathfinderMob, d, 0.15f);
    }

    public RandomStrollAwayGoal(PathfinderMob pathfinderMob, double d, float p) {
        super(pathfinderMob, d);
        this.probability = p;
        this.updateDirection();
    }

    public boolean canUse() {
        Vec3 pos;
        if (this.mob.hasControllingPassenger() || this.mob.isPersistenceRequired() || this.mob.getRandom().nextFloat() > this.probability) {
            return false;
        }
        if (this.failCount > 16) {
            this.updateDirection();
        }
        if ((pos = this.getPosition()) == null) {
            ++this.failCount;
            return false;
        }
        this.wantedX = pos.x;
        this.wantedY = pos.y;
        this.wantedZ = pos.z;
        this.failCount = 0;
        return true;
    }

    public boolean canContinueToUse() {
        if (!this.mob.isInWater() && !this.mob.isInLava() && this.mob.getRandom().nextInt(600) == 0) {
            return false;
        }
        return super.canContinueToUse();
    }

    protected Vec3 getPosition() {
        float r = this.mob.getRandom().nextFloat();
        if (this.mob.isInWaterOrBubble() || this.mob.isInLava()) {
            Vec3 vec3 = LandRandomPos.getPosTowards((PathfinderMob)this.mob, (int)15, (int)7, (Vec3)this.mob.getPosition(1.0f).add((double)((int)(r * (float)this.direction[0])), 0.0, (double)((int)(r * (float)this.direction[1]))));
            return vec3 == null ? super.getPosition() : vec3;
        }
        return this.mob.getRandom().nextFloat() > 0.0015f ? LandRandomPos.getPosTowards((PathfinderMob)this.mob, (int)10, (int)7, (Vec3)this.mob.getPosition(1.0f).add((double)((int)(r * (float)this.direction[0])), 0.0, (double)((int)(r * (float)this.direction[1])))) : super.getPosition();
    }

    public void tick() {
        this.mob.getNavigation().setSpeedModifier(this.mob.isInWater() || this.mob.isInLava() ? 1.0 : this.speedModifier);
        super.tick();
    }

    private void updateDirection() {
        switch (this.mob.getRandom().nextInt(8)) {
            case 0: {
                this.direction = new int[]{1000, 0};
                break;
            }
            case 1: {
                this.direction = new int[]{1000, 1000};
                break;
            }
            case 2: {
                this.direction = new int[]{0, 1000};
                break;
            }
            case 3: {
                this.direction = new int[]{-1000, 1000};
                break;
            }
            case 4: {
                this.direction = new int[]{-1000, 0};
                break;
            }
            case 5: {
                this.direction = new int[]{-1000, -1000};
                break;
            }
            case 6: {
                this.direction = new int[]{0, -1000};
                break;
            }
            case 7: {
                this.direction = new int[]{1000, -1000};
            }
        }
    }
}

