/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.data.pack.IDataPackObject;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerTeam;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.utils.JsonUtils;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;

public class TrainerMobData
implements IDataPackObject,
Serializable {
    private static final long serialVersionUID = 0L;
    private String type = "normal";
    private String signatureItem = "";
    private List<Set<String>> requiredDefeats = new ArrayList<Set<String>>();
    private Set<String> series = new HashSet<String>();
    private Set<String> substitutes = new HashSet<String>();
    private boolean optional;
    private int maxTrainerWins = 3;
    private int maxTrainerDefeats = 1;
    private int battleCooldownTicks = 240;
    private float spawnWeightFactor = 1.0f;
    private Set<String> biomeTagBlacklist = new HashSet<String>();
    private Set<String> biomeTagWhitelist = new HashSet<String>();
    @JsonUtils.Exclude
    private int rewardLevelCap;
    @JsonUtils.Exclude
    private Set<String> followdBy = new HashSet<String>();
    @JsonUtils.Exclude
    private Map<String, Text[]> dialog = new HashMap<String, Text[]>();
    @JsonUtils.Exclude
    private TrainerTeam trainerTeam;
    @JsonUtils.Exclude
    private RLWrapper textureResource;
    @JsonUtils.Exclude
    private RLWrapper lootTableResource;
    private transient Supplier<TrainerType> lazyType;

    public TrainerMobData() {
        this.textureResource = new RLWrapper(ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)"textures/trainers/default.png"));
        this.lootTableResource = new RLWrapper(ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)"trainers/default"));
        this.trainerTeam = new TrainerTeam();
        this.init();
    }

    public TrainerMobData(TrainerMobData origin) {
        this.type = origin.type;
        this.signatureItem = origin.signatureItem;
        this.rewardLevelCap = origin.rewardLevelCap;
        this.requiredDefeats = List.copyOf(origin.requiredDefeats);
        this.followdBy = Set.copyOf(origin.followdBy);
        this.optional = origin.optional;
        this.maxTrainerWins = origin.maxTrainerWins;
        this.maxTrainerDefeats = origin.maxTrainerDefeats;
        this.battleCooldownTicks = origin.battleCooldownTicks;
        this.biomeTagBlacklist = Set.copyOf(origin.biomeTagBlacklist);
        this.biomeTagWhitelist = Set.copyOf(origin.biomeTagWhitelist);
        this.dialog = Map.copyOf(origin.dialog);
        this.textureResource = origin.textureResource;
        this.lootTableResource = origin.lootTableResource;
        this.trainerTeam = origin.trainerTeam;
        this.init();
    }

    private void init() {
        this.lazyType = () -> {
            TrainerType type = TrainerType.valueOf(this.type.toLowerCase());
            this.lazyType = () -> type;
            return this.lazyType.get();
        };
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getType());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        TrainerType type = TrainerType.registerOrGet(this.type, (TrainerType)ois.readObject());
        this.lazyType = () -> type;
    }

    public TrainerType getType() {
        return this.lazyType.get();
    }

    public void setRewardLevelCap(int levelCap) {
        this.rewardLevelCap = Math.min(100, Math.max(1, Math.max(this.getRequiredLevelCap(), levelCap)));
    }

    public int getRewardLevelCap() {
        return this.rewardLevelCap;
    }

    public int getRequiredLevelCap() {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        return Math.max(1, Math.min(100, this.getTrainerTeam().getTeam().stream().map(p -> p.getLevel()).max(Integer::compare).orElse(0) + cfg.additiveLevelCapRequirement()));
    }

    public boolean isOfSeries(String seriesId) {
        return this.series.isEmpty() || this.series.contains(seriesId);
    }

    public Stream<String> getSeries() {
        return this.series.stream();
    }

    public List<Set<String>> getRequiredDefeats() {
        return Collections.unmodifiableList(this.requiredDefeats);
    }

    public Set<String> getSubstitutes() {
        return Collections.unmodifiableSet(this.substitutes);
    }

    public Stream<String> getMissingRequirements(Set<String> defeatedTrainerIds) {
        return this.getMissingRequirements(defeatedTrainerIds, false);
    }

    public Stream<String> getMissingRequirements(Set<String> defeatedTrainerIds, boolean includeAlternatives) {
        return this.requiredDefeats.stream().mapMulti((set, cons) -> {
            if (includeAlternatives) {
                if (set.stream().noneMatch(defeatedTrainerIds::contains)) {
                    set.stream().forEach(cons);
                }
            } else if (!set.isEmpty()) {
                if (set.stream().noneMatch(defeatedTrainerIds::contains)) {
                    cons.accept((String)set.stream().findFirst().get());
                }
            }
        });
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int getMaxTrainerWins() {
        return this.maxTrainerWins;
    }

    public int getMaxTrainerDefeats() {
        return this.maxTrainerDefeats;
    }

    public int getBattleCooldownTicks() {
        return this.battleCooldownTicks;
    }

    public float getSpawnWeightFactor() {
        return this.spawnWeightFactor;
    }

    public Set<String> getBiomeTagBlacklist() {
        return Collections.unmodifiableSet(this.biomeTagBlacklist);
    }

    public Set<String> getBiomeTagWhitelist() {
        return Collections.unmodifiableSet(this.biomeTagWhitelist);
    }

    public Set<String> getFollowedBy() {
        return Collections.unmodifiableSet(this.followdBy);
    }

    public boolean addFollowedBy(String trainerId) {
        return this.followdBy.add(trainerId);
    }

    public boolean removeFollowdBy(String trainerId) {
        return this.followdBy.remove(trainerId);
    }

    public void clearFollowedBy(String trainerId) {
        this.followdBy.clear();
    }

    public Map<String, Text[]> getDialog() {
        return Collections.unmodifiableMap(this.dialog);
    }

    public ResourceLocation getTextureResource() {
        return this.textureResource.resourceLocation();
    }

    public ResourceLocation getLootTableResource() {
        return this.lootTableResource.resourceLocation();
    }

    public TrainerTeam getTrainerTeam() {
        return this.trainerTeam;
    }

    public String getSignatureItem() {
        return this.signatureItem;
    }

    @Override
    public void onLoad(DataPackManager dpm, String trainerId, String context) {
        Optional<TrainerTeam> trainerTeam;
        Optional<ResourceLocation> lootTableResource = dpm.findResource(trainerId, "loot_table");
        Optional<ResourceLocation> textureResource = dpm.findResource(trainerId, "textures");
        if (textureResource.isPresent()) {
            this.textureResource = new RLWrapper(textureResource.get());
        }
        if (lootTableResource.isPresent()) {
            this.lootTableResource = new RLWrapper(ResourceLocation.fromNamespaceAndPath((String)"rctmod", (String)lootTableResource.get().getPath().replace("loot_table/", "").replace(".json", "")));
        }
        dpm.loadResource(trainerId, "dialogs", dialog -> {
            this.dialog = dialog;
        }, new TypeToken<Map<String, Text[]>>(this){});
        if (this.dialog == null) {
            this.dialog = new HashMap<String, Text[]>();
        }
        if ((trainerTeam = dpm.loadTrainerTeam(trainerId)).isPresent()) {
            this.trainerTeam = trainerTeam.get();
        }
    }

    class RLWrapper
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private transient Supplier<ResourceLocation> rlSup;
        private transient ResourceLocation rl;
        private String namespace;
        private String path;

        public RLWrapper() {
            this(null);
        }

        public RLWrapper(ResourceLocation rl) {
            if (rl != null) {
                this.namespace = rl.getNamespace();
                this.path = rl.getPath();
            }
            this.rl = rl;
            this.init();
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            this.init();
        }

        public ResourceLocation resourceLocation() {
            return this.rlSup.get();
        }

        private void init() {
            this.rlSup = () -> {
                if (this.rl == null) {
                    this.rl = ResourceLocation.fromNamespaceAndPath((String)this.namespace, (String)this.path);
                }
                this.rlSup = () -> this.rl;
                return this.rl;
            };
        }
    }
}

