/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.save;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.saveddata.SavedData;

public class TrainerPlayerData
extends SavedData {
    private Set<String> defeatedTrainerIds = new HashSet<String>();
    private Map<String, Integer> completedSeries = new HashMap<String, Integer>();
    private String currentSeries = "";
    private String previousSeries = "";
    private Player player;
    private int initialLevelCap;
    private int additiveLevelCapRequirement;
    private int levelCap;
    private boolean currentSeriesCompleted;
    static final int LUCK_DELTA = 8;

    public TrainerPlayerData(Player player) {
        this.player = player;
    }

    public TrainerPlayerData forPlayer(Player player) {
        this.player = player;
        return this;
    }

    public int getLevelCap() {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        if (RCTMod.getInstance().getTrainerManager().updateRequired(this.player) || cfg.initialLevelCap() != this.initialLevelCap || cfg.additiveLevelCapRequirement() != this.additiveLevelCapRequirement) {
            this.additiveLevelCapRequirement = cfg.additiveLevelCapRequirement();
            this.initialLevelCap = cfg.initialLevelCap();
            this.updateLevelCap();
        }
        return this.levelCap;
    }

    private void updateLevelCap() {
        if (this.isSeriesCompleted()) {
            this.levelCap = 100;
        } else {
            IServerConfig cfg = RCTMod.getInstance().getServerConfig();
            this.levelCap = Math.max(RCTMod.getInstance().getTrainerManager().getMinRequiredLevelCap(this.getCurrentSeries()), Math.min(100, cfg.initialLevelCap() + cfg.additiveLevelCapRequirement()));
        }
        PlayerState.get(this.player).setLevelCap(this.levelCap);
        if (!this.currentSeriesCompleted) {
            this.defeatedTrainerIds.forEach(this::updateLevelCap);
        }
    }

    private void updateLevelCap(String trainerId) {
        if (this.isSeriesCompleted()) {
            this.levelCap = 100;
        } else {
            TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(trainerId);
            this.levelCap = Math.max(this.levelCap, Math.max(1, Math.min(100, Math.max(tmd.getRequiredLevelCap(), tmd.getRewardLevelCap()))));
        }
        PlayerState.get(this.player).setLevelCap(this.levelCap);
    }

    public Set<String> getDefeatedTrainerIds() {
        return Collections.unmodifiableSet(this.defeatedTrainerIds);
    }

    public boolean addProgressDefeat(String trainerId) {
        return this.addProgressDefeat(trainerId, false);
    }

    private boolean addProgressDefeat(String trainerId, boolean allowPrevious) {
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        SeriesManager.SeriesGraph graph = sm.getGraph(this.currentSeries);
        if (graph == sm.FREEROAM_SERIES) {
            if (allowPrevious) {
                if (!this.previousSeries.isEmpty()) {
                    graph = sm.getGraph(this.previousSeries);
                }
            } else {
                return false;
            }
        }
        if (graph == sm.EMPTY_SERIES) {
            return false;
        }
        SeriesManager.TrainerNode node = graph.get(trainerId);
        boolean[] updated = new boolean[]{false};
        if (node != null) {
            PlayerState ps = PlayerState.get(this.player);
            Stream.concat(Stream.of(node), node.siblings()).filter(tn -> !tn.isAlone()).forEach(tn -> {
                if (this.defeatedTrainerIds.add(tn.id())) {
                    this.updateLevelCap(tn.id());
                    ps.addProgressDefeat(tn.id());
                    this.updateCurrentSeries();
                    this.setDirty();
                    updated[0] = true;
                }
            });
        }
        return updated[0];
    }

    public boolean removeProgressDefeat(String trainerId) {
        SeriesManager.SeriesGraph graph = RCTMod.getInstance().getSeriesManager().getGraph(this.currentSeries);
        SeriesManager.TrainerNode node = graph.get(trainerId);
        boolean[] updated = new boolean[]{false};
        if (node != null) {
            PlayerState ps = PlayerState.get(this.player);
            Stream.concat(Stream.of(node), node.siblings()).forEach(tn -> {
                if (this.defeatedTrainerIds.remove(tn.id())) {
                    this.updateLevelCap();
                    ps.removeProgressDefeat(tn.id());
                    this.setDirty();
                    updated[0] = true;
                }
            });
        }
        if (!this.isCurrentSeriesCompleted()) {
            this.currentSeriesCompleted = false;
        }
        return updated[0];
    }

    public boolean removeProgressDefeats() {
        return this.removeProgressDefeats(false);
    }

    protected boolean removeProgressDefeats(boolean forceUpdate) {
        if (forceUpdate || this.defeatedTrainerIds.size() > 0) {
            PlayerState ps = PlayerState.get(this.player);
            this.defeatedTrainerIds.clear();
            this.currentSeriesCompleted = false;
            this.updateLevelCap();
            ps.removeProgressDefeats();
            this.setDirty();
            return true;
        }
        return false;
    }

    public boolean isInEmptySeries() {
        return this.currentSeries.isEmpty() || "empty".equals(this.currentSeries);
    }

    public boolean isSeriesCompleted() {
        return this.currentSeriesCompleted || "freeroam".equals(this.currentSeries);
    }

    private boolean isCurrentSeriesCompleted() {
        if (this.canCompleteCurrentSeries()) {
            SeriesManager.SeriesGraph graph = RCTMod.getInstance().getSeriesManager().getGraph(this.currentSeries);
            return graph.size() > 0 && graph.getRemaining(this.defeatedTrainerIds).size() == 0;
        }
        return false;
    }

    private boolean canCompleteCurrentSeries() {
        return !this.currentSeries.isEmpty() && !"empty".equals(this.currentSeries) && !"freeroam".equals(this.currentSeries);
    }

    private boolean testSeriesCompleted() {
        if (this.canCompleteCurrentSeries() && !this.currentSeriesCompleted) {
            boolean bl = this.currentSeriesCompleted = RCTMod.getInstance().getSeriesManager().getGraph(this.currentSeries).getRemaining(this.defeatedTrainerIds).size() == 0;
            if (this.currentSeriesCompleted) {
                this.setDirty();
            }
            return this.currentSeriesCompleted;
        }
        return false;
    }

    private void updateCurrentSeries() {
        if (this.testSeriesCompleted()) {
            this.addSeriesCompletion(this.getCurrentSeries());
            this.updateLevelCap();
            ChatUtils.sendTitle(this.player, Text.translatable((String)"gui.rctmod.title.series_completed"), RCTMod.getInstance().getSeriesManager().getGraph(this.getCurrentSeries()).getMetaData().title(), new Object[0]);
        }
    }

    public String getCurrentSeries() {
        return this.currentSeries;
    }

    public String getPreviousSeries() {
        return this.previousSeries;
    }

    public void setCurrentSeries(String seriesId) {
        boolean seriesPaused = "freeroam".equals(seriesId);
        boolean seriesContinued = "freeroam".equals(this.currentSeries) && seriesId != null && seriesId.equals(this.previousSeries);
        this.setCurrentSeries(seriesId, seriesPaused || seriesContinued);
    }

    public void setCurrentSeries(String seriesId, boolean keepProgress) {
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        if (seriesId.isEmpty()) {
            seriesId = "empty";
        }
        if (sm.getGraph(seriesId) == sm.UNKNOWN_SERIES) {
            ChatUtils.sendError(this.player, Text.translatable((String)"commands.rctmod.errors.unknown_series"), seriesId);
            return;
        }
        if (!seriesId.equals(this.currentSeries)) {
            this.previousSeries = this.currentSeries;
            this.currentSeries = seriesId;
            PlayerState.get(this.player).setCurrentSeries(this.currentSeries);
            this.setDirty();
        }
        if (!keepProgress) {
            this.removeProgressDefeats(true);
            if (this.currentSeriesCompleted) {
                this.currentSeriesCompleted = false;
                this.setDirty();
            }
        } else {
            this.updateLevelCap();
        }
    }

    public Map<String, Integer> getCompletedSeries() {
        return Collections.unmodifiableMap(this.completedSeries);
    }

    public void setSeriesCompletion(String seriesId, int n) {
        Integer m = this.completedSeries.getOrDefault(seriesId, 0);
        this.addSeriesCompletion(seriesId, n - m);
    }

    public void addSeriesCompletion(String seriesId) {
        this.addSeriesCompletion(seriesId, 1);
    }

    public void addSeriesCompletion(String seriesId, int n) {
        this.completedSeries.compute(seriesId, (k, v) -> v == null ? (n > 0 ? Integer.valueOf(n) : null) : (n + v > 0 ? Integer.valueOf(n + v) : null));
    }

    public void removeSeriesCompletion(String seriesId) {
        this.removeSeriesCompletion(seriesId, this.completedSeries.getOrDefault(seriesId, 0));
    }

    public void removeSeriesCompletion(String seriesId, int n) {
        this.addSeriesCompletion(seriesId, -n);
    }

    public float getBonusLuck() {
        return this.getBonusLuck(0);
    }

    public float getBonusLuck(int extra) {
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        return (float)TrainerPlayerData.calculateLuck(extra + this.getCompletedSeries().entrySet().stream().map(e -> sm.getGraph((String)e.getKey()).getMetaData().difficulty() * (Integer)e.getValue()).reduce(0, (a, b) -> a + b));
    }

    public void sync() {
        PlayerState ps = PlayerState.get(this.player);
        ps.setLevelCap(this.levelCap);
        ps.setCurrentSeries(this.currentSeries);
        this.defeatedTrainerIds.forEach(ps::addProgressDefeat);
        RCTMod.getInstance().getTrainerManager().requiresUpdate(this.player);
    }

    public CompoundTag save(CompoundTag compoundTag, HolderLookup.Provider provider) {
        byte b = 0;
        CompoundTag progressDefeats = new CompoundTag();
        CompoundTag completedSeries = new CompoundTag();
        this.defeatedTrainerIds.forEach(tid -> progressDefeats.putByte(tid, b));
        this.completedSeries.forEach((s, c) -> completedSeries.putInt(s, c.intValue()));
        compoundTag.put("progressDefeats", (Tag)progressDefeats);
        compoundTag.put("completedSeries", (Tag)completedSeries);
        compoundTag.putString("currentSeries", this.currentSeries);
        compoundTag.putString("previousSeries", this.previousSeries);
        compoundTag.putBoolean("currentSeriesCompleted", this.currentSeriesCompleted);
        return compoundTag;
    }

    static double calculateLuck(int n) {
        double r = 0.0;
        for (int i = 1; i <= n; ++i) {
            r += (1.0 - r) / (double)(i * 8);
        }
        return r;
    }

    public static String filePath(Player player) {
        return String.format("%s.player.%s.stat", "rctmod", player.getUUID().toString());
    }

    public static class Builder {
        private Player player;

        public Builder(Player player) {
            this.player = player;
        }

        public TrainerPlayerData create() {
            TrainerPlayerData tpd = new TrainerPlayerData(this.player);
            tpd.setCurrentSeries(RCTMod.getInstance().getServerConfig().initialSeries());
            tpd.updateLevelCap();
            return tpd;
        }

        public TrainerPlayerData of(CompoundTag tag, HolderLookup.Provider provider) {
            TrainerPlayerData tpd = new TrainerPlayerData(this.player);
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            if (tag.contains("currentSeries")) {
                tpd.setCurrentSeries(tag.getString("currentSeries"));
            } else {
                tpd.setCurrentSeries("radicalred");
            }
            tpd.previousSeries = tag.contains("previousSeries") ? tag.getString("previousSeries") : "";
            if (tag.contains("completedSeries")) {
                CompoundTag seriesTag = tag.getCompound("completedSeries");
                seriesTag.getAllKeys().forEach(s -> tpd.setSeriesCompletion((String)s, seriesTag.getInt(s)));
            }
            if (tag.contains("currentSeriesCompleted")) {
                tpd.currentSeriesCompleted = tag.getBoolean("currentSeriesCompleted");
            }
            if (!tpd.currentSeries.isEmpty()) {
                if (tag.contains("progressDefeats")) {
                    tag.getCompound("progressDefeats").getAllKeys().forEach(tid -> tpd.addProgressDefeat((String)tid, true));
                } else {
                    ServerLevel level = this.player.getServer().overworld();
                    tm.getAllData(new String[0]).map(entry -> (String)entry.getKey()).filter(tid -> tm.getBattleMemory(level, (String)tid).getDefeatByCount((String)tid, this.player) > 0).forEach(tid -> tpd.addProgressDefeat((String)tid, true));
                }
            }
            tpd.updateLevelCap();
            return tpd;
        }
    }
}

