/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.service;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.collection.SavedBlockPosIntegerMap;
import com.gitlab.srcmc.rctmod.api.data.save.collection.SavedDimensionBlockPosIntegerMap;
import com.gitlab.srcmc.rctmod.api.data.save.collection.SavedMap;
import com.gitlab.srcmc.rctmod.api.data.save.collection.SavedStringChunkPosMap;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.world.blocks.TrainerRepelRodBlock;
import com.gitlab.srcmc.rctmod.world.entities.TrainerAssociation;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.gitlab.srcmc.rctmod.world.items.TrainerCard;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ChunkLevel;
import net.minecraft.server.level.ChunkMap;
import net.minecraft.server.level.FullChunkStatus;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.util.RandomSource;
import net.minecraft.util.datafix.DataFixTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TrainerSpawner {
    public static float KEY_TRAINER_SPAWN_WEIGHT_FACTOR = 64.0f;
    public static float NON_KEY_TRAINER_SPAWN_CHANCE_DIV = 4.0f;
    public static final int SPAWN_RETRIES = 8;
    public static final boolean CAN_SPAWN_IN_WATER = false;
    public static final double TRAINER_DIRECT_SPAWN_CHANCE = 0.42;
    public static final int CHUNK_REPEL_RADIUS = 3;
    public static final TicketType<ChunkPos> PERSISTENT_TRAINER_TICKET = TicketType.create((String)"persistent_trainer", Comparator.comparingLong(ChunkPos::toLong), (int)600);
    public static final int PERSISTENT_TRAINER_TICKET_LEVEL = ChunkLevel.byStatus((FullChunkStatus)FullChunkStatus.FULL) - ChunkMap.FORCED_TICKET_LEVEL;
    private Map<String, Integer> spawns = new HashMap<String, Integer>();
    private Map<String, Integer> identities = new HashMap<String, Integer>();
    private Map<String, Integer> playerSpawns = new HashMap<String, Integer>();
    private Map<String, SavedStringChunkPosMap.ChunkPosDim> persistentChunks;
    private Map<ResourceLocation, SavedBlockPosIntegerMap> trainerRepelBlocks;
    private Map<ResourceLocation, Map<ChunkPos, Integer>> markedChunks = new HashMap<ResourceLocation, Map<ChunkPos, Integer>>();
    private Set<TrainerMob> mobs = new HashSet<TrainerMob>();
    private Set<TrainerMob> persistentMobs = new HashSet<TrainerMob>();
    private Set<TrainerAssociation> tas = new HashSet<TrainerAssociation>();
    private Set<TrainerAssociation> persistentTas = new HashSet<TrainerAssociation>();

    public void init(ServerLevel level) {
        TrainerAssociation.init((Level)level);
        this.spawns.clear();
        this.identities.clear();
        this.playerSpawns.clear();
        this.persistentMobs.clear();
        this.persistentTas.clear();
        this.mobs.clear();
        this.tas.clear();
        this.persistentChunks = (Map)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SavedStringChunkPosMap::new, SavedStringChunkPosMap::of, DataFixTypes.LEVEL), SavedMap.filePath("spawn.chunks"));
        this.trainerRepelBlocks = (Map)level.getDataStorage().computeIfAbsent(new SavedData.Factory(SavedDimensionBlockPosIntegerMap::new, SavedDimensionBlockPosIntegerMap::of, DataFixTypes.LEVEL), SavedMap.filePath("spawn.chunks.repel"));
        MinecraftServer server = level.getServer();
        this.markedChunks.clear();
        Map.copyOf(this.trainerRepelBlocks).entrySet().forEach(e -> {
            ServerLevel lvl = server.getLevel(ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)((ResourceLocation)e.getKey())));
            if (lvl == null) {
                ModCommon.LOG.warn(String.format("trainer repel rods placed in unknown dimension '%s'!", e.getKey()));
            } else {
                Set.copyOf(((SavedBlockPosIntegerMap)e.getValue()).entrySet()).forEach(v -> {
                    BlockState blockState = lvl.getBlockState((BlockPos)v.getKey());
                    boolean unpoweredRod = blockState.is((Block)ModRegistries.Blocks.TRAINER_REPEL_ROD.get()) && (Boolean)blockState.getValue((Property)TrainerRepelRodBlock.POWERED) == false;
                    this.markChunks((Level)lvl, (BlockPos)v.getKey(), !unpoweredRod, 3);
                });
            }
        });
        this.persistentChunks.entrySet().forEach(entry -> {
            SavedStringChunkPosMap.ChunkPosDim cpd = (SavedStringChunkPosMap.ChunkPosDim)entry.getValue();
            String tid = (String)entry.getKey();
            if (cpd.dim == null) {
                ModCommon.LOG.warn(String.format("trainer dimension unknown, will have to check all dimensions (run '/rctmod trainer unregister_persistent %s' to manually unregister if this message keeps showing up)!", tid));
                server.getAllLevels().forEach(l -> l.getChunkSource().addRegionTicket(PERSISTENT_TRAINER_TICKET, cpd.pos, PERSISTENT_TRAINER_TICKET_LEVEL, (Object)cpd.pos));
            } else {
                ResourceKey key = ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)cpd.dim);
                ServerLevel l2 = server.getLevel(key);
                if (l2 != null) {
                    l2.getChunkSource().addRegionTicket(PERSISTENT_TRAINER_TICKET, cpd.pos, PERSISTENT_TRAINER_TICKET_LEVEL, (Object)cpd.pos);
                } else {
                    ModCommon.LOG.warn(String.format("trainer dimension not found '%s' (run '/rctmod trainer unregister_persistent %s' to manually unregister if this message keeps showing up)!", cpd.dim, tid));
                }
            }
        });
        if (RCTMod.getInstance().getServerConfig().logSpawning()) {
            ModCommon.LOG.info("Initialized Trainer Spawner service");
        }
    }

    public void markChunks(Level level, BlockPos blockPos, boolean canSpawn) {
        Integer r;
        SavedBlockPosIntegerMap positions = this.trainerRepelBlocks.get(level.dimension().location());
        if (positions != null && (r = (Integer)positions.get(blockPos)) != null) {
            this.markChunks(level, blockPos, canSpawn, r);
            return;
        }
        this.markChunks(level, blockPos, canSpawn, 3);
    }

    protected void markChunks(Level level, BlockPos blockPos, boolean canSpawn, int radius) {
        ChunkPos c = level.getChunkAt(blockPos).getPos();
        ResourceLocation l = level.dimension().location();
        Map m = this.markedChunks.computeIfAbsent(l, k -> new HashMap());
        int x1 = c.x - radius;
        int x2 = c.x + radius;
        int z1 = c.z - radius;
        int z2 = c.z + radius;
        for (int x = x1; x <= x2; ++x) {
            for (int z = z1; z <= z2; ++z) {
                m.compute(new ChunkPos(x, z), (k, v) -> {
                    if (!canSpawn) {
                        return v == null || v < 1 ? 1 : v + 1;
                    }
                    return v == null || v < 2 ? null : Integer.valueOf(v - 1);
                });
            }
        }
        if (m.isEmpty()) {
            this.markedChunks.remove(l);
        }
        SavedBlockPosIntegerMap rpl = this.trainerRepelBlocks.computeIfAbsent(l, k -> new SavedBlockPosIntegerMap());
        if (!canSpawn) {
            rpl.put(blockPos, radius);
        } else {
            rpl.remove(blockPos);
        }
        if (rpl.isEmpty()) {
            this.trainerRepelBlocks.remove(l);
        }
    }

    public boolean isMarkedAt(Level level, BlockPos pos) {
        return this.isMarkedAt(level, level.getChunkAt(pos).getPos());
    }

    public boolean isMarkedAt(Level level, ChunkPos pos) {
        return this.markedChunks.getOrDefault(level.dimension().location(), Map.of()).getOrDefault(pos, 0) > 0;
    }

    public Set<TrainerMob> getSpawns() {
        return Sets.union(this.mobs, this.persistentMobs);
    }

    public Set<TrainerAssociation> getTASpawns() {
        return Sets.union(this.tas, this.persistentTas);
    }

    public void checkDespawns() {
        TrainerSpawner.checkDespawns(this.mobs.iterator(), this.mobs.size(), TrainerSpawner::despawnTest);
        TrainerSpawner.checkDespawns(this.tas.iterator(), this.tas.size(), TrainerSpawner::despawnTest);
    }

    private static <T extends Mob> void checkDespawns(Iterator<T> it, int count, Predicate<T> despawnPred) {
        ArrayList<Mob> queue = new ArrayList<Mob>(count);
        while (it.hasNext()) {
            Mob mob = (Mob)it.next();
            if (mob.isRemoved() || mob.isPersistenceRequired()) {
                it.remove();
                continue;
            }
            if (!despawnPred.test(mob)) continue;
            queue.add(mob);
        }
        for (Mob mob : queue) {
            mob.remove(Entity.RemovalReason.UNLOADED_TO_CHUNK);
        }
    }

    private static boolean despawnTest(TrainerMob t) {
        return t.shouldDespawn();
    }

    private static boolean despawnTest(TrainerAssociation t) {
        return t.shouldDespawn();
    }

    public void register(TrainerAssociation ta) {
        if ((ta.isPersistenceRequired() ? this.persistentTas.add(ta) : this.tas.add(ta)) && RCTMod.getInstance().getServerConfig().logSpawning()) {
            ((ServerLevel)ta.level()).getChunkSource().removeRegionTicket(PERSISTENT_TRAINER_TICKET, ta.chunkPosition(), PERSISTENT_TRAINER_TICKET_LEVEL, (Object)ta.chunkPosition());
            ModCommon.LOG.info(String.format("Registered '%s' (%sTrainer Association) to spawner%s, at %s (%s)", ta.getDisplayName().getString(), ta.isPersistenceRequired() ? "persistent " : "", ta.getPlayerTarget() != null ? " for " + ta.getPlayerTarget().getDisplayName().getString() : "", ta.blockPosition().toShortString(), ta.level().dimension().location().toString()));
        }
        if (ta.isPersistenceRequired()) {
            this.persistentChunks.put(ta.getStringUUID(), SavedStringChunkPosMap.ChunkPosDim.of((Entity)ta));
        }
    }

    public void unregister(TrainerAssociation ta) {
        if (this.tas.remove((Object)ta) | this.persistentTas.remove((Object)ta) && RCTMod.getInstance().getServerConfig().logSpawning()) {
            ModCommon.LOG.info(String.format("Unregistered '%s' (%sTrainer Association) from spawner%s, at %s (%s)", ta.getDisplayName().getString(), ta.isPersistenceRequired() ? "persistent " : "", ta.getPlayerTarget() != null ? " for " + ta.getPlayerTarget().getDisplayName().getString() : "", ta.blockPosition().toShortString(), ta.level().dimension().location().toString()));
        }
        this.persistentChunks.remove(ta.getStringUUID());
    }

    public void register(TrainerMob mob) {
        String identity = RCTMod.getInstance().getTrainerManager().getData(mob).getTrainerTeam().getIdentity();
        if (mob.isPersistenceRequired()) {
            ((ServerLevel)mob.level()).getChunkSource().removeRegionTicket(PERSISTENT_TRAINER_TICKET, mob.chunkPosition(), PERSISTENT_TRAINER_TICKET_LEVEL, (Object)mob.chunkPosition());
            this.persistentChunks.put(mob.getStringUUID(), SavedStringChunkPosMap.ChunkPosDim.of((Entity)mob));
            this.persistentMobs.add(mob);
        }
        if (!this.spawns.containsKey(mob.getStringUUID())) {
            IServerConfig config;
            UUID originPlayer = mob.getOriginPlayer();
            if (originPlayer != null) {
                this.playerSpawns.compute(originPlayer.toString(), (key, value) -> value == null ? 1 : value + 1);
            }
            this.identities.compute(identity, (key, value) -> value == null ? 1 : value + 1);
            this.spawns.put(mob.getStringUUID(), 0);
            if (!mob.isPersistenceRequired()) {
                this.mobs.add(mob);
            }
            if ((config = RCTMod.getInstance().getServerConfig()).logSpawning()) {
                ModCommon.LOG.info(String.format("Registered%strainer '%s' (%s) to spawner, attached to %s (%d/%d), (%d/%d)", mob.isPersistenceRequired() ? " persistent " : " ", mob.getTrainerId(), mob.getStringUUID(), originPlayer, this.getSpawnCount(originPlayer), config.maxTrainersPerPlayer(), this.getSpawnCount(), config.maxTrainersTotal()));
            }
        }
    }

    public void unregister(TrainerMob mob) {
        if (this.spawns.containsKey(mob.getStringUUID())) {
            String identity = RCTMod.getInstance().getTrainerManager().getData(mob).getTrainerTeam().getIdentity();
            UUID originPlayer = mob.getOriginPlayer();
            if (originPlayer != null) {
                this.playerSpawns.compute(originPlayer.toString(), (key, value) -> value == null || value <= 1 ? null : Integer.valueOf(value - 1));
            }
            this.identities.compute(identity, (key, value) -> value == null || value <= 1 ? null : Integer.valueOf(value - 1));
            this.spawns.remove(mob.getStringUUID());
            this.persistentChunks.remove(mob.getStringUUID());
            this.persistentMobs.remove((Object)mob);
            this.mobs.remove((Object)mob);
            IServerConfig config = RCTMod.getInstance().getServerConfig();
            if (config.logSpawning()) {
                ModCommon.LOG.info(String.format("Unregistered%strainer '%s' (%s) from spawner, attached to %s (%d/%d), (%d/%d)", mob.isPersistenceRequired() ? " persistent " : " ", mob.getTrainerId(), mob.getStringUUID(), originPlayer, this.getSpawnCount(originPlayer), config.maxTrainersPerPlayer(), this.getSpawnCount(), config.maxTrainersTotal()));
            }
        }
    }

    public void unregisterPersistent(String mobUUID) {
        for (TrainerMob m : List.copyOf(this.persistentMobs)) {
            if (!m.getStringUUID().equals(mobUUID)) continue;
            m.setPersistent(false);
            return;
        }
    }

    public boolean isRegistered(TrainerMob mob) {
        return this.spawns.containsKey(mob.getStringUUID());
    }

    public void notifyChangeTrainerId(TrainerMob mob, String newTrainerId) {
        if (this.spawns.containsKey(mob.getStringUUID())) {
            ModCommon.LOG.info(String.format("Changing trainer id '%s' -> '%s' (%s)", mob.getTrainerId(), newTrainerId, mob.getStringUUID()));
            String identity = RCTMod.getInstance().getTrainerManager().getData(mob).getTrainerTeam().getIdentity();
            String newIdentity = RCTMod.getInstance().getTrainerManager().getData(newTrainerId).getTrainerTeam().getIdentity();
            this.identities.compute(identity, (key, value) -> value == null || value <= 1 ? null : Integer.valueOf(value - 1));
            this.identities.compute(newIdentity, (key, value) -> value == null ? 1 : value + 1);
        }
    }

    public void notifyChangeOriginPlayer(TrainerMob mob, UUID newOriginPlayer) {
        if (this.spawns.containsKey(mob.getStringUUID())) {
            UUID originPlayer = mob.getOriginPlayer();
            if (originPlayer != null) {
                this.playerSpawns.compute(originPlayer.toString(), (key, value) -> value == null || value <= 1 ? null : Integer.valueOf(value - 1));
            }
            if (newOriginPlayer != null) {
                this.playerSpawns.compute(newOriginPlayer.toString(), (key, value) -> value == null ? 1 : value + 1);
            }
            if (RCTMod.getInstance().getServerConfig().logSpawning()) {
                ModCommon.LOG.info(String.format("Changed origin player for '%s': '%s' -> '%s'", mob.getTrainerId(), String.valueOf(originPlayer), String.valueOf(newOriginPlayer)));
            }
        }
    }

    public void notifyChangePersistence(TrainerMob mob, boolean newPersistence) {
        if (this.spawns.containsKey(mob.getStringUUID())) {
            this.unregister(mob);
            mob.setPersistent(newPersistence, true);
            this.register(mob);
        }
    }

    public int getSpawnCount() {
        return this.getSpawnCount(false);
    }

    public int getSpawnCount(boolean includePersistent) {
        return Math.max(0, this.spawns.size() - (includePersistent ? 0 : this.persistentMobs.size()));
    }

    public int getSpawnCount(UUID playerId) {
        if (playerId != null) {
            return this.playerSpawns.getOrDefault(playerId.toString(), 0);
        }
        return 0;
    }

    public TrainerMob attemptSpawnFor(Player player, String trainerId, BlockPos pos) {
        return this.attemptSpawnFor(player, trainerId, pos, false, false);
    }

    public TrainerMob attemptSpawnFor(Player player, String trainerId, BlockPos pos, boolean setHome, boolean noOrigin) {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        return this.attemptSpawnFor(player, trainerId, pos, setHome, noOrigin, false, cfg.globalSpawnChance(), cfg.globalSpawnChanceMinimum());
    }

    public TrainerMob attemptSpawnFor(Player player, String trainerId, BlockPos pos, boolean setHome, boolean noOrigin, boolean guaruantee, double globalChance, double globalChanceMin) {
        TrainerMobData tmd;
        Level level = player.level();
        if (RCTMod.getInstance().getTrainerManager().isValidId(trainerId) && (noOrigin || !this.isMarkedAt(level, pos)) && TrainerSpawner.canSpawnAt(level, pos) && this.canSpawnFor(player, noOrigin, globalChance, globalChanceMin) && (tmd = RCTMod.getInstance().getTrainerManager().getData(trainerId)) != null && this.isUnique(tmd.getTrainerTeam().getIdentity(), level, pos) && (guaruantee || this.computeChance(player, trainerId, tmd) >= player.getRandom().nextDouble())) {
            return this.spawnFor(player, trainerId, pos, setHome, noOrigin);
        }
        return null;
    }

    public boolean attemptSpawnFor(Player player) {
        IServerConfig cfg = RCTMod.getInstance().getServerConfig();
        Level level = player.level();
        if (this.canSpawnFor(player, false, cfg.globalSpawnChance(), cfg.globalSpawnChanceMinimum())) {
            for (int i = 0; i < 8; ++i) {
                BlockPos pos = this.nextPos(player);
                if (pos == null || this.isMarkedAt(level, pos)) continue;
                SpawnCandidate spawnCandidate = this.nextSpawnCandidate(player, pos);
                if (spawnCandidate != null) {
                    this.spawnFor(player, spawnCandidate.id, pos);
                }
                return true;
            }
        }
        return false;
    }

    private static boolean canSpawnAt(Level level, BlockPos blockPos) {
        return !level.getBlockState(blockPos.below()).isAir() && level.getBlockState(blockPos).isAir() && level.getBlockState(blockPos.above()).isAir();
    }

    private boolean isUnique(String identity, Level level, BlockPos pos) {
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        int d = 2 * config.uniqueTrainerRadius();
        return d < 0 ? !this.identities.containsKey(identity) : level.getNearbyEntities(TrainerMob.class, TargetingConditions.forNonCombat(), null, AABB.ofSize((Vec3)pos.getCenter(), (double)d, (double)d, (double)d)).stream().map(t -> tm.getData((TrainerMob)((Object)t))).noneMatch(t -> t.getTrainerTeam().getIdentity().equals(identity));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean canSpawnFor(Player player, boolean noOrigin, double globalChance, double globalChanceMin) {
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        int spawnCountPl = this.getSpawnCount(player.getUUID());
        int maxCountPl = config.maxTrainersPerPlayer();
        double chanceRange = Math.max(0.0, globalChance - globalChanceMin);
        if (this.getSpawnCount() >= config.maxTrainersTotal()) return false;
        if (RCTMod.getInstance().getTrainerManager().getPlayerLevel(player) <= 0) return false;
        if (noOrigin) return true;
        if (spawnCountPl >= maxCountPl) return false;
        double d = maxCountPl > 1 ? Math.min(1.0, (double)spawnCountPl / (double)maxCountPl) : 1.0;
        if (!(globalChance - chanceRange * d >= (double)player.getRandom().nextFloat())) return false;
        if (!config.spawningRequiresTrainerCard()) return true;
        if (!TrainerCard.has(player)) return false;
        return true;
    }

    private TrainerMob spawnFor(Player player, String trainerId, BlockPos pos) {
        return this.spawnFor(player, trainerId, pos, false, false);
    }

    private TrainerMob spawnFor(Player player, String trainerId, BlockPos pos, boolean setHome, boolean noOrigin) {
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        Level level = player.level();
        TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().create(level);
        mob.setPos(pos.getCenter().add(0.0, -0.5, 0.0));
        mob.setTrainerId(trainerId);
        if (!noOrigin) {
            mob.setOriginPlayer(player.getUUID());
        }
        level.addFreshEntity((Entity)mob);
        this.register(mob);
        if (setHome) {
            mob.setHomePos(pos);
        }
        if (config.logSpawning()) {
            String trainer = RCTMod.getInstance().getTrainerManager().getData(trainerId).getTrainerTeam().getName().getComponent(new Object[0]).getString();
            Holder biome = level.getBiome(mob.blockPosition());
            ResourceKey dim = level.dimension();
            ModCommon.LOG.info(String.format("Spawned trainer '%s' (%s) at (%d, %d, %d), %s:%s", trainer, mob.getTrainerId(), mob.blockPosition().getX(), mob.blockPosition().getY(), mob.blockPosition().getZ(), dim.location().getPath(), biome.tags().map(t -> t.location().getPath()).reduce("", (t1, t2) -> t1 + " " + t2)));
        }
        return mob;
    }

    public BlockPos nextPos(Player player) {
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        Level level = player.level();
        RandomSource rng = player.getRandom();
        int d = config.maxHorizontalDistanceToPlayers() - config.minHorizontalDistanceToPlayers();
        int dx = (config.minHorizontalDistanceToPlayers() + Math.abs(rng.nextInt()) % d) * (rng.nextBoolean() ? -1 : 1);
        int dz = (config.minHorizontalDistanceToPlayers() + Math.abs(rng.nextInt()) % d) * (rng.nextBoolean() ? -1 : 1);
        int dy = rng.nextBoolean() ? config.maxVerticalDistanceToPlayers() : -config.maxVerticalDistanceToPlayers();
        int x = player.getBlockX() + dx;
        int z = player.getBlockZ() + dz;
        int y = player.getBlockY();
        int yEnd = dy > 0 ? -(dy + 1) : -(dy - 1);
        int yAdd = dy > 0 ? -1 : 1;
        int prevState = -1;
        int validCount = 0;
        for (int i = dy; i != yEnd; i += yAdd) {
            BlockPos pos = new BlockPos(x, y + i, z);
            BlockState bs = level.getBlockState(pos);
            if (bs.is(Blocks.SNOW)) {
                validCount = dy < 0 ? (prevState == 3 ? 1 : 0) : (prevState == 0 ? ++validCount : 0);
                prevState = 2;
            } else if (bs.isFaceSturdy((BlockGetter)level, pos, Direction.UP)) {
                validCount = dy < 0 ? 1 : (prevState == 0 || prevState == 1 ? ++validCount : 0);
                prevState = 3;
            } else if (bs.isAir()) {
                if (dy < 0) {
                    if (validCount > 0) {
                        ++validCount;
                    }
                } else {
                    validCount = Math.min(2, validCount + 1);
                }
                prevState = 0;
            } else {
                prevState = -1;
                validCount = 0;
            }
            if (validCount <= 2) continue;
            return dy < 0 ? pos.below() : pos.above();
        }
        return null;
    }

    private SpawnCandidate nextSpawnCandidate(Player player, BlockPos pos) {
        ArrayList<SpawnCandidate> candidates;
        block2: {
            Set tags;
            Level level;
            block3: {
                boolean dimensionWhitelisted;
                candidates = new ArrayList<SpawnCandidate>();
                level = player.level();
                tags = level.getBiome(pos).tags().map(t -> t.location().getNamespace() + ":" + t.location().getPath()).collect(Collectors.toSet());
                level.getBiome(pos).tags().map(t -> t.location().getPath()).forEach(t -> tags.add(t));
                IServerConfig config = RCTMod.getInstance().getServerConfig();
                boolean dimensionBlacklisted = config.dimensionBlacklist().contains(level.dimension().location().toString());
                boolean bl = dimensionWhitelisted = config.dimensionWhitelist().isEmpty() || config.dimensionWhitelist().contains(level.dimension().location().toString());
                if (dimensionBlacklisted || !dimensionWhitelisted) break block2;
                if (!config.biomeTagBlacklist().stream().noneMatch(tags::contains)) break block2;
                if (config.biomeTagWhitelist().isEmpty()) break block3;
                if (!config.biomeTagWhitelist().stream().anyMatch(tags::contains)) break block2;
            }
            RCTMod.getInstance().getTrainerManager().getAllData(PlayerState.get(player).getCurrentSeries()).filter(e -> {
                if (!this.isUnique(((TrainerMobData)e.getValue()).getTrainerTeam().getIdentity(), level, pos)) return false;
                if (!((TrainerMobData)e.getValue()).getBiomeTagBlacklist().stream().noneMatch(tags::contains)) return false;
                if (((TrainerMobData)e.getValue()).getBiomeTagWhitelist().isEmpty()) return true;
                if (!((TrainerMobData)e.getValue()).getBiomeTagWhitelist().stream().anyMatch(tags::contains)) return false;
                return true;
            }).forEach(e -> {
                double weight = this.computeWeight(player, (String)e.getKey(), (TrainerMobData)e.getValue());
                if (weight > 0.0) {
                    candidates.add(new SpawnCandidate(this, (String)e.getKey(), weight));
                }
            });
        }
        return candidates.size() > 0 ? this.selectRandom(player.getRandom(), candidates) : null;
    }

    private SpawnCandidate selectRandom(RandomSource rng, List<SpawnCandidate> candidates) {
        int i;
        Double totalWeight = candidates.stream().map(c -> c.weight).reduce(0.0, (a, b) -> a + b);
        double r = rng.nextDouble() * totalWeight;
        for (i = 0; i < candidates.size() - 1 && !((r -= candidates.get((int)i).weight) <= 0.0); ++i) {
        }
        return candidates.get(i);
    }

    private double computeChance(Player player, String trainerId, TrainerMobData mobTr) {
        PlayerState ps = PlayerState.get(player);
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        int playerLevel = tm.getPlayerLevel(player);
        int reqLevelCap = mobTr.getRequiredLevelCap();
        int levelCap = ps.getLevelCap();
        double chance = 0.42;
        if (!ps.isKeyTrainer(trainerId)) {
            chance /= (double)NON_KEY_TRAINER_SPAWN_CHANCE_DIV;
        }
        double e = 1.0 - (double)Math.min(config.maxLevelDiff(), Math.abs(Math.min(playerLevel, levelCap) - reqLevelCap)) / (double)config.maxLevelDiff();
        return chance * e * e;
    }

    private double computeWeight(Player player, String trainerId, TrainerMobData mobTr) {
        int diff;
        PlayerState ps = PlayerState.get(player);
        if (!ps.canBattle(trainerId)) {
            return 0.0;
        }
        IServerConfig config = RCTMod.getInstance().getServerConfig();
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        int playerLevel = tm.getPlayerLevel(player);
        int reqLevelCap = mobTr.getRequiredLevelCap();
        int levelCap = ps.getLevelCap();
        float keyTrainerFactor = 1.0f;
        boolean isKey = ps.isKeyTrainer(trainerId);
        if (isKey) {
            float a = (float)(10 - Math.min(9, levelCap / 10)) / 2.0f;
            float b = (float)Math.max(0, reqLevelCap - playerLevel) * a + 1.0f;
            keyTrainerFactor = KEY_TRAINER_SPAWN_WEIGHT_FACTOR / b;
        }
        return (diff = Math.abs(Math.min(playerLevel, levelCap) - reqLevelCap)) > config.maxLevelDiff() ? 0.0 : (double)((float)(config.maxLevelDiff() + 1 - diff) * mobTr.getSpawnWeightFactor() * keyTrainerFactor);
    }

    private class SpawnCandidate {
        public final String id;
        public final double weight;

        public SpawnCandidate(TrainerSpawner trainerSpawner, String id, double weight) {
            this.id = id;
            this.weight = weight;
        }
    }
}

