/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.utils;

import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;

public final class ArrUtils {
    public static List<byte[]> split(byte[] arr, int batchSize) {
        return IntStream.range(0, (arr.length + batchSize - 1) / batchSize).mapToObj(i -> {
            int start = i * batchSize;
            int end = Math.min(start + batchSize, arr.length);
            byte[] sarr = new byte[end - start];
            IntStream.range(start, end).forEach(j -> {
                sarr[j - start] = arr[j];
            });
            return sarr;
        }).toList();
    }

    public static byte[] combine(List<byte[]> batches) {
        Integer size = batches.stream().map(b -> ((byte[])b).length).reduce(0, (b1, b2) -> b1 + b2);
        byte[] arr = new byte[size.intValue()];
        Iterator<byte[]> it = batches.iterator();
        int i = 0;
        while (it.hasNext()) {
            byte[] bs;
            for (byte b3 : bs = it.next()) {
                arr[i++] = b3;
            }
        }
        return arr;
    }

    private ArrUtils() {
    }
}

