/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.renderer;

import com.gitlab.srcmc.rctmod.world.blocks.TrainerSpawnerBlock;
import com.gitlab.srcmc.rctmod.world.blocks.entities.TrainerSpawnerBlockEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import org.joml.Quaternionf;

public class TrainerSpawnerBlockEntityRenderer
implements BlockEntityRenderer<TrainerSpawnerBlockEntity> {
    private static final double PI2 = Math.PI * 2;

    public TrainerSpawnerBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public void render(TrainerSpawnerBlockEntity be, float f, PoseStack poseStack, MultiBufferSource multiBufferSource, int i, int j) {
        double m = be.getRenderItems().size();
        int n = 0;
        double t = (double)((float)be.getLevel().getGameTime() + f) / (TrainerSpawnerBlock.isPowered(be.getBlockState()) ? 20.0 : 60.0);
        int d = (int)t;
        be.renderState.targetP = ((double)(d % 2) + (t - (double)d)) * Math.PI;
        be.renderState.p = TrainerSpawnerBlockEntityRenderer.wlerp(be.renderState.p, be.renderState.targetP, 0.05f, Math.PI * 2);
        Quaternionf rotationY = new Quaternionf().rotateLocalY((float)be.renderState.p);
        double translationY = 0.425 + org.joml.Math.sin((double)(be.renderState.p / 2.0)) * 0.05;
        for (Item item : be.getRenderItems()) {
            double x = m > 1.0 ? 0.5 + 0.15 * org.joml.Math.cos((double)(be.renderState.p + Math.PI * 2 * (double)n / m)) : 0.5;
            double z = m > 1.0 ? 0.5 + 0.15 * org.joml.Math.sin((double)(be.renderState.p + Math.PI * 2 * (double)n / m)) : 0.5;
            poseStack.pushPose();
            poseStack.translate(x, translationY, z);
            poseStack.scale(0.75f, 0.75f, 0.75f);
            poseStack.mulPose(rotationY);
            Minecraft.getInstance().getItemRenderer().renderStatic(item.getDefaultInstance(), ItemDisplayContext.GROUND, i, j, poseStack, multiBufferSource, be.getLevel(), 0);
            poseStack.popPose();
            ++n;
        }
    }

    private static double wlerp(double from, double to, double f, double max) {
        double d = from > to ? to + max - from : to - from;
        double t = from + d * f;
        return t > max ? t - max : t;
    }
}

