/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.blocks;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RodBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;

public class TrainerRepelRodBlock
extends RodBlock
implements SimpleWaterloggedBlock {
    public static final MapCodec<RodBlock> CODEC = TrainerRepelRodBlock.simpleCodec(TrainerRepelRodBlock::new);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.WATERLOGGED;
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public TrainerRepelRodBlock() {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.LIGHTNING_ROD));
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.UP)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public TrainerRepelRodBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public BlockState getStateForPlacement(BlockPlaceContext blockPlaceContext) {
        Level level = blockPlaceContext.getLevel();
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)blockPlaceContext.getClickedFace())).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(level.getFluidState(blockPlaceContext.getClickedPos()).getType() == Fluids.WATER))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(level.hasNeighborSignal(blockPlaceContext.getClickedPos())));
    }

    protected BlockState updateShape(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.getValue((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.scheduleTick(blockPos, (Fluid)Fluids.WATER, Fluids.WATER.getTickDelay((LevelReader)levelAccessor));
        }
        return super.updateShape(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    protected FluidState getFluidState(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)WATERLOGGED) != false ? Fluids.WATER.getSource(false) : super.getFluidState(blockState);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{FACING, WATERLOGGED, POWERED});
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        if (!level.isClientSide) {
            this.updatePowered(level, blockState, blockPos);
            super.neighborChanged(blockState, level, blockPos, block, blockPos2, bl);
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        double z;
        double y;
        double x;
        if (((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            return;
        }
        Direction facing = (Direction)blockState.getValue((Property)FACING);
        switch (facing) {
            case UP: {
                x = 0.5;
                y = 1.2;
                z = 0.5;
                break;
            }
            case DOWN: {
                x = 0.5;
                y = -0.2;
                z = 0.5;
                break;
            }
            case NORTH: {
                x = 0.5;
                y = 0.5;
                z = -0.2;
                break;
            }
            case EAST: {
                x = 1.2;
                y = 0.5;
                z = 0.5;
                break;
            }
            case SOUTH: {
                x = 0.5;
                y = 0.5;
                z = 1.2;
                break;
            }
            case WEST: {
                x = -0.2;
                y = 0.5;
                z = 0.5;
                break;
            }
            default: {
                z = 0.5;
                y = 0.5;
                x = 0.5;
            }
        }
        double d = (double)blockPos.getX() + x + (randomSource.nextDouble() - 0.5) * 0.2;
        double e = (double)blockPos.getY() + y + (randomSource.nextDouble() - 0.5) * 0.2;
        double f = (double)blockPos.getZ() + z + (randomSource.nextDouble() - 0.5) * 0.2;
        level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, d, e, f, 0.0, 0.0, 0.0);
    }

    public MapCodec<? extends RodBlock> codec() {
        return CODEC;
    }

    protected void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        super.onPlace(blockState, level, blockPos, blockState2, bl);
        if (!((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            RCTMod.getInstance().getTrainerSpawner().markChunks(level, blockPos, false);
        }
    }

    protected void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!((Boolean)blockState.getValue((Property)POWERED)).booleanValue()) {
            RCTMod.getInstance().getTrainerSpawner().markChunks(level, blockPos, true);
        }
        super.onRemove(blockState, level, blockPos, blockState2, bl);
    }

    private void updatePowered(Level level, BlockState blockState, BlockPos blockPos) {
        boolean powered = level.hasNeighborSignal(blockPos);
        if ((Boolean)blockState.getValue((Property)POWERED) != powered) {
            level.setBlock(blockPos, (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered)), 2);
        }
    }
}

