/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.LandRandomPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;

public class ForcedStrollAwayGoal
extends RandomStrollGoal {
    private static final float STROLL_CHANCE = 0.0015f;
    private static final int MAX_TARGET_FAILS = 16;
    private static final int MAX_CHUNK_RADIUS = 6;
    private static final int MAX_KEEP_DIRECTION_TICKS = 1200;
    private static final int MIN_KEEP_DIRECTION_TICKS = 300;
    private int[] direction;
    private float probability;
    private int failCount;
    private int tickOfDirection;
    private int keepDirectionTicks;

    public ForcedStrollAwayGoal(PathfinderMob pathfinderMob, double d) {
        this(pathfinderMob, d, 0.15f);
    }

    public ForcedStrollAwayGoal(PathfinderMob pathfinderMob, double d, float p) {
        super(pathfinderMob, d);
        this.probability = p;
    }

    public boolean canUse() {
        if (this.mob.hasControllingPassenger() || this.mob.isPersistenceRequired() || this.mob.getRandom().nextFloat() > this.probability) {
            return false;
        }
        if (!(this.isInMarkedChunk() || this.direction != null && this.mob.tickCount - this.tickOfDirection <= this.keepDirectionTicks)) {
            return false;
        }
        if (!(this.direction != null && this.failCount <= 16 || this.findUnmarkedChunk(this.mob.chunkPosition()))) {
            return false;
        }
        Vec3 pos = this.getPosition();
        if (pos == null) {
            ++this.failCount;
            return false;
        }
        this.wantedX = pos.x;
        this.wantedY = pos.y;
        this.wantedZ = pos.z;
        this.failCount = 0;
        return true;
    }

    public boolean canContinueToUse() {
        if (!this.mob.isInWater() && !this.mob.isInLava() && this.mob.getRandom().nextInt(600) == 0) {
            return false;
        }
        return super.canContinueToUse();
    }

    protected Vec3 getPosition() {
        float r = this.mob.getRandom().nextFloat();
        if (this.mob.isInWaterOrBubble() || this.mob.isInLava()) {
            Vec3 vec3 = LandRandomPos.getPosTowards((PathfinderMob)this.mob, (int)15, (int)7, (Vec3)this.mob.getPosition(1.0f).add((double)((int)(r * (float)this.direction[0])), 0.0, (double)((int)(r * (float)this.direction[1]))));
            return vec3 == null ? super.getPosition() : vec3;
        }
        return this.mob.getRandom().nextFloat() > 0.0015f ? LandRandomPos.getPosTowards((PathfinderMob)this.mob, (int)10, (int)7, (Vec3)this.mob.getPosition(1.0f).add((double)((int)(r * (float)this.direction[0])), 0.0, (double)((int)(r * (float)this.direction[1])))) : super.getPosition();
    }

    public void tick() {
        this.mob.getNavigation().setSpeedModifier(this.mob.isInWater() || this.mob.isInLava() ? 1.0 : this.speedModifier);
        super.tick();
    }

    private boolean isInMarkedChunk() {
        return RCTMod.getInstance().getTrainerSpawner().isMarkedAt(this.mob.level(), this.mob.chunkPosition());
    }

    private boolean findUnmarkedChunk(ChunkPos from) {
        this.direction = null;
        TrainerSpawner spawner = RCTMod.getInstance().getTrainerSpawner();
        int r = this.mob.getRandom().nextInt(6);
        int[] dx = new int[]{-1, 0, 1, -1, 0, 1, -1, 1};
        int[] dz = new int[]{-1, -1, -1, 1, 1, 1, 0, 0};
        for (int i = 1; i <= 6; ++i) {
            for (int j = 0; j < dx.length; ++j) {
                int k = (j + r) % 6;
                ChunkPos pos = new ChunkPos(from.x + dx[k] * i, from.z + dz[k] * i);
                if (spawner.isMarkedAt(this.mob.level(), pos)) continue;
                this.direction = new int[]{(pos.x - from.x) * 128, (pos.z - from.z) * 128};
                this.tickOfDirection = this.mob.tickCount;
                this.keepDirectionTicks = this.mob.getRandom().nextInt(300, 1201);
                return true;
            }
        }
        return false;
    }
}

