/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.MoveToBlockGoal;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.phys.Vec3;

public class MoveToHomePosGoal
extends MoveToBlockGoal {
    private TrainerMob trainerMob;
    private boolean reachedTarget;
    private boolean hasPath;
    private int searchRange;
    private int ticks;

    public MoveToHomePosGoal(TrainerMob trainerMob) {
        this(trainerMob, 0.35, 64);
    }

    public MoveToHomePosGoal(TrainerMob trainerMob, double speedModifier, int searchRange) {
        super((PathfinderMob)trainerMob, speedModifier, searchRange);
        this.trainerMob = trainerMob;
        this.searchRange = searchRange;
    }

    public void start() {
        this.reachedTarget = false;
        this.ticks = 0;
    }

    public double acceptedDistance() {
        return 0.1;
    }

    public boolean canUse() {
        return this.findNearestBlock() && this.isValidTarget((LevelReader)this.trainerMob.level(), this.blockPos);
    }

    public boolean canContinueToUse() {
        return !this.reachedTarget && this.canUse();
    }

    protected boolean findNearestBlock() {
        if (this.trainerMob.getHomePos() != null) {
            this.blockPos = this.trainerMob.getHomePos().below();
            if (this.blockPos.closerToCenterThan((Position)this.trainerMob.position().add(0.0, -0.5, 0.0), (double)this.searchRange)) {
                return true;
            }
        }
        return false;
    }

    protected boolean isValidTarget(LevelReader levelReader, BlockPos blockPos) {
        return !levelReader.getBlockState(blockPos).isAir() && levelReader.getBlockState(blockPos.above()).isAir() && levelReader.getBlockState(blockPos.above().above()).isAir();
    }

    protected void navigate() {
        if (this.ticks % 40 == 0) {
            this.hasPath = this.mob.getNavigation().moveTo((double)this.blockPos.getX() + 0.5, (double)this.blockPos.getY(), (double)this.blockPos.getZ() + 0.5, 0, this.speedModifier);
        }
    }

    protected void centerOnTarget() {
        Vec3 t = this.blockPos.getCenter();
        this.trainerMob.getMoveControl().setWantedPosition(t.x, t.y, t.z, this.speedModifier);
    }

    public void tick() {
        if (this.blockPos.closerToCenterThan((Position)this.mob.position().add(0.0, -0.5, 0.0), this.acceptedDistance())) {
            this.reachedTarget = true;
        } else if (!this.hasPath && this.blockPos.closerToCenterThan((Position)this.mob.position().add(0.0, -0.5, 0.0), 2.0)) {
            this.centerOnTarget();
        } else {
            this.navigate();
            if (++this.ticks > 1200) {
                this.ticks = 0;
            }
        }
    }
}

