/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.items;

import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.client.ModClient;
import com.gitlab.srcmc.rctmod.client.renderer.TargetArrowRenderer;
import com.gitlab.srcmc.rctmod.network.TrainerTargetPayload;
import com.gitlab.srcmc.rctmod.world.entities.TrainerAssociation;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import dev.architectury.networking.NetworkManager;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ShieldItem;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class TrainerCard
extends Item {
    public static final int SYNC_INTERVAL_TICKS = 5;
    private Map<UUID, Integer> playerInvTickCounts = new HashMap<UUID, Integer>();

    public static boolean has(Player player) {
        TrainerCard tc = (TrainerCard)((Object)ModRegistries.Items.TRAINER_CARD.get());
        return player.getInventory().contains(stack -> stack.is((Item)tc));
    }

    public TrainerCard() {
        super(new Item.Properties().stacksTo(1));
    }

    public boolean isFoil(ItemStack stack) {
        return super.isFoil(stack) || ModCommon.player != null && TargetArrowRenderer.getInstance().hasTarget() && ModCommon.player.get().getInventory().contains(stack);
    }

    public void inventoryTick(ItemStack stack, Level level, Entity entity, int i, boolean bl) {
        ServerPlayer player;
        if (!level.isClientSide && entity.tickCount % 5 == 0 && entity instanceof ServerPlayer && entity.tickCount != this.playerInvTickCounts.getOrDefault(player = (ServerPlayer)entity, -1)) {
            this.playerInvTickCounts.put(player.getUUID(), entity.tickCount);
            TrainerPlayerData tpd = RCTMod.getInstance().getTrainerManager().getData((Player)player);
            TrainerSpawner ts = RCTMod.getInstance().getTrainerSpawner();
            if (tpd.isSeriesCompleted() || tpd.isInEmptySeries()) {
                Optional closestTA = ts.getTASpawns().stream().sorted((t1, t2) -> Double.compare(t1.level().dimension().location().equals((Object)player.level().dimension().location()) ? t1.distanceToSqr((Entity)player) : Double.MAX_VALUE, t2.level().dimension().location().equals((Object)player.level().dimension().location()) ? t2.distanceToSqr((Entity)player) : Double.MAX_VALUE)).findFirst();
                if (closestTA.isPresent()) {
                    TrainerAssociation t3 = (TrainerAssociation)((Object)closestTA.get());
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TrainerTargetPayload(t3.position().x, t3.position().y, t3.position().z, !t3.level().dimension().location().equals((Object)player.level().dimension().location())));
                }
            } else {
                PlayerState ps = PlayerState.get((Player)player);
                Optional<TrainerMob> keyTrainer = ts.getSpawns().stream().filter(t -> t.couldBattleAgainst((Entity)player) && ps.isKeyTrainer(t.getTrainerId())).sorted((t1, t2) -> Double.compare(t1.level().dimension().location().equals((Object)player.level().dimension().location()) ? t1.distanceToSqr((Entity)player) : Double.MAX_VALUE, t2.level().dimension().location().equals((Object)player.level().dimension().location()) ? t2.distanceToSqr((Entity)player) : Double.MAX_VALUE)).findFirst();
                if (keyTrainer.isPresent()) {
                    TrainerMob t4 = keyTrainer.get();
                    NetworkManager.sendToPlayer((ServerPlayer)player, (CustomPacketPayload)new TrainerTargetPayload(t4.position().x, t4.position().y, t4.position().z, !t4.level().dimension().location().equals((Object)player.level().dimension().location())));
                }
            }
        }
        super.inventoryTick(stack, level, entity, i, bl);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand interactionHand) {
        if (level.isClientSide) {
            InteractionHand otherHand = interactionHand == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
            boolean isPlacingBlock = false;
            if (player.getItemInHand(otherHand).getItem() instanceof BlockItem) {
                BlockHitResult hit = Item.getPlayerPOVHitResult((Level)level, (Player)player, (ClipContext.Fluid)ClipContext.Fluid.NONE);
                boolean bl = isPlacingBlock = hit.getType() == HitResult.Type.BLOCK;
            }
            if (!(isPlacingBlock || player.isUsingItem() || player.getItemInHand(otherHand).getItem() instanceof ShieldItem)) {
                ModClient.SCREENS.openTrainerCardScreen();
            }
        }
        return InteractionResultHolder.pass((Object)player.getItemInHand(interactionHand));
    }
}

