/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.loot.conditions;

import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;

public record DefeatCountCondition(Comparator comparator, int count) implements LootItemCondition
{
    private static Supplier<LootItemConditionType> TYPE = ModRegistries.LootItemConditions.DEFEAT_COUNT;
    public static final MapCodec<DefeatCountCondition> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Comparator.CODEC.optionalFieldOf("comparator", (Object)Comparator.EQUAL).forGetter(DefeatCountCondition::comparator), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(DefeatCountCondition::count)).apply((Applicative)instance, DefeatCountCondition::new));

    public LootItemConditionType getType() {
        return TYPE.get();
    }

    public boolean test(LootContext lootContext) {
        Object object;
        Player player = (Player)lootContext.getParamOrNull(LootContextParams.LAST_DAMAGE_PLAYER);
        if (player != null && (object = lootContext.getParamOrNull(LootContextParams.THIS_ENTITY)) instanceof TrainerMob) {
            TrainerMob mob = (TrainerMob)((Object)object);
            return this.comparator.test(RCTMod.getInstance().getTrainerManager().getBattleMemory(mob).getDefeatByCount(mob.getTrainerId(), player), this.count);
        }
        return false;
    }

    public static enum Comparator implements StringRepresentable
    {
        EQUAL("==", (a, b) -> a.equals(b)),
        LESS("<", (a, b) -> a < b),
        LESS_OR_EQUAL("<=", (a, b) -> a <= b),
        GREATER(">", (a, b) -> a > b),
        GREATER_OR_EQUAL(">=", (a, b) -> a >= b),
        MODULO("%", (a, b) -> a % b == 0);

        public static final Codec<Comparator> CODEC;
        private BiFunction<Integer, Integer, Boolean> testFunc;
        private String name;

        private Comparator(String name, BiFunction<Integer, Integer, Boolean> testFunc) {
            this.testFunc = testFunc;
            this.name = name;
        }

        public boolean test(int a, int b) {
            return this.testFunc.apply(a, b);
        }

        public String getSerializedName() {
            return this.name;
        }

        static {
            CODEC = StringRepresentable.fromEnum(Comparator::values);
        }
    }
}

