/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.advancements.criteria;

import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemory;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record DefeatCountTriggerInstance(List<String> trainerIds, String trainerType, int count) implements SimpleCriterionTrigger.SimpleInstance
{
    public static final Codec<DefeatCountTriggerInstance> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.list((Codec)Codec.STRING).optionalFieldOf("trainer_ids", List.of()).forGetter(DefeatCountTriggerInstance::trainerIds), (App)Codec.STRING.optionalFieldOf("trainer_type", (Object)"").forGetter(DefeatCountTriggerInstance::trainerType), (App)Codec.INT.optionalFieldOf("count", (Object)1).forGetter(DefeatCountTriggerInstance::count)).apply((Applicative)instance, DefeatCountTriggerInstance::new));

    public boolean matches(ServerPlayer player, TrainerMob mob) {
        TrainerBattleMemory battleMem = RCTMod.getInstance().getTrainerManager().getBattleMemory(mob);
        TrainerMobData mobTr = RCTMod.getInstance().getTrainerManager().getData(mob);
        PlayerState playerState = PlayerState.get((Player)player);
        if (!this.trainerIds.isEmpty() && this.trainerIds.contains(mob.getTrainerId())) {
            return battleMem.getDefeatByCount(mob.getTrainerId(), (Player)player) >= this.count;
        }
        if (!this.trainerType.isEmpty() && this.trainerType.equals(mobTr.getType().name())) {
            return this.count >= 0 ? playerState.getTypeDefeatCount(mobTr.getType(), true) >= (long)this.count : playerState.getTypeDefeatCount(mobTr.getType(), true) >= RCTMod.getInstance().getTrainerManager().getAllData(new String[0]).map(entry -> (TrainerMobData)entry.getValue()).filter(tmd -> tmd.getType().equals(mobTr.getType())).count();
        }
        return this.trainerIds.isEmpty() && this.trainerType.isEmpty() && battleMem.getDefeatByCount(mob.getTrainerId(), (Player)player) >= this.count;
    }

    public Optional<ContextAwarePredicate> player() {
        return Optional.empty();
    }
}

