/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.api.data.Optional;
import java.io.Serializable;
import java.util.List;

public record SeriesMetaData(Text title, Text description, int difficulty, Optional<Integer> initialLevelCap, Optional<Integer> relativeLevelCap, List<List<String>> requiredSeries) implements Comparable<SeriesMetaData>,
Serializable
{
    private final Optional<Integer> initialLevelCap;
    private static final long serialVersionUID = 0L;
    public static final int MIN_DIFFICULTY = 1;
    public static final int MAX_DIFFICULTY = 10;

    public SeriesMetaData(Text title) {
        this(title, Text.empty(), 5);
    }

    public SeriesMetaData(Text title, Text description) {
        this(title, description, 5);
    }

    public SeriesMetaData(Text title, Text description, int difficulty) {
        this(title, description, difficulty, Optional.empty());
    }

    public SeriesMetaData(Text title, Text description, int difficulty, Optional<Integer> initialLevelCap) {
        this(title, description, difficulty, initialLevelCap, Optional.empty());
    }

    public SeriesMetaData(Text title, Text description, int difficulty, Optional<Integer> initialLevelCap, Optional<Integer> relativeLevelCap) {
        this(title, description, difficulty, initialLevelCap, relativeLevelCap, List.of());
    }

    public SeriesMetaData(Text title, Text description, int difficulty, Optional<Integer> initialLevelCap, Optional<Integer> relativeLevelCap, List<List<String>> requiredSeries) {
        this.title = title == null ? Text.empty() : title;
        this.description = description == null ? Text.empty() : description;
        this.difficulty = Math.max(1, Math.min(10, difficulty));
        this.initialLevelCap = initialLevelCap == null ? Optional.empty() : initialLevelCap;
        this.relativeLevelCap = relativeLevelCap == null ? Optional.empty() : relativeLevelCap;
        this.requiredSeries = requiredSeries;
    }

    @Override
    public int compareTo(SeriesMetaData other) {
        int c = Integer.compare(this.difficulty, other.difficulty);
        return c == 0 ? this.title.compareTo(other.title) : c;
    }

    public Optional<Integer> initialLevelCap() {
        if (this.initialLevelCap.has()) {
            Integer v = this.initialLevelCap.get();
            if (v < 0) {
                return Optional.of(1);
            }
            if (v > 100) {
                return Optional.of(100);
            }
        }
        return this.initialLevelCap;
    }
}

