/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.client.screens.widgets.text;

import com.gitlab.srcmc.rctmod.client.screens.widgets.TrainerDataWidget;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.StringWidget;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.Mth;

public class MultiStyleStringWidget
extends StringWidget {
    private static final double PI_HALF = 1.5707963267948966;
    private static final double PI_DOUBLE = Math.PI * 2;
    private final List<Component> styles = new ArrayList<Component>();
    private TrainerDataWidget owner;
    private boolean scrolling;
    private float alignX;

    public MultiStyleStringWidget(TrainerDataWidget owner, Component c, Font f) {
        super(c, f);
        this.styles.add(c);
        this.owner = owner;
        this.active = true;
    }

    public MultiStyleStringWidget(TrainerDataWidget owner, int x, int y, Component c, Font f) {
        super(x, y, c, f);
        this.styles.add(c);
        this.owner = owner;
        this.active = true;
    }

    public MultiStyleStringWidget(TrainerDataWidget owner, int x, int y, int w, int h, Component c, Font f) {
        super(x, y, w, h, c, f);
        this.styles.add(c);
        this.owner = owner;
        this.active = true;
    }

    public MultiStyleStringWidget addStyle(Style style) {
        this.styles.add((Component)this.styles.get(0).copy().withStyle(style));
        return this;
    }

    public void setStyle(int i) {
        this.setMessage(this.styles.get(Math.max(0, Math.min(this.styles.size() - 1, i))));
    }

    public MultiStyleStringWidget scrolling() {
        return this.scrolling(true);
    }

    public MultiStyleStringWidget scrolling(boolean value) {
        this.scrolling = value;
        return this;
    }

    public MultiStyleStringWidget alignRight() {
        super.alignRight();
        this.alignX = 1.0f;
        return this;
    }

    public MultiStyleStringWidget alignLeft() {
        super.alignLeft();
        this.alignX = 0.0f;
        return this;
    }

    public MultiStyleStringWidget alignCenter() {
        super.alignCenter();
        this.alignX = 0.5f;
        return this;
    }

    public void renderWidget(GuiGraphics guiGraphics, int i, int j, float c) {
        Component component = this.getMessage();
        Font font = this.getFont();
        int w = this.getWidth();
        int tw = font.width((FormattedText)component);
        int x = this.getX() + Math.round(this.alignX * (float)(w - tw));
        int h = this.getHeight();
        int y = this.getY() + (h - 9) / 2;
        if (tw > w) {
            if (this.scrolling && this.isHovered(guiGraphics, i, j)) {
                int r = tw - w;
                double d = (double)Util.getMillis() / 1000.0;
                double e = Math.max((double)r * 0.5, 3.0);
                double f = Math.sin(1.5707963267948966 * Math.cos(Math.PI * 2 * d / e)) / 2.0 + 0.5;
                double g = Mth.lerp((double)f, (double)0.0, (double)r);
                int x1 = this.absX();
                int x2 = x1 + this.absWidth();
                int y1 = this.absY();
                int y2 = y1 + this.absHeight();
                guiGraphics.enableScissor(x1, y1, x2, y2);
                guiGraphics.drawString(font, component.getVisualOrderText(), x - (int)(g + 0.5), y, this.getColor());
                guiGraphics.disableScissor();
            } else {
                guiGraphics.drawString(font, this.clip(component, w), x, y, this.getColor());
            }
        } else {
            guiGraphics.drawString(font, component.getVisualOrderText(), x, y, this.getColor());
        }
    }

    protected int absX() {
        return (int)((float)this.owner.getX() + (float)this.getX() * 0.65f + 0.5f) + this.owner.getInnerPadding();
    }

    protected int absY() {
        return (int)((double)((float)this.owner.getY() + (float)this.getY() * 0.65f) - this.owner.getScrollAmount()) + this.owner.getInnerPadding();
    }

    protected int absWidth() {
        return (int)((float)this.getWidth() * 0.65f);
    }

    protected int absHeight() {
        return this.getHeight();
    }

    public boolean isHovered(GuiGraphics guiGraphics, int i, int j) {
        return this.isMouseOver(this.owner.localX(i), this.owner.localY(j));
    }

    private FormattedCharSequence clip(Component component, int w) {
        Font font = this.getFont();
        FormattedText formattedText = font.substrByWidth((FormattedText)component, w - font.width((FormattedText)CommonComponents.ELLIPSIS));
        return Language.getInstance().getVisualOrder(FormattedText.composite((FormattedText[])new FormattedText[]{formattedText, CommonComponents.ELLIPSIS}));
    }
}

