/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.commands;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.commands.utils.SuggestionUtils;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Iterator;
import java.util.Set;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.EntityArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TrainerCommands {
    private TrainerCommands() {
    }

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"rctmod").requires(css -> css.hasPermission(1))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"trainer").then(((LiteralArgumentBuilder)Commands.literal((String)"unregister_persistent").requires(css -> css.hasPermission(2))).then(Commands.argument((String)"mobUUID", (ArgumentType)StringArgumentType.string()).executes(TrainerCommands::mob_unregister_persistent)))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"spawn_for").requires(css -> css.hasPermission(2))).executes(TrainerCommands::mob_spawn_for)).then(Commands.argument((String)"target", (ArgumentType)EntityArgument.player()).executes(TrainerCommands::mob_spawn_for_target)))).then(((LiteralArgumentBuilder)Commands.literal((String)"summon").requires(css -> css.hasPermission(2))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_summon_trainer)).then(Commands.argument((String)"at", (ArgumentType)BlockPosArgument.blockPos()).executes(TrainerCommands::mob_summon_trainer_at))))).then(((LiteralArgumentBuilder)Commands.literal((String)"summon_persistent").requires(css -> css.hasPermission(2))).then(((RequiredArgumentBuilder)RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_summon_persistent_trainer)).then(Commands.argument((String)"at", (ArgumentType)BlockPosArgument.blockPos()).executes(TrainerCommands::mob_summon_persistent_trainer_at))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"get").then(Commands.literal((String)"type").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_get_type)))).then(Commands.literal((String)"max_trainer_wins").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_get_max_trainer_wins)))).then(Commands.literal((String)"max_trainer_defeats").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_get_max_trainer_defeats)))).then(Commands.literal((String)"reward_level_cap").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(TrainerCommands::mob_get_reward_level_cap))))).then(Commands.literal((String)"required_level_cap").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).then(Commands.argument((String)"player", (ArgumentType)EntityArgument.player()).executes(TrainerCommands::mob_get_required_level_cap))))).then(Commands.literal((String)"required_defeats").then(RequiredArgumentBuilder.argument((String)"trainer", (ArgumentType)StringArgumentType.string()).suggests(SuggestionUtils::get_trainer_suggestions).executes(TrainerCommands::mob_get_required_defeats))))));
    }

    private static int mob_summon_trainer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                Level level = player.level();
                TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().create(level);
                mob.setPos(player.blockPosition().above().getCenter().add(0.0, -0.5, 0.0));
                mob.setTrainerId((String)context.getArgument("trainer", String.class));
                level.addFreshEntity((Entity)mob);
                RCTMod.getInstance().getTrainerSpawner().register(mob);
            }
            catch (Exception e) {
                ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int mob_summon_trainer_at(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().create((Level)level);
        mob.setPos(BlockPosArgument.getSpawnablePos(context, (String)"at").getCenter().add(0.0, -0.5, 0.0));
        mob.setTrainerId((String)context.getArgument("trainer", String.class));
        level.addFreshEntity((Entity)mob);
        RCTMod.getInstance().getTrainerSpawner().register(mob);
        return 0;
    }

    private static int mob_summon_persistent_trainer(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                Level level = player.level();
                TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().create(level);
                mob.setPos(player.blockPosition().above().getCenter().add(0.0, -0.5, 0.0));
                mob.setTrainerId((String)context.getArgument("trainer", String.class));
                mob.setPersistent(true);
                level.addFreshEntity((Entity)mob);
                RCTMod.getInstance().getTrainerSpawner().register(mob);
            }
            catch (Exception e) {
                ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int mob_summon_persistent_trainer_at(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        ServerLevel level = ((CommandSourceStack)context.getSource()).getLevel();
        TrainerMob mob = (TrainerMob)TrainerMob.getEntityType().create((Level)level);
        mob.setPos(BlockPosArgument.getSpawnablePos(context, (String)"at").getCenter().add(0.0, -0.5, 0.0));
        mob.setTrainerId((String)context.getArgument("trainer", String.class));
        mob.setPersistent(true);
        level.addFreshEntity((Entity)mob);
        RCTMod.getInstance().getTrainerSpawner().register(mob);
        return 0;
    }

    private static int mob_spawn_for(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = ((CommandSourceStack)context.getSource()).getEntity();
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                RCTMod.getInstance().getTrainerSpawner().attemptSpawnFor(player);
            }
            catch (Exception e) {
                ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.caller_not_a_player"));
        return -1;
    }

    private static int mob_spawn_for_target(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Entity entity = EntityArgument.getEntity(context, (String)"target");
        if (entity instanceof Player) {
            Player player = (Player)entity;
            try {
                RCTMod.getInstance().getTrainerSpawner().attemptSpawnFor(player);
            }
            catch (Exception e) {
                ModCommon.LOG.error(e.getMessage(), (Throwable)e);
            }
            return 0;
        }
        ((CommandSourceStack)context.getSource()).sendFailure((Component)Component.translatable((String)"commands.rctmod.errors.target_not_a_player"));
        return -1;
    }

    private static int mob_get_type(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Text type = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getType().name();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> type.getComponent(new Object[0]), false);
        return 0;
    }

    private static int mob_get_max_trainer_wins(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int max_trainer_wins = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getMaxTrainerWins();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(max_trainer_wins)), false);
        return max_trainer_wins;
    }

    private static int mob_get_max_trainer_defeats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int max_trainer_defeats = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getMaxTrainerDefeats();
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(max_trainer_defeats)), false);
        return max_trainer_defeats;
    }

    private static int mob_get_reward_level_cap(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int reward_level_cap = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getRewardLevelCap((Player)EntityArgument.getPlayer(context, (String)"player"));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(reward_level_cap)), false);
        return reward_level_cap;
    }

    private static int mob_get_required_level_cap(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        int required_level_cap = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getRequiredLevelCap((Player)EntityArgument.getPlayer(context, (String)"player"));
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(required_level_cap)), false);
        return required_level_cap;
    }

    private static int mob_get_required_defeats(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        Iterator it = RCTMod.getInstance().getTrainerManager().getData((String)context.getArgument("trainer", String.class)).getMissingRequirements(Set.of()).iterator();
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        if (it.hasNext()) {
            sb.append((String)it.next());
        }
        while (it.hasNext()) {
            sb.append(", ").append((String)it.next());
        }
        sb.append(']');
        ((CommandSourceStack)context.getSource()).sendSuccess(() -> Component.literal((String)String.valueOf(sb.toString())), false);
        return 0;
    }

    private static int mob_unregister_persistent(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        RCTMod.getInstance().getTrainerSpawner().unregisterPersistent((String)context.getArgument("mobUUID", String.class));
        return 0;
    }
}

