/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.blocks;

import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.world.blocks.entities.TrainerSpawnerBlockEntity;
import com.mojang.serialization.MapCodec;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.DefaultedRegistry;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class TrainerSpawnerBlock
extends BaseEntityBlock {
    public static final MapCodec<TrainerSpawnerBlock> CODEC = TrainerSpawnerBlock.simpleCodec(TrainerSpawnerBlock::new);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;
    public static final BooleanProperty LOOTABLE = BooleanProperty.create((String)"lootable");
    public static final BooleanProperty LOCKED = BooleanProperty.create((String)"locked");

    public static boolean isPowered(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)POWERED);
    }

    static BlockState setPowered(BlockState blockState, boolean value) {
        return (BlockState)blockState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(value));
    }

    public static boolean isLootable(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)LOOTABLE);
    }

    static BlockState setLootable(BlockState blockState, boolean value) {
        return (BlockState)blockState.setValue((Property)LOOTABLE, (Comparable)Boolean.valueOf(value));
    }

    public static boolean isLocked(BlockState blockState) {
        return (Boolean)blockState.getValue((Property)LOCKED);
    }

    public static BlockState setLocked(BlockState blockState, boolean value) {
        return (BlockState)blockState.setValue((Property)LOCKED, (Comparable)Boolean.valueOf(value));
    }

    public TrainerSpawnerBlock() {
        this(BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.STONE_BRICKS).noOcclusion());
    }

    public TrainerSpawnerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)POWERED, (Comparable)Boolean.valueOf(false))).setValue((Property)LOOTABLE, (Comparable)Boolean.valueOf(true))).setValue((Property)LOCKED, (Comparable)Boolean.valueOf(false)));
    }

    protected void onPlace(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        TrainerSpawnerBlock.checkNeighbour(blockState, level, blockPos);
        super.onPlace(blockState, level, blockPos, blockState2, bl);
    }

    protected void onRemove(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        if (!blockState.is(blockState2.getBlock())) {
            level.getBlockEntity(blockPos, (BlockEntityType)ModRegistries.BlockEntityTypes.TRAINER_SPAWNER.get()).ifPresent(be -> be.setOwner(null));
        }
        super.onRemove(blockState, level, blockPos, blockState2, bl);
    }

    protected List<ItemStack> getDrops(BlockState blockState, LootParams.Builder builder) {
        BlockEntity be;
        if (TrainerSpawnerBlock.isLootable(blockState) && (be = (BlockEntity)builder.getOptionalParameter(LootContextParams.BLOCK_ENTITY)) instanceof TrainerSpawnerBlockEntity) {
            TrainerSpawnerBlockEntity sbe = (TrainerSpawnerBlockEntity)be;
            ArrayList<ItemStack> drops = new ArrayList<ItemStack>(super.getDrops(blockState, builder));
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            DefaultedRegistry reg = BuiltInRegistries.ITEM;
            sbe.getTrainerIds().stream().map(tm::getData).filter(t -> t.getSignatureItem() != null && !t.getSignatureItem().isBlank()).map(t -> (Item)reg.get(ResourceLocation.parse((String)t.getSignatureItem()))).distinct().filter(i -> i != null && i != Items.AIR).map(i -> i.getDefaultInstance()).forEach(drops::add);
            return drops;
        }
        return super.getDrops(blockState, builder);
    }

    protected void neighborChanged(BlockState blockState, Level level, BlockPos blockPos, Block block, BlockPos blockPos2, boolean bl) {
        TrainerSpawnerBlock.checkNeighbour(blockState, level, blockPos);
        super.neighborChanged(blockState, level, blockPos, block, blockPos2, bl);
    }

    private static void checkNeighbour(BlockState blockState, Level level, BlockPos blockPos) {
        boolean neigh = level.hasNeighborSignal(blockPos);
        if (neigh != TrainerSpawnerBlock.isPowered(blockState)) {
            level.setBlock(blockPos, TrainerSpawnerBlock.setPowered(blockState, neigh), 2);
        }
    }

    public void animateTick(BlockState blockState, Level level, BlockPos blockPos, RandomSource randomSource) {
        if (TrainerSpawnerBlock.isPowered(blockState)) {
            double d = (double)blockPos.getX() + 0.5 + (randomSource.nextDouble() - 0.5) * 0.2;
            double e = (double)blockPos.getY() + 0.7 + (randomSource.nextDouble() - 0.5) * 0.2;
            double f = (double)blockPos.getZ() + 0.5 + (randomSource.nextDouble() - 0.5) * 0.2;
            level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, d, e, f, 0.0, 0.0, 0.0);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{POWERED, LOOTABLE, LOCKED});
    }

    public ItemInteractionResult useItemOn(ItemStack itemStack, BlockState blockState, Level level, BlockPos blockPos, Player player, InteractionHand interactionHand, BlockHitResult blockHitResult) {
        ItemInteractionResult result = ItemInteractionResult.FAIL;
        BlockEntity blockEntity = level.getBlockEntity(blockPos);
        if (blockEntity instanceof TrainerSpawnerBlockEntity) {
            TrainerSpawnerBlockEntity be = (TrainerSpawnerBlockEntity)blockEntity;
            if (!TrainerSpawnerBlock.isLocked(blockState) && be.addTrainerIdsFromItem(RCTMod.getInstance().getTrainerManager(), itemStack)) {
                if (!level.isClientSide) {
                    itemStack.consume(1, (LivingEntity)player);
                }
                result = ItemInteractionResult.SUCCESS;
            }
        }
        return result;
    }

    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new TrainerSpawnerBlockEntity(blockPos, blockState);
    }

    protected RenderShape getRenderShape(BlockState blockState) {
        return RenderShape.MODEL;
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState blockState, BlockEntityType<T> blockEntityType) {
        return TrainerSpawnerBlock.createTickerHelper(blockEntityType, (BlockEntityType)((BlockEntityType)ModRegistries.BlockEntityTypes.TRAINER_SPAWNER.get()), (BlockEntityTicker)(level.isClientSide ? TrainerSpawnerBlockEntity::clientTick : TrainerSpawnerBlockEntity::serverTick));
    }
}

