/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.phys.Vec3;

public class RandomStrollThroughVillageGoal
extends RandomStrollGoal {
    private static final int SECTION_SCAN_RADIUS = 6;
    private static final int MAX_IDLE_TIME = 400;
    private static final int MIN_IDLE_TIME = 20;
    private static final int MAX_STROLL_TIME = 800;
    private static final int MIN_STROLL_TIME = 100;
    private PathfinderMob mob;
    private BlockPos target;
    private int idleTime;
    private int idleTimer;
    private int strollTime;
    private int strollTimer;
    private int prevMobTickCount;
    private SectionPos prevSection;
    private float probability;
    private Function<Float, Float> probabilityTransform;

    public RandomStrollThroughVillageGoal(PathfinderMob pathfinderMob, double d) {
        this(pathfinderMob, d, v -> v);
    }

    public RandomStrollThroughVillageGoal(PathfinderMob pathfinderMob, double d, Function<Float, Float> probabilityTransform) {
        this(pathfinderMob, d, 0.5f);
    }

    public RandomStrollThroughVillageGoal(PathfinderMob pathfinderMob, double d, float p) {
        this(pathfinderMob, d, p, v -> v);
    }

    public RandomStrollThroughVillageGoal(PathfinderMob pathfinderMob, double d, float p, Function<Float, Float> probabilityTransform) {
        super(pathfinderMob, d, 1, false);
        this.mob = pathfinderMob;
        this.probability = p;
        this.probabilityTransform = probabilityTransform;
    }

    public void start() {
        Vec3 targetV = this.target.getCenter();
        this.idleTime = this.mob.getRandom().nextInt(20, 400);
        this.strollTime = this.mob.getRandom().nextInt(100, 800);
        this.idleTimer = 0;
        this.strollTimer = 0;
        this.prevMobTickCount = this.mob.tickCount;
        this.mob.getNavigation().moveTo(targetV.x, targetV.y, targetV.z, this.speedModifier);
    }

    public boolean canUse() {
        boolean can;
        this.trigger();
        boolean bl = can = this.mob.getRandom().nextFloat() < this.probability && this.tryTargetInRandomSection() && super.canUse();
        if (can && !this.mob.isPersistenceRequired()) {
            this.probability = this.probabilityTransform.apply(Float.valueOf(this.probability)).floatValue();
        }
        return can;
    }

    public boolean canContinueToUse() {
        if (!this.mob.isInWater() && !this.mob.isInLava() && this.mob.getRandom().nextInt(600) == 0) {
            return false;
        }
        if (super.canContinueToUse()) {
            if (!this.mob.isInWater() && !this.mob.isInLava()) {
                if (this.strollTimer < this.strollTime) {
                    this.strollTimer += this.mob.tickCount - this.prevMobTickCount;
                } else {
                    this.mob.getNavigation().stop();
                }
            }
        } else {
            if (!this.mob.isInWater() && !this.mob.isInLava() && this.idleTimer < this.idleTime) {
                this.idleTimer += this.mob.tickCount - this.prevMobTickCount;
                this.prevMobTickCount = this.mob.tickCount;
                return true;
            }
            if (this.tryTargetInRandomSection()) {
                this.start();
                return true;
            }
            return false;
        }
        this.prevMobTickCount = this.mob.tickCount;
        return true;
    }

    protected Vec3 getPosition() {
        return this.target != null ? this.target.getCenter() : null;
    }

    private boolean tryTargetInRandomSection() {
        this.target = this.getRandomPosInVillage();
        return this.target != null;
    }

    private BlockPos getRandomPosInVillage() {
        BlockPos targetPoi;
        SectionPos sectionPos = this.getRandomVillageSection();
        if (sectionPos == null) {
            return null;
        }
        RandomSource rng = this.mob.getRandom();
        if ((double)rng.nextFloat() < 0.15 && (targetPoi = this.getRandomPoiWithinSection(sectionPos)) != null) {
            return this.toGroundPos(targetPoi.west(rng.nextInt(-8, 8)).east(rng.nextInt(-8, 8)));
        }
        return this.toGroundPos(this.getRandomPosWithinSection(sectionPos));
    }

    private SectionPos getRandomVillageSection() {
        if (this.prevSection == null || (double)this.mob.getRandom().nextFloat() < 0.15) {
            ServerLevel serverLevel = (ServerLevel)this.mob.level();
            List list = SectionPos.cube((SectionPos)SectionPos.of((EntityAccess)this.mob), (int)6).filter(arg_0 -> ((ServerLevel)serverLevel).isVillage(arg_0)).collect(Collectors.toList());
            this.prevSection = list.isEmpty() ? null : (SectionPos)list.get(this.mob.getRandom().nextInt(list.size()));
        }
        return this.prevSection;
    }

    private BlockPos getRandomPoiWithinSection(SectionPos sectionPos) {
        ServerLevel serverLevel = (ServerLevel)this.mob.level();
        PoiManager poiManager = serverLevel.getPoiManager();
        List list = poiManager.getInRange(holder -> true, sectionPos.center(), 8, PoiManager.Occupancy.ANY).map(PoiRecord::getPos).collect(Collectors.toList());
        return list.isEmpty() ? null : (BlockPos)list.get(this.mob.getRandom().nextInt(list.size()));
    }

    private BlockPos getRandomPosWithinSection(SectionPos sectionPos) {
        RandomSource rng = this.mob.getRandom();
        return sectionPos.center().east(rng.nextInt(-8, 8)).west(rng.nextInt(-8, 8)).atY(this.mob.getBlockY());
    }

    private BlockPos toGroundPos(BlockPos pos) {
        Level level = this.mob.level();
        BlockPos pUp = pos;
        BlockPos pDn = pos.below();
        while (pUp.getY() - pos.getY() < 24 && pos.getY() - pDn.getY() < 24 && pUp.getY() <= level.getMaxBuildHeight() && pDn.getY() >= level.getMinBuildHeight()) {
            BlockState bs = level.getBlockState(pUp);
            if (bs.entityCanStandOn((BlockGetter)level, pUp, (Entity)this.mob)) {
                return pUp;
            }
            bs = level.getBlockState(pDn);
            if (bs.entityCanStandOn((BlockGetter)level, pDn, (Entity)this.mob)) {
                return pDn;
            }
            pUp = pUp.above();
            pDn = pDn.below();
        }
        return pos;
    }

    public void tick() {
        this.mob.getNavigation().setSpeedModifier(this.mob.isInWater() || this.mob.isInLava() ? 1.0 : this.speedModifier);
        super.tick();
    }
}

