/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities;

import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.ModRegistries;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.config.IClientConfig;
import com.gitlab.srcmc.rctmod.api.data.TrainerBattle;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerMobData;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerBattleMemory;
import com.gitlab.srcmc.rctmod.api.data.save.TrainerPlayerData;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import com.gitlab.srcmc.rctmod.world.blocks.entities.TrainerSpawnerBlockEntity;
import com.gitlab.srcmc.rctmod.world.entities.goals.ForcedStrollAwayGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.LookAtPlayerAndWaitGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.MoveCloseToTargetGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.MoveToHomePosGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.PokemonBattleGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.RandomStrollAwayGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.RandomStrollThroughVillageGoal;
import com.gitlab.srcmc.rctmod.world.entities.goals.RandomWaitGoal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.Npc;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class TrainerMob
extends PathfinderMob
implements Npc {
    private static final EntityDataAccessor<String> DATA_TRAINER_ID = SynchedEntityData.defineId(TrainerMob.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    private static final EntityType<TrainerMob> TYPE = EntityType.Builder.of(TrainerMob::new, (MobCategory)MobCategory.MISC).canSpawnFarFromPlayer().sized(0.6f, 1.95f).build("trainer");
    static final int TICKS_TO_DESPAWN = 600;
    static final int TICKS_TO_DETACH = 600;
    static final int DESPAWN_TICK_SCALE = 20;
    static final int DESPAWN_DISTANCE = 128;
    static final int MAX_PLAYER_TRACKING_RANGE = 128;
    static final int TARGET_UPDATE_INTERVAL = 120;
    static final int BASE_BATTLE_COOLDOWN_TICKS = 400;
    static final int AFK_CHECK_INTERVAL_TICKS = 2400;
    static final int AFK_CHECK_MAX_COUNT = 6;
    static final int AFK_PLAYER_MAX_COUNT = 3;
    static final int UNSEEN_CHECK_INTERVAL_TICKS = 40;
    static final int LINE_OF_SIGHT_CHECK_DISTANCE = 128;
    private Map<UUID, int[]> winsAndDefeats = new HashMap<UUID, int[]>();
    private int cooldown;
    private int extraCooldown;
    private int detachTicks;
    private Player opponent;
    private UUID originPlayer;
    private boolean persistent;
    private int despawnTicks;
    private boolean done;
    private BlockPos homePos;
    private TrainerSpawnerBlockEntity homeSpawner;
    private List<PlayerTransform> nearestTransforms = new ArrayList<PlayerTransform>();
    private int nearestAfkCheckCount;
    private int lastTimeSeen;

    protected TrainerMob(EntityType<? extends PathfinderMob> entityType, Level level) {
        super(entityType, level);
        this.setCustomName((Component)Component.literal((String)"Trainer"));
    }

    public static EntityType<TrainerMob> getEntityType() {
        return TYPE;
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.createMobAttributes().add(Attributes.MOVEMENT_SPEED, 0.5).add(Attributes.FOLLOW_RANGE, 48.0).add(Attributes.MAX_HEALTH, 30.0);
    }

    public boolean canBattleAgainst(Entity e) {
        if (e instanceof Player) {
            Player player = (Player)e;
            RCTMod rct = RCTMod.getInstance();
            TrainerManager tm = rct.getTrainerManager();
            TrainerPlayerData tpd = tm.getData(player);
            TrainerMobData tmd = tm.getData(this);
            TrainerBattleMemory bm = tm.getBattleMemory(this);
            return this.getCooldown() == 0 && !this.isInBattle() && !rct.isInBattle(player) && tm.getActivePokemon(player) > 0 && tm.getPlayerLevel(player) <= tpd.getLevelCap() && tmd.getMissingRequirements(tm.getData(player).getDefeatedTrainerIds()).filter(tid -> tm.getData((String)tid).isOfSeries(tpd.getCurrentSeries())).findFirst().isEmpty() && (tmd.isOfSeries(tpd.getCurrentSeries()) || bm.getDefeatByCount(this.getTrainerId(), player) > 0) && this.couldBattleAgainst(e);
        }
        return false;
    }

    public boolean couldBattleAgainst(Entity e) {
        if (e instanceof Player) {
            Player player = (Player)e;
            return this.isPersistenceRequired() || !this.wasDefeatedBy(player.getUUID()) && !this.wasVictoriousAgainst(player.getUUID());
        }
        return false;
    }

    public void startBattleWith(Player player) {
        Player realPlayer = player.level().getPlayerByUUID(player.getUUID());
        if (player.equals((Object)realPlayer)) {
            if (this.canBattleAgainst((Entity)player)) {
                if (RCTMod.getInstance().makeBattle(this, player)) {
                    this.setOpponent(player);
                    RCTMod.getInstance().getTrainerManager().addBattle(player, this);
                    ChatUtils.reply(this, player, "on_battle_start");
                }
            } else {
                this.replyTo(player);
            }
        } else {
            ModCommon.LOG.warn(String.format("attempt to start battle against '%s' with proxy '%s' for '%s'", this.getDisplayName().getString(), player.getDisplayName().getString(), realPlayer != null ? realPlayer.getDisplayName().getString() : player.getStringUUID()));
        }
    }

    protected void replyTo(Player player) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        TrainerMobData tmd = tm.getData(this);
        TrainerPlayerData tpd = tm.getData(player);
        Optional<String> msr = tmd.getMissingRequirements(tpd.getDefeatedTrainerIds()).filter(tid -> tm.getData((String)tid).isOfSeries(tpd.getCurrentSeries())).findFirst();
        TrainerBattleMemory bm = tm.getBattleMemory(this);
        if (this.isInBattle()) {
            ChatUtils.reply(this, player, "trainer_busy");
        } else if (!this.isPersistenceRequired() && this.wasDefeatedBy(player.getUUID())) {
            ChatUtils.reply(this, player, "trainer_lost");
        } else if (!this.isPersistenceRequired() && this.wasVictoriousAgainst(player.getUUID())) {
            ChatUtils.reply(this, player, "trainer_won");
        } else if (this.getCooldown() > 0) {
            ChatUtils.reply(this, player, "on_cooldown");
        } else if (RCTMod.getInstance().isInBattle(player)) {
            ChatUtils.reply(this, player, "player_busy");
        } else if (!tmd.isOfSeries(tpd.getCurrentSeries()) && bm.getDefeatByCount(this.getTrainerId(), player) == 0) {
            ChatUtils.reply(this, player, "wrong_series");
        } else if (msr.isPresent()) {
            ChatUtils.reply(this, player, "missing_required_trainer_" + tm.getData(msr.get()).getType().id(), "missing_required_trainer");
        } else if (tpd.getLevelCap() < tmd.getRequiredLevelCap(player)) {
            ChatUtils.reply(this, player, "low_level_cap");
        } else if (tm.getPlayerLevel(player) > tpd.getLevelCap()) {
            ChatUtils.reply(this, player, "over_level_cap");
        } else if (tm.getActivePokemon(player) == 0) {
            ChatUtils.reply(this, player, "missing_pokemon");
        } else {
            ChatUtils.reply(this, player, "unknown_reason");
        }
    }

    protected void setOpponent(Player player) {
        this.opponent = player;
    }

    public Player getOpponent() {
        return this.opponent;
    }

    public boolean isInBattle() {
        return this.opponent != null;
    }

    private void addWins(Player player, int wins) {
        this.winsAndDefeats.compute(player.getUUID(), (k, v) -> {
            if (v == null) {
                return new int[]{wins, 0};
            }
            v[0] = v[0] + wins;
            return v;
        });
    }

    private void addDefeats(Player player, int defeats) {
        this.winsAndDefeats.compute(player.getUUID(), (k, v) -> {
            if (v == null) {
                return new int[]{0, defeats};
            }
            v[1] = v[1] + defeats;
            return v;
        });
    }

    public boolean wasDefeatedBy(UUID opponentUUID) {
        int[] wd = this.winsAndDefeats.get(opponentUUID);
        int md = RCTMod.getInstance().getTrainerManager().getData(this).getMaxTrainerDefeats();
        return md >= 0 && wd != null && wd[1] >= md;
    }

    public boolean wasVictoriousAgainst(UUID opponentUUID) {
        int[] wd = this.winsAndDefeats.get(opponentUUID);
        int mw = RCTMod.getInstance().getTrainerManager().getData(this).getMaxTrainerWins();
        return mw >= 0 && wd != null && wd[0] >= mw;
    }

    public boolean wasDefeated() {
        int maxDefeats = RCTMod.getInstance().getTrainerManager().getData(this).getMaxTrainerDefeats();
        if (maxDefeats > 0) {
            for (int[] wd : this.winsAndDefeats.values()) {
                if (wd[1] < maxDefeats) continue;
                return true;
            }
        }
        return false;
    }

    public boolean wasVictorious() {
        int maxWins = RCTMod.getInstance().getTrainerManager().getData(this).getMaxTrainerWins();
        if (maxWins > 0) {
            for (int[] wd : this.winsAndDefeats.values()) {
                if (wd[0] < maxWins) continue;
                return true;
            }
        }
        return false;
    }

    public boolean wasExhausted() {
        return !this.isPersistenceRequired() && (this.wasDefeated() || this.wasVictorious());
    }

    private void udpateCustomName() {
        TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(this);
        this.setCustomName((Component)tmd.getTrainerTeam().getName().getComponent(new Object[0]));
    }

    public Component getDisplayName() {
        String sym;
        TrainerMobData tmd = RCTMod.getInstance().getTrainerManager().getData(this);
        StringBuilder suffix = new StringBuilder();
        MutableComponent cmp = this.getCustomName().copy();
        Level level = this.level();
        boolean showSymbols = false;
        boolean showColors = true;
        boolean showItalic = false;
        if (level.isClientSide) {
            IClientConfig cfg = RCTMod.getInstance().getClientConfig();
            PlayerState ps = PlayerState.get(ModCommon.localPlayer());
            showSymbols = cfg.showTrainerTypeSymbols();
            showColors = cfg.showTrainerTypeColors();
            boolean bl = showItalic = tmd.isOfSeries(ps.getCurrentSeries()) && ps.getTrainerDefeatCount(this.getTrainerId()) == 0;
        }
        if (showSymbols && (sym = tmd.getType().symbol()).length() > 0) {
            suffix.append(' ').append(sym);
        }
        if (showColors) {
            cmp.setStyle(cmp.getStyle().withColor(tmd.getType().color()));
        }
        if (showItalic) {
            cmp.setStyle(cmp.getStyle().withItalic(Boolean.valueOf(true)));
        }
        return cmp.append(suffix.toString());
    }

    public void setTrainerId(String trainerId) {
        String currentId;
        Level level = this.level();
        if (!level.isClientSide && !Objects.equals(currentId = this.getTrainerId(), trainerId)) {
            RCTMod.getInstance().getTrainerSpawner().notifyChangeTrainerId(this, trainerId);
            this.entityData.set(DATA_TRAINER_ID, (Object)trainerId);
            RCTMod.getInstance().getTrainerManager().runAfterLoaded(() -> this.updateTrainerNPC(trainerId));
        }
    }

    private void updateTrainerNPC(String trainerId) {
        try {
            TrainerNPC trainer = (TrainerNPC)ModCommon.RCT.getTrainerRegistry().getById(trainerId, TrainerNPC.class);
            if (trainer != null) {
                trainer.setEntity((LivingEntity)this);
                this.udpateCustomName();
            } else {
                Text text = Text.translatable((String)"commands.rctmod.errors.invalid_trainer_id");
                ModCommon.LOG.warn(text.getComponent(new Object[]{trainerId, this.getStringUUID(), this.blockPosition().toShortString(), this.level().dimension().location().toString()}).getString());
                ChatUtils.broadcastError(this.getServer(), text, 2, trainerId, this.getStringUUID(), this.blockPosition().toShortString(), this.level().dimension().location().toString());
            }
        }
        catch (IllegalArgumentException e) {
            ModCommon.LOG.error(String.format("Invalid trainer id '%s' (%s)", trainerId, this.getStringUUID()), (Throwable)e);
        }
    }

    public String getTrainerId() {
        return (String)this.entityData.get(DATA_TRAINER_ID);
    }

    public void setHomePos(BlockPos blockPos) {
        BlockPos currentHome;
        Level level = this.level();
        if (!level.isClientSide && !Objects.equals(currentHome = this.getHomePos(), blockPos)) {
            this.homePos = blockPos;
        }
    }

    public void setHomeSpawner(TrainerSpawnerBlockEntity be) {
        this.homeSpawner = be;
        this.setHomePos(be != null ? be.getBlockPos().above() : null);
    }

    public BlockPos getHomePos() {
        return this.homePos;
    }

    public TrainerSpawnerBlockEntity getHomeSpawner() {
        return this.homeSpawner;
    }

    public void finishBattle(TrainerBattle battle, boolean defeated) {
        Level level = this.level();
        if (!level.isClientSide && this.isInBattle()) {
            TrainerMobData mobTr = RCTMod.getInstance().getTrainerManager().getData(this);
            Player opponent = this.getOpponent();
            this.cooldown = mobTr.getBattleCooldownTicks() + this.extraCooldown;
            this.extraCooldown += this.cooldown;
            this.setOpponent(null);
            this.setTarget(null);
            if (defeated) {
                if (battle.getInitiatorSideMobs().contains((Object)this)) {
                    battle.getTrainerSidePlayers().forEach(player -> ChatUtils.reply(this, player, "on_battle_lost"));
                } else {
                    TrainerManager tm = RCTMod.getInstance().getTrainerManager();
                    List<Player> initiatorSidePlayer = battle.getInitiatorSidePlayers();
                    Player minWinsPlayer = null;
                    for (Player player2 : initiatorSidePlayer) {
                        ChatUtils.reply(this, player2, "on_battle_lost");
                        minWinsPlayer = minWinsPlayer == null || tm.getBattleMemory(this).getDefeatByCount(this.getTrainerId(), player2) < tm.getBattleMemory(this).getDefeatByCount(this.getTrainerId(), minWinsPlayer) ? player2 : minWinsPlayer;
                    }
                    if (minWinsPlayer != null) {
                        this.dropBattleLoot(mobTr.getLootTableResource(), minWinsPlayer);
                    }
                }
                if (opponent != null) {
                    this.addDefeats(opponent, 1);
                }
            } else {
                if (battle.getInitiatorSideMobs().contains((Object)this)) {
                    battle.getTrainerSidePlayers().forEach(player -> ChatUtils.reply(this, player, "on_battle_won"));
                } else {
                    battle.getInitiatorSidePlayers().forEach(player -> ChatUtils.reply(this, player, "on_battle_won"));
                }
                this.addWins(opponent, 1);
            }
            if (!this.done && (this.wasDefeatedBy(opponent.getUUID()) || this.wasVictoriousAgainst(opponent.getUUID()))) {
                this.detachTicks = 600;
                this.done = true;
            }
        }
    }

    public void cancelBattle() {
        if (this.opponent != null) {
            RCTMod.getInstance().getTrainerManager().removeBattle(this.opponent.getUUID());
            RCTMod.getInstance().stopBattle(this);
            this.setOpponent(null);
        }
    }

    protected void dropBattleLoot(ResourceLocation lootTableResource, Player player) {
        Level level = this.level();
        LootTable lootTable = level.getServer().reloadableRegistries().getLootTable(ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)lootTableResource));
        LootParams.Builder builder = new LootParams.Builder((ServerLevel)level).withParameter(LootContextParams.THIS_ENTITY, (Object)this).withParameter(LootContextParams.ORIGIN, (Object)this.position()).withParameter(LootContextParams.DAMAGE_SOURCE, (Object)level.damageSources().generic()).withParameter(LootContextParams.LAST_DAMAGE_PLAYER, (Object)player).withLuck(RCTMod.getInstance().getTrainerManager().getData(player).getBonusLuck((int)(player.getLuck() * 10.0f)));
        lootTable.getRandomItems(builder.create(LootContextParamSets.ENTITY), this.getLootTableSeed(), arg_0 -> ((TrainerMob)this).spawnAtLocation(arg_0));
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(DATA_TRAINER_ID, (Object)"");
    }

    public void tick() {
        super.tick();
        Level level = this.level();
        if (!level.isClientSide) {
            if (this.cooldown > 0) {
                --this.cooldown;
            } else if (!(this.extraCooldown <= 0 || this.isInBattle() && this.tickCount % 3 != 0)) {
                --this.extraCooldown;
            }
            if (this.done && this.originPlayer != null) {
                if (this.detachTicks > 0) {
                    --this.detachTicks;
                } else {
                    this.setOriginPlayer(null);
                }
            }
            if (this.isInBattle()) {
                Player opponent = this.getOpponent();
                if (opponent != null && !opponent.isAlive()) {
                    this.addWins(opponent, 1);
                    this.cancelBattle();
                }
            } else {
                this.updateTarget();
            }
            if (!this.isRemoved()) {
                RCTMod.getInstance().getTrainerSpawner().register(this);
            }
            if (!this.isRemoved()) {
                this.checkDespawnIfUnseen();
            }
            if (!this.isRemoved()) {
                this.checkDespawnNearAfkPlayers();
            }
        }
    }

    public InteractionResult mobInteract(Player player, InteractionHand interactionHand) {
        TrainerManager tm;
        Level level = this.level();
        if (!(level.isClientSide || (tm = RCTMod.getInstance().getTrainerManager()).isReloadRequired() || tm.isLoading() || PlayerState.get(player) == null)) {
            this.startBattleWith(player);
        }
        return InteractionResult.sidedSuccess((boolean)level.isClientSide);
    }

    public void remove(Entity.RemovalReason reason) {
        if (RCTMod.getInstance().getServerConfig().logSpawning()) {
            ModCommon.LOG.info(String.format("Removed trainer '%s' (%s): %s", this.getTrainerId(), this.getStringUUID(), reason.toString()));
        }
        RCTMod.getInstance().getTrainerSpawner().unregister(this);
        this.cancelBattle();
        super.remove(reason);
    }

    private void updateTarget() {
        if (this.tickCount % 120 == 0) {
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(this);
            this.setTarget(this.level().getNearbyPlayers(TargetingConditions.forNonCombat().ignoreLineOfSight().selector(p -> PlayerState.get((Player)p).getLevelCap() >= tmd.getRequiredLevelCap((Player)p) && !this.wasDefeatedBy(p.getUUID()) && !this.wasVictoriousAgainst(p.getUUID())), (LivingEntity)this, this.getBoundingBox().inflate(128.0)).stream().min((p1, p2) -> Integer.compare(Math.abs(tm.getPlayerLevel((Player)p1) - tmd.getRequiredLevelCap((Player)p1)), Math.abs(tm.getPlayerLevel((Player)p2) - tmd.getRequiredLevelCap((Player)p2)))).orElse(null));
        }
    }

    public void setPersistent(boolean persistent) {
        this.setPersistent(persistent, false);
    }

    public void setPersistent(boolean persistent, boolean silent) {
        if (this.persistent != persistent) {
            if (!silent) {
                RCTMod.getInstance().getTrainerSpawner().notifyChangePersistence(this, persistent);
            }
            this.persistent = persistent;
        }
    }

    public boolean isPersistenceRequired() {
        return this.persistent;
    }

    public boolean shouldBeSaved() {
        return this.isPersistenceRequired();
    }

    public boolean isAlwaysTicking() {
        return true;
    }

    public boolean removeWhenFarAway(double d) {
        return false;
    }

    public boolean saveAsPassenger(CompoundTag tag) {
        return this.isPersistenceRequired() && super.saveAsPassenger(tag);
    }

    public boolean canChangeDimensions(Level level1, Level level2) {
        return false;
    }

    public boolean shouldDespawn() {
        if (++this.despawnTicks % 20 == 0) {
            if (!this.isInBattle() && this.level().getNearestPlayer((Entity)this, (double)Math.max(128, RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers())) == null) {
                return this.despawnTicks >= 600;
            }
            this.despawnTicks = 0;
        }
        return false;
    }

    protected SoundEvent getHurtSound(DamageSource damageSource) {
        return SoundEvents.WANDERING_TRADER_HURT;
    }

    protected SoundEvent getDeathSound() {
        return SoundEvents.WANDERING_TRADER_DEATH;
    }

    public int getCooldown() {
        return this.cooldown;
    }

    public void setOriginPlayer(UUID originPlayer) {
        if (this.originPlayer == null && originPlayer != null || this.originPlayer != null && !this.originPlayer.equals(originPlayer)) {
            RCTMod.getInstance().getTrainerSpawner().notifyChangeOriginPlayer(this, originPlayer);
            this.originPlayer = originPlayer;
        }
    }

    public UUID getOriginPlayer() {
        return this.originPlayer;
    }

    public void addAdditionalSaveData(CompoundTag compoundTag) {
        super.addAdditionalSaveData(compoundTag);
        compoundTag.putInt("Cooldown", this.getCooldown());
        compoundTag.putString("TrainerId", this.getTrainerId());
        compoundTag.putBoolean("Persistent", this.isPersistenceRequired());
        compoundTag.putBoolean("InBattle", this.isInBattle());
        if (this.homePos != null) {
            compoundTag.putLong("HomePos", this.homePos.asLong());
        }
        if (this.originPlayer != null) {
            compoundTag.putUUID("OriginPlayer", this.originPlayer);
        }
    }

    public void readAdditionalSaveData(CompoundTag compoundTag) {
        super.readAdditionalSaveData(compoundTag);
        if (compoundTag.contains("Cooldown")) {
            this.cooldown = compoundTag.getInt("Cooldown");
        }
        if (compoundTag.contains("TrainerId")) {
            this.setTrainerId(compoundTag.getString("TrainerId"));
        }
        if (compoundTag.contains("HomePos")) {
            this.setHomePos(BlockPos.of((long)compoundTag.getLong("HomePos")));
        }
        if (compoundTag.contains("OriginPlayer")) {
            this.setOriginPlayer(compoundTag.getUUID("OriginPlayer"));
        }
        if (compoundTag.contains("Persistent")) {
            this.setPersistent(compoundTag.getBoolean("Persistent"));
        }
    }

    public void aiStep() {
        super.aiStep();
        Level level = this.level();
        if (!level.isClientSide && this.isAlive() && this.random.nextInt(400) == 0 && this.deathTime == 0) {
            this.heal(1.0f);
        }
    }

    protected void registerGoals() {
        int maxTrackingDistance = 2 * RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers();
        this.getNavigation().setCanFloat(true);
        this.goalSelector.addGoal(0, (Goal)new FloatGoal((Mob)this));
        this.goalSelector.addGoal(0, (Goal)new PokemonBattleGoal(this));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Evoker.class, 12.0f, 0.5, 0.5));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vindicator.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vex.class, 8.0f, 0.5, 0.5));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Pillager.class, 15.0f, 0.5, 0.5));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Illusioner.class, 12.0f, 0.5, 0.5));
        this.goalSelector.addGoal(2, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zoglin.class, 10.0f, 0.5, 0.5));
        this.goalSelector.addGoal(2, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
        this.goalSelector.addGoal(3, (Goal)new TemptGoal((PathfinderMob)this, 0.35, item -> item.is((Item)ModRegistries.Items.TRAINER_CARD.get()), false));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerAndWaitGoal((Mob)this, LivingEntity.class, 2.0f, 0.04f, 160, 600));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerAndWaitGoal((Mob)this, LivingEntity.class, 4.0f, 0.004f, 80, 300));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, LivingEntity.class, 8.0f));
        this.goalSelector.addGoal(5, (Goal)new MoveToHomePosGoal(this));
        this.goalSelector.addGoal(6, (Goal)new ForcedStrollAwayGoal(this, 0.35));
        this.goalSelector.addGoal(7, (Goal)new RandomWaitGoal((Mob)this));
        this.goalSelector.addGoal(8, (Goal)new MoveCloseToTargetGoal(this, 0.35, maxTrackingDistance));
        this.goalSelector.addGoal(9, (Goal)new RandomStrollThroughVillageGoal((PathfinderMob)this, (double)0.35f, p -> Float.valueOf(this.wasExhausted() ? p.floatValue() * 0.25f : p.floatValue() * 0.75f)));
        this.goalSelector.addGoal(10, (Goal)new RandomStrollAwayGoal(this, 0.35));
        this.goalSelector.addGoal(12, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.35));
    }

    public boolean isRequiredBy(LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            TrainerMobData tmd = tm.getData(this);
            TrainerPlayerData tpd = tm.getData(player);
            return !tpd.getDefeatedTrainerIds().contains(this.getTrainerId()) && tmd.getMissingRequirements(tpd.getDefeatedTrainerIds()).filter(tid -> tm.getData((String)tid).isOfSeries(tpd.getCurrentSeries())).findFirst().isEmpty();
        }
        return false;
    }

    private void checkDespawnNearAfkPlayers() {
        if (!this.isPersistenceRequired() && this.tickCount % 2400 == 0) {
            if (this.nearestAfkCheckCount >= 6) {
                this.discard();
                return;
            }
            Level level = this.level();
            List<PlayerTransform> nextTransforms = level.getNearbyPlayers(TargetingConditions.forNonCombat(), (LivingEntity)this, this.getHitbox().inflate((double)RCTMod.getInstance().getServerConfig().maxHorizontalDistanceToPlayers())).stream().limit(3L).sorted((p1, p2) -> Integer.compare(p1.getId(), p2.getId())).map(x$0 -> new PlayerTransform(this, (Player)x$0)).toList();
            if (this.nearestTransforms.size() > 0 && nextTransforms.size() == this.nearestTransforms.size() && nextTransforms.containsAll(this.nearestTransforms)) {
                ++this.nearestAfkCheckCount;
            } else {
                this.nearestTransforms = nextTransforms;
                this.nearestAfkCheckCount = 0;
            }
        }
    }

    private void checkDespawnIfUnseen() {
        int maxUnseenTicks = RCTMod.getInstance().getServerConfig().despawnTicksIfUnseen();
        if (maxUnseenTicks > 0 && !this.isPersistenceRequired() && this.tickCount % 40 == 0) {
            if (this.level().players().stream().anyMatch(p -> this.hasLineOfSight((Entity)p))) {
                this.lastTimeSeen = this.tickCount;
            } else if (this.tickCount - this.lastTimeSeen > maxUnseenTicks) {
                this.discard();
            }
        }
    }

    public boolean hasLineOfSight(Entity entity) {
        if (entity.level() != this.level()) {
            return false;
        }
        Vec3 vec3 = new Vec3(this.getX(), this.getEyeY(), this.getZ());
        Vec3 vec32 = new Vec3(entity.getX(), entity.getEyeY(), entity.getZ());
        if (vec32.distanceToSqr(vec3) > 16384.0) {
            return false;
        }
        return this.level().clip(new ClipContext(vec3, vec32, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, (Entity)this)).getType() == HitResult.Type.MISS;
    }

    private class PlayerTransform {
        public final float xRot;
        public final float yRot;
        public final double x;
        public final double y;
        public final double z;

        public PlayerTransform(TrainerMob trainerMob, Player player) {
            if (player != null) {
                this.x = player.position().x;
                this.y = player.position().y;
                this.z = player.position().z;
                this.xRot = player.getXRot();
                this.yRot = player.getYRot();
            } else {
                this.x = 0.0;
                this.y = 0.0;
                this.z = 0.0;
                this.xRot = 0.0f;
                this.yRot = 0.0f;
            }
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z, Float.valueOf(this.xRot), Float.valueOf(this.yRot));
        }

        public boolean equals(Object o) {
            if (o instanceof PlayerTransform) {
                PlayerTransform t = (PlayerTransform)o;
                return this.x == t.x && this.y == t.y && this.z == t.z && this.xRot == t.xRot && this.yRot == t.yRot;
            }
            return false;
        }
    }
}

