/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.world.entities.goals;

import java.util.EnumSet;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;

public class RandomWaitGoal
extends Goal {
    private int minWaitTime;
    private int maxWaitTime;
    private int waitTime;
    private int startTime;
    private float probability;
    private Mob mob;

    public RandomWaitGoal(Mob mob) {
        this(mob, 80, 240, 0.0025f);
    }

    public RandomWaitGoal(Mob mob, int minWaitTime, int maxWaitTime, float probability) {
        this.mob = mob;
        this.minWaitTime = minWaitTime;
        this.maxWaitTime = maxWaitTime;
        this.probability = probability;
        this.setFlags(EnumSet.of(Goal.Flag.MOVE));
    }

    public void start() {
        this.waitTime = this.mob.getRandom().nextInt(this.minWaitTime, this.maxWaitTime + 1);
        this.startTime = this.mob.tickCount;
        this.mob.getNavigation().stop();
        super.start();
    }

    public void stop() {
        super.stop();
    }

    public boolean canUse() {
        return this.probability > this.mob.getRandom().nextFloat();
    }

    public boolean canContinueToUse() {
        return this.mob.tickCount - this.startTime < this.waitTime;
    }
}

