/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api;

import com.cobblemon.mod.common.Cobblemon;
import com.cobblemon.mod.common.api.battles.model.PokemonBattle;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerNPC;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerPlayer;
import com.gitlab.srcmc.rctapi.api.trainer.TrainerRegistry;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.config.IClientConfig;
import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerTeam;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerSpawner;
import com.gitlab.srcmc.rctmod.config.ClientConfig;
import com.gitlab.srcmc.rctmod.config.ServerConfig;
import com.gitlab.srcmc.rctmod.world.entities.TrainerMob;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public final class RCTMod {
    private static Supplier<RCTMod> instanceSupplier = () -> {
        RCTMod defaultInstance = new RCTMod(new TrainerManager(), new TrainerSpawner(), new ClientConfig(), new ServerConfig());
        instanceSupplier = () -> defaultInstance;
        return defaultInstance;
    };
    private TrainerManager trainerManager;
    private TrainerSpawner trainerSpawner;
    private IClientConfig clientConfig;
    private IServerConfig serverConfig;

    private RCTMod(TrainerManager trainerManager, TrainerSpawner trainerSpawner, IClientConfig clientConfig, IServerConfig serverConfig) {
        this.trainerManager = trainerManager;
        this.trainerSpawner = trainerSpawner;
        this.clientConfig = clientConfig;
        this.serverConfig = serverConfig;
    }

    public TrainerManager getTrainerManager() {
        return this.trainerManager;
    }

    public SeriesManager getSeriesManager() {
        return this.trainerManager.getSeriesManager();
    }

    public TrainerSpawner getTrainerSpawner() {
        return this.trainerSpawner;
    }

    public IClientConfig getClientConfig() {
        return this.clientConfig;
    }

    public IServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public boolean makeBattle(TrainerMob mob, class_1657 player) {
        block4: {
            TrainerRegistry reg = ModCommon.RCT.getTrainerRegistry();
            try {
                TrainerPlayer trPlayer = (TrainerPlayer)reg.getById(RCTMod.getInstance().getTrainerManager().getTrainerId(player), TrainerPlayer.class);
                TrainerNPC trNPC = (TrainerNPC)reg.getById(mob.getTrainerId(), TrainerNPC.class);
                if (trPlayer == null) {
                    ModCommon.LOG.warn("Failed to start battle: No trainer registered for player '" + player.method_5476().getString() + "'");
                    break block4;
                }
                if (trNPC == null) {
                    ModCommon.LOG.warn("Failed to start battle: No trainer registered for mob '" + mob.method_5476().getString() + "'");
                    break block4;
                }
                TrainerTeam team = RCTMod.getInstance().getTrainerManager().getData(mob).getTrainerTeam();
                trNPC.setEntity((class_1309)mob);
                return ModCommon.RCT.getBattleManager().startBattle(List.of(trPlayer), List.of(trNPC), team.getBattleFormat(), team.getBattleRules()) != null;
            }
            catch (IllegalArgumentException e) {
                ModCommon.LOG.error("Failed to start battle", (Throwable)e);
            }
        }
        return false;
    }

    public void stopBattle(TrainerMob mob) {
        class_3222 opp = (class_3222)mob.getOpponent();
        if (opp != null) {
            PokemonBattle battle = Cobblemon.INSTANCE.getBattleRegistry().getBattleByParticipatingPlayer(opp);
            if (battle == null) {
                ModCommon.LOG.warn(String.format("Player '%s' is not in a battle", opp.method_5476().getString()));
            } else {
                battle.stop();
            }
        }
    }

    public boolean isInBattle(class_1657 player) {
        return Cobblemon.INSTANCE.getBattleRegistry().getBattleByParticipatingPlayerId(player.method_5667()) != null;
    }

    public static RCTMod getInstance() {
        return instanceSupplier.get();
    }
}

