/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.config;

import com.gitlab.srcmc.rctmod.api.config.IServerConfig;
import java.util.Collection;
import java.util.List;
import net.neoforged.neoforge.common.ModConfigSpec;

public class ServerConfig
implements IServerConfig {
    private final ModConfigSpec.ConfigValue<Double> globalSpawnChanceValue;
    private final ModConfigSpec.ConfigValue<Double> globalSpawnChanceMinimumValue;
    private final ModConfigSpec.ConfigValue<Integer> spawnIntervalTicksValue;
    private final ModConfigSpec.ConfigValue<Integer> spawnIntervalTicksMaximumValue;
    private final ModConfigSpec.ConfigValue<Integer> despawnTicksIfUnseenValue;
    private final ModConfigSpec.ConfigValue<Integer> maxHorizontalDistanceToPlayersValue;
    private final ModConfigSpec.ConfigValue<Integer> minHorizontalDistanceToPlayersValue;
    private final ModConfigSpec.ConfigValue<Integer> maxVerticalDistanceToPlayersValue;
    private final ModConfigSpec.ConfigValue<Integer> uniqueTrainerRadiusValue;
    private final ModConfigSpec.ConfigValue<Integer> maxTrainersPerPlayerValue;
    private final ModConfigSpec.ConfigValue<Integer> maxTrainersTotalValue;
    private final ModConfigSpec.ConfigValue<Integer> maxLevelDiffValue;
    private final ModConfigSpec.ConfigValue<Boolean> spawningRequiresTrainerCardValue;
    private final ModConfigSpec.ConfigValue<Boolean> spawnTrainerAssociationValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> dimensionBlacklistValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> dimensionWhitelistValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> biomeTagBlacklistValue;
    private final ModConfigSpec.ConfigValue<List<? extends String>> biomeTagWhitelistValue;
    private double globalSpawnChanceCached;
    private double globalSpawnChanceMinimumCached;
    private int spawnIntervalTicksCached;
    private int spawnIntervalTicksMaximumCached;
    private int despawnTicksIfUnseenCached;
    private int maxHorizontalDistanceToPlayersCached;
    private int minHorizontalDistanceToPlayersCached;
    private int maxVerticalDistanceToPlayersCached;
    private int uniqueTrainerRadiusCached;
    private int maxTrainersPerPlayerCached;
    private int maxTrainersTotalCached;
    private int maxLevelDiffCached;
    private boolean spawningRequiresTrainerCardCached;
    private boolean spawnTrainerAssociationCached;
    private List<? extends String> dimensionBlacklistCached;
    private List<? extends String> dimensionWhitelistCached;
    private List<? extends String> biomeTagBlacklistCached;
    private List<? extends String> biomeTagWhitelistCached;
    private final ModConfigSpec.ConfigValue<Integer> initialLevelCapValue;
    private final ModConfigSpec.ConfigValue<Integer> relativeLevelCapValue;
    private final ModConfigSpec.ConfigValue<String> initialSeriesValue;
    private final ModConfigSpec.ConfigValue<Boolean> freeroamRequiresCompletedSeriesValue;
    private final ModConfigSpec.ConfigValue<Boolean> allowOverLevelingValue;
    private int initialLevelCapCached;
    private int relativeLevelCapCached;
    private String initialSeriesCached;
    private boolean freeroamRequiresCompletedSeriesCached;
    private boolean allowOverLevelingCached;
    private final ModConfigSpec.ConfigValue<Boolean> logSpawningValue;
    private boolean logSpawningCached;
    private final ModConfigSpec spec;

    public ServerConfig() {
        ModConfigSpec.Builder builder = new ModConfigSpec.Builder();
        builder.push("Spawning");
        this.globalSpawnChanceValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A global factor that determines if a spawn attempt for a trainer is made."}).defineInRange("globalSpawnChance", IServerConfig.super.globalSpawnChance(), 0.0, 1.0);
        this.globalSpawnChanceMinimumValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The chance for a trainer to spawn will shrink towards this value based of how many", "trainers are already spawned in for a player. For example if a player has 0 trainers", "spawned for them the chance will be as configured by globalSpawnChance, if a player", "has barely filled up their spawn cap (maxTrainersPerPlayer), i.e. only one more free", "spot is left, the chance for the last trainer will be as configured by globalSpawnChanceMinimum.", "Set to any value equal to or above globalSpawnChance to disable (e.g. 1.0)."}).defineInRange("globalSpawnChanceMinimum", IServerConfig.super.globalSpawnChanceMinimum(), 0.0, 1.0);
        this.spawnIntervalTicksValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The interval in ticks at which a spawn attempt is made per player."}).defineInRange("spawnIntervalTicks", IServerConfig.super.spawnIntervalTicks(), 1, 0x7FFFFFFE);
        this.spawnIntervalTicksMaximumValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The spawn interval ticks will grow towards this value based of how many trainers are already", "spawned in for a player. For example if a player has 0 trainers spawned for them the spawn", "interval ticks will be as configured by spawnIntervalTicks, if a player has barely filled up their", "spawn cap (maxTrainersPerPlayer), i.e. only one more free spot is left, the spawn interval for the", "last trainer will be as configured by spawnIntervalTicksMaximum. Set to any value equal to or below", "spawnIntervalTicks to disable (e.g. 0)."}).defineInRange("spawnIntervalTicksMaximum", IServerConfig.super.spawnIntervalTicksMaximum(), 0, 0x7FFFFFFE);
        this.despawnTicksIfUnseenValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "(Non persistent) trainers will despawn if they have no line of sight to any player for the configured amount of ticks.", "Set to a negative value to disable this feature (trainers may only despawn if they chunk becomes unloaded in that case)."}).define("despawnTicksIfUnseen", (Object)IServerConfig.super.despawnTicksIfUnseen());
        this.maxHorizontalDistanceToPlayersValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The max horizontal distance a trainer can spawn from players."}).defineInRange("maxHorizontalDistanceToPlayers", IServerConfig.super.maxHorizontalDistanceToPlayers(), 1, 0x7FFFFFFE);
        this.minHorizontalDistanceToPlayersValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The min horizontal distance a trainer can spawn from players."}).defineInRange("minHorizontalDistanceToPlayers", IServerConfig.super.minHorizontalDistanceToPlayers(), 1, 0x7FFFFFFE);
        this.maxVerticalDistanceToPlayersValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The max vertical distance a trainer can spawn from players."}).defineInRange("maxVerticalDistanceToPlayers", IServerConfig.super.maxVerticalDistanceToPlayers(), 1, 0x7FFFFFFE);
        this.uniqueTrainerRadiusValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "By default, this mod prevents the spawning of a trainer if another entity with the same identity", "already exists anywhere in the world (in any dimension). However, if this is set to a positive value,", "the mod will check for the existence of a trainer with the same identity within the specified radius instead."}).define("uniqueTrainerRadius", (Object)IServerConfig.super.uniqueTrainerRadius());
        this.maxTrainersPerPlayerValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Spawn cap of trainers per player."}).defineInRange("maxTrainersPerPlayer", IServerConfig.super.maxTrainersPerPlayer(), 0, 0x7FFFFFFE);
        this.maxTrainersTotalValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Total trainer spawn cap. This value may be increased for servers with higher expected", "player numbers (> 4), for example (|players| + 1)*maxTrainersPerPlayer."}).defineInRange("maxTrainersTotal", IServerConfig.super.maxTrainersTotal(), 0, 0x7FFFFFFE);
        this.maxLevelDiffValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The maximum level difference between the strongest pokemon in the team of a player and the strongest", "pokemon in the team of a trainer to spawn for that player. The spawn weight decreases with a higher", "level difference. Trainers with pokemon above the level cap of a player are excluded."}).defineInRange("maxLevelDiff", IServerConfig.super.maxLevelDiff(), 0, 100);
        this.spawningRequiresTrainerCardValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "If enabled trainers will only spawn naturally around players that have a trainer card", "in their inventory (does not affect trainer spawners)."}).define("spawningRequiresTrainerCard", IServerConfig.super.spawningRequiresTrainerCard());
        this.spawnTrainerAssociationValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "If enabled a single trainer association npc may spawn naturally nearby players that carry a trainer", "card and have either not started a series or completed their current series. One may also spawn nearby", "any player in proximity to a village (at least 3 occupied beds and a village center). These can", "spawn everywhere but will respect the 'dimensionBlacklist' and 'dimensionWhitelist' settings."}).define("spawnTrainerAssociation", IServerConfig.super.spawnTrainerAssociation());
        this.dimensionBlacklistValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A comma separated list of dimensions (e.g. [\"multiworld:spawn\", \"minecraft:the_end\"]).", "In these dimensions trainers will never spawn."}).defineList("dimensionBlacklist", IServerConfig.super.dimensionBlacklist(), String::new, element -> true);
        this.dimensionWhitelistValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A comma separated list of dimensions (e.g. [\"multiworld:spawn\" , \"minecraft:the_end\"]).", "Trainers may only spawn in these dimensions (unless the list is empty)."}).defineList("dimensionWhitelist", IServerConfig.super.dimensionWhitelist(), String::new, element -> true);
        this.biomeTagBlacklistValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A comma separated list of biome tags (e.g. [\"is_overworld\", \"is_forest\"]).", "A biome may not have any of the given tags attached to it, for a trainer to spawn in that biome.", "Trainers may also have additional tags defined by a data pack."}).defineList("biomeTagBlacklist", IServerConfig.super.biomeTagBlacklist(), String::new, element -> true);
        this.biomeTagWhitelistValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "A comma separated list of biome tags (e.g. [\"is_overworld\", \"is_forest\"]).", "A biome must have atleast one of the given tags attached to it, for a trainer to spawn in that", "biome (unless the list is empty). Trainers may also have additional tags defined by a data pack."}).defineList("biomeTagWhitelist", IServerConfig.super.biomeTagWhitelist(), String::new, element -> true);
        builder.pop();
        builder.push("Players");
        this.initialLevelCapValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "Initial level cap of players. Pokemon will not gain any experience if at or", "above the level cap. This value will be capped to not go below the level cap", "for the first trainer of a series (you may use 'relativeLevelCap' for that)."}).defineInRange("initialLevelCap", IServerConfig.super.initialLevelCap(), 1, 0x7FFFFFFE);
        this.relativeLevelCapValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The level cap of a player is based of the strongest pokemon from the party of their next", "required trainer in a series. The relativeLevelCap is added to the resulting value. For", "instance if the next trainer for a player has a Pikachu at level 50, that players level", "cap will be 50 + relativeLevelCap (can be negative)."}).define("relativeLevelCap", (Object)IServerConfig.super.relativeLevelCap());
        this.initialSeriesValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The initial series players are placed in when entering a world for the first time. Apart from any series id", "this value may also be set to one of the special series ids \"empty\" (i.e. no series) or \"freeroam\".", "Note that when setting the initial series to \"freeroam\" it is usually a good idea to also disable", "'freeroamRequiresCompletedSeries'."}).define("initialSeries", (Object)IServerConfig.super.initialSeries());
        this.freeroamRequiresCompletedSeriesValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "The freeroam series will grant a level cap of 100 and allows players to pause the progression of their", "current series. If this option is enabled, players must have completed any other series first to gain", "access to the trade at the trainer association."}).define("freeroamRequiresCompletedSeries", IServerConfig.super.freeroamRequiresCompletedSeries());
        this.allowOverLevelingValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "If enabled the level cap of a players will not prevent their pokemon from gaining experience and leveling up.", "Trainers will still refuse to battle players that carry pokemon above their level cap!"}).define("allowOverLeveling", IServerConfig.super.allowOverLeveling());
        builder.pop();
        builder.push("Debug");
        this.logSpawningValue = builder.comment(new String[]{"\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501\u2501", "If enabled additional information are printed to the log whenever a trainer spawns or despawns."}).define("logSpawning", IServerConfig.super.logSpawning());
        this.spec = builder.build();
    }

    @Override
    public void reload() {
        this.updateCache();
    }

    private void updateCache() {
        this.globalSpawnChanceCached = (Double)this.globalSpawnChanceValue.get();
        this.globalSpawnChanceMinimumCached = (Double)this.globalSpawnChanceMinimumValue.get();
        this.spawnIntervalTicksCached = (Integer)this.spawnIntervalTicksValue.get();
        this.spawnIntervalTicksMaximumCached = (Integer)this.spawnIntervalTicksMaximumValue.get();
        this.despawnTicksIfUnseenCached = (Integer)this.despawnTicksIfUnseenValue.get();
        this.maxHorizontalDistanceToPlayersCached = (Integer)this.maxHorizontalDistanceToPlayersValue.get();
        this.minHorizontalDistanceToPlayersCached = (Integer)this.minHorizontalDistanceToPlayersValue.get();
        this.maxVerticalDistanceToPlayersCached = (Integer)this.maxVerticalDistanceToPlayersValue.get();
        this.uniqueTrainerRadiusCached = (Integer)this.uniqueTrainerRadiusValue.get();
        this.maxTrainersPerPlayerCached = (Integer)this.maxTrainersPerPlayerValue.get();
        this.maxTrainersTotalCached = (Integer)this.maxTrainersTotalValue.get();
        this.maxLevelDiffCached = (Integer)this.maxLevelDiffValue.get();
        this.spawningRequiresTrainerCardCached = (Boolean)this.spawningRequiresTrainerCardValue.get();
        this.spawnTrainerAssociationCached = (Boolean)this.spawnTrainerAssociationValue.get();
        this.dimensionBlacklistCached = List.copyOf((Collection)this.dimensionBlacklistValue.get());
        this.dimensionWhitelistCached = List.copyOf((Collection)this.dimensionWhitelistValue.get());
        this.biomeTagBlacklistCached = List.copyOf((Collection)this.biomeTagBlacklistValue.get());
        this.biomeTagWhitelistCached = List.copyOf((Collection)this.biomeTagWhitelistValue.get());
        this.initialLevelCapCached = (Integer)this.initialLevelCapValue.get();
        this.relativeLevelCapCached = (Integer)this.relativeLevelCapValue.get();
        this.initialSeriesCached = (String)this.initialSeriesValue.get();
        this.freeroamRequiresCompletedSeriesCached = (Boolean)this.freeroamRequiresCompletedSeriesValue.get();
        this.allowOverLevelingCached = (Boolean)this.allowOverLevelingValue.get();
        this.logSpawningCached = (Boolean)this.logSpawningValue.get();
    }

    @Override
    public ModConfigSpec getSpec() {
        return this.spec;
    }

    @Override
    public double globalSpawnChance() {
        return this.globalSpawnChanceCached;
    }

    @Override
    public double globalSpawnChanceMinimum() {
        return this.globalSpawnChanceMinimumCached;
    }

    @Override
    public int spawnIntervalTicks() {
        return this.spawnIntervalTicksCached;
    }

    @Override
    public int spawnIntervalTicksMaximum() {
        return this.spawnIntervalTicksMaximumCached;
    }

    @Override
    public int despawnTicksIfUnseen() {
        return this.despawnTicksIfUnseenCached;
    }

    @Override
    public int maxHorizontalDistanceToPlayers() {
        return this.maxHorizontalDistanceToPlayersCached;
    }

    @Override
    public int minHorizontalDistanceToPlayers() {
        return this.minHorizontalDistanceToPlayersCached;
    }

    @Override
    public int maxVerticalDistanceToPlayers() {
        return this.maxVerticalDistanceToPlayersCached;
    }

    @Override
    public int uniqueTrainerRadius() {
        return this.uniqueTrainerRadiusCached;
    }

    @Override
    public int maxTrainersPerPlayer() {
        return this.maxTrainersPerPlayerCached;
    }

    @Override
    public int maxTrainersTotal() {
        return this.maxTrainersTotalCached;
    }

    @Override
    public int maxLevelDiff() {
        return this.maxLevelDiffCached;
    }

    @Override
    public boolean spawningRequiresTrainerCard() {
        return this.spawningRequiresTrainerCardCached;
    }

    @Override
    public boolean spawnTrainerAssociation() {
        return this.spawnTrainerAssociationCached;
    }

    @Override
    public List<? extends String> dimensionBlacklist() {
        return this.dimensionBlacklistCached;
    }

    @Override
    public List<? extends String> dimensionWhitelist() {
        return this.dimensionWhitelistCached;
    }

    @Override
    public List<? extends String> biomeTagBlacklist() {
        return this.biomeTagBlacklistCached;
    }

    @Override
    public List<? extends String> biomeTagWhitelist() {
        return this.biomeTagWhitelistCached;
    }

    @Override
    public int initialLevelCap() {
        return this.initialLevelCapCached;
    }

    @Override
    public int relativeLevelCap() {
        return this.relativeLevelCapCached;
    }

    @Override
    public String initialSeries() {
        return this.initialSeriesCached;
    }

    @Override
    public boolean freeroamRequiresCompletedSeries() {
        return this.freeroamRequiresCompletedSeriesCached;
    }

    @Override
    public boolean allowOverLeveling() {
        return this.allowOverLevelingCached;
    }

    @Override
    public boolean logSpawning() {
        return this.logSpawningCached;
    }
}

