/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.pack;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.ModCommon;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.Optional;
import com.gitlab.srcmc.rctmod.api.data.pack.DataPackManager;
import com.gitlab.srcmc.rctmod.api.data.pack.IDataPackObject;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerTeam;
import com.gitlab.srcmc.rctmod.api.data.pack.TrainerType;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.JsonUtils;
import com.gitlab.srcmc.rctmod.api.utils.LevelUtils;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_2960;

public class TrainerMobData
implements IDataPackObject,
Serializable {
    private static final long serialVersionUID = 0L;
    private String type = "normal";
    private String signatureItem = "";
    private List<Set<String>> requiredDefeats = new ArrayList<Set<String>>();
    private Set<String> series = new HashSet<String>();
    private Set<String> substitutes = new HashSet<String>();
    private boolean optional;
    private int maxTrainerWins = 3;
    private int maxTrainerDefeats = 1;
    private int battleCooldownTicks = 240;
    private Optional<Integer> relativeLevelCap = Optional.empty();
    private float spawnWeightFactor = 1.0f;
    private Set<String> biomeTagBlacklist = new HashSet<String>();
    private Set<String> biomeTagWhitelist = new HashSet<String>();
    private Optional<Boolean> forceBattleOnSight = Optional.empty();
    private Optional<Float> forceBattleMaxDistance = Optional.empty();
    private Optional<Integer> forceBattleLookTicks = Optional.empty();
    private Optional<Integer> forceBattleMaxLevelDiff = Optional.empty();
    @JsonUtils.Exclude
    private Set<String> followdBy = new HashSet<String>();
    @JsonUtils.Exclude
    private Map<String, Text[]> dialog = new HashMap<String, Text[]>();
    @JsonUtils.Exclude
    private TrainerTeam trainerTeam;
    @JsonUtils.Exclude
    private RLWrapper textureResource;
    @JsonUtils.Exclude
    private RLWrapper lootTableResource;
    @JsonUtils.Exclude
    private String trainerId = "";
    private transient Supplier<TrainerType> lazyType;

    public TrainerMobData() {
        this.textureResource = new RLWrapper(class_2960.method_60655((String)"rctmod", (String)"textures/trainers/default.png"));
        this.lootTableResource = new RLWrapper(class_2960.method_60655((String)"rctmod", (String)"trainers/default"));
        this.trainerTeam = new TrainerTeam();
        this.init();
    }

    public TrainerMobData(TrainerMobData origin) {
        this.type = origin.type;
        this.signatureItem = origin.signatureItem;
        this.relativeLevelCap = origin.relativeLevelCap;
        this.requiredDefeats = List.copyOf(origin.requiredDefeats);
        this.followdBy = Set.copyOf(origin.followdBy);
        this.optional = origin.optional;
        this.maxTrainerWins = origin.maxTrainerWins;
        this.maxTrainerDefeats = origin.maxTrainerDefeats;
        this.battleCooldownTicks = origin.battleCooldownTicks;
        this.biomeTagBlacklist = Set.copyOf(origin.biomeTagBlacklist);
        this.biomeTagWhitelist = Set.copyOf(origin.biomeTagWhitelist);
        this.forceBattleOnSight = origin.forceBattleOnSight;
        this.forceBattleMaxDistance = origin.forceBattleMaxDistance;
        this.forceBattleLookTicks = origin.forceBattleLookTicks;
        this.forceBattleMaxLevelDiff = origin.forceBattleMaxLevelDiff;
        this.dialog = Map.copyOf(origin.dialog);
        this.textureResource = origin.textureResource;
        this.lootTableResource = origin.lootTableResource;
        this.trainerTeam = origin.trainerTeam;
        this.trainerId = origin.trainerId;
        this.init();
    }

    private void init() {
        this.lazyType = () -> {
            TrainerType type = TrainerType.valueOf(this.type.toLowerCase());
            this.lazyType = () -> type;
            return this.lazyType.get();
        };
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        oos.defaultWriteObject();
        oos.writeObject(this.getType());
    }

    private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
        ois.defaultReadObject();
        TrainerType type = TrainerType.registerOrGet(this.type, (TrainerType)ois.readObject());
        this.lazyType = () -> type;
    }

    public TrainerType getType() {
        return this.lazyType.get();
    }

    public int getRewardLevelCap(class_1657 player) {
        TrainerManager tm = RCTMod.getInstance().getTrainerManager();
        String sid = PlayerState.get(player).getCurrentSeries();
        int rlc = this.getRequiredLevelCap(player);
        return this.getFollowedBy().stream().map(tm::getData).filter(tmd -> !tmd.isOptional()).filter(tmd -> tmd.isOfSeries(sid)).map(tmd -> tmd.getRequiredLevelCap(player)).filter(lc -> lc > rlc).min(Integer::compare).orElse(rlc);
    }

    public int getRequiredLevelCap(class_1657 player) {
        return LevelUtils.levelCap(PlayerState.get(player).getCurrentSeries(), this.trainerId);
    }

    public Optional<Integer> getRelativeLevelCap() {
        if (this.relativeLevelCap.has()) {
            Integer v = this.relativeLevelCap.get();
            if (v < 1) {
                ModCommon.LOG.warn(String.format("invalid relativeLevelCap for '%s': expected range is [1, inf) got %d", this.trainerId, v));
                this.relativeLevelCap = Optional.of(1);
            } else if (v > 100) {
                ModCommon.LOG.warn(String.format("invalid relativeLevelCap for '%s': expected range is [1, inf) got %d", this.trainerId, v));
                this.relativeLevelCap = Optional.of(100);
            }
        }
        return this.relativeLevelCap;
    }

    public boolean isOfSeries(String seriesId) {
        return this.series.isEmpty() || this.series.contains(seriesId);
    }

    public Stream<String> getSeries() {
        return this.series.stream();
    }

    public List<Set<String>> getRequiredDefeats(String seriesId) {
        return Collections.unmodifiableList(this.requiredDefeats);
    }

    public Set<String> getSubstitutes() {
        return Collections.unmodifiableSet(this.substitutes);
    }

    public Stream<String> getMissingRequirements(Set<String> defeatedTrainerIds) {
        return this.getMissingRequirements(defeatedTrainerIds, false);
    }

    public Stream<String> getMissingRequirements(Set<String> defeatedTrainerIds, boolean includeAlternatives) {
        return this.requiredDefeats.stream().mapMulti((set, cons) -> {
            if (includeAlternatives) {
                if (set.stream().noneMatch(defeatedTrainerIds::contains)) {
                    set.stream().forEach(cons);
                }
            } else if (!set.isEmpty()) {
                if (set.stream().noneMatch(defeatedTrainerIds::contains)) {
                    cons.accept((String)set.stream().findFirst().get());
                }
            }
        });
    }

    public boolean isOptional() {
        return this.optional;
    }

    public int getMaxTrainerWins() {
        return this.maxTrainerWins;
    }

    public int getMaxTrainerDefeats() {
        return this.maxTrainerDefeats;
    }

    public int getBattleCooldownTicks() {
        return this.battleCooldownTicks;
    }

    public float getSpawnWeightFactor() {
        return this.spawnWeightFactor;
    }

    public Set<String> getBiomeTagBlacklist() {
        return Collections.unmodifiableSet(this.biomeTagBlacklist);
    }

    public Set<String> getBiomeTagWhitelist() {
        return Collections.unmodifiableSet(this.biomeTagWhitelist);
    }

    public Optional<Boolean> getForceBattleOnSight() {
        return this.forceBattleOnSight;
    }

    public Optional<Float> getForceBattleMaxDistance() {
        if (this.forceBattleMaxDistance.has()) {
            Float v = this.forceBattleMaxDistance.get();
            if (v.floatValue() < 0.0f) {
                ModCommon.LOG.warn(String.format("invalid forceBattleMaxDistance for '%s': expected range is [0, 32] got %.2f", this.trainerId, v));
                this.forceBattleMaxDistance = Optional.of(Float.valueOf(0.0f));
            } else if (v.floatValue() > 32.0f) {
                ModCommon.LOG.warn(String.format("invalid forceBattleMaxDistance for '%s': expected range is [0, 32] got %.2f", this.trainerId, v));
                this.forceBattleMaxDistance = Optional.of(Float.valueOf(32.0f));
            }
        }
        return this.forceBattleMaxDistance;
    }

    public Optional<Integer> getForceBattleLookTicks() {
        Integer v;
        if (this.forceBattleLookTicks.has() && (v = this.forceBattleLookTicks.get()) < 0) {
            ModCommon.LOG.warn(String.format("invalid forceBattleLookTicks for '%s': expected range is [0, inf) got %d", this.trainerId, v));
            this.forceBattleLookTicks = Optional.of(0);
        }
        return this.forceBattleLookTicks;
    }

    public Optional<Integer> getForceBattleMaxLevelDiff() {
        Integer v;
        if (this.forceBattleMaxLevelDiff.has() && (v = this.forceBattleMaxLevelDiff.get()) < 0) {
            ModCommon.LOG.warn(String.format("invalid forceBattleMaxLevelDiff for '%s': expected range is [1, inf) got %d", this.trainerId, v));
            this.forceBattleMaxLevelDiff = Optional.of(0);
        }
        return this.forceBattleMaxLevelDiff;
    }

    public Set<String> getFollowedBy() {
        return Collections.unmodifiableSet(this.followdBy);
    }

    public boolean addFollowedBy(String trainerId) {
        return this.followdBy.add(trainerId);
    }

    public boolean removeFollowdBy(String trainerId) {
        return this.followdBy.remove(trainerId);
    }

    public void clearFollowedBy(String trainerId) {
        this.followdBy.clear();
    }

    public Map<String, Text[]> getDialog() {
        return Collections.unmodifiableMap(this.dialog);
    }

    public class_2960 getTextureResource() {
        return this.textureResource.resourceLocation();
    }

    public class_2960 getLootTableResource() {
        return this.lootTableResource.resourceLocation();
    }

    public TrainerTeam getTrainerTeam() {
        return this.trainerTeam;
    }

    public String getSignatureItem() {
        return this.signatureItem;
    }

    @Override
    public void onLoad(DataPackManager dpm, String trainerId, String context) {
        java.util.Optional<TrainerTeam> trainerTeam;
        java.util.Optional<class_2960> lootTableResource = dpm.findResource(trainerId, "loot_table");
        java.util.Optional<class_2960> textureResource = dpm.findResource(trainerId, "textures");
        if (textureResource.isPresent()) {
            this.textureResource = new RLWrapper(textureResource.get());
        }
        if (lootTableResource.isPresent()) {
            this.lootTableResource = new RLWrapper(class_2960.method_60655((String)"rctmod", (String)lootTableResource.get().method_12832().replace("loot_table/", "").replace(".json", "")));
        }
        dpm.loadResource(trainerId, "dialogs", dialog -> {
            this.dialog = dialog;
        }, new TypeToken<Map<String, Text[]>>(this){});
        if (this.dialog == null) {
            this.dialog = new HashMap<String, Text[]>();
        }
        if ((trainerTeam = dpm.loadTrainerTeam(trainerId)).isPresent()) {
            this.trainerTeam = trainerTeam.get();
        }
        this.trainerId = trainerId;
    }

    class RLWrapper
    implements Serializable {
        private static final long serialVersionUID = 0L;
        private transient Supplier<class_2960> rlSup;
        private transient class_2960 rl;
        private String namespace;
        private String path;

        public RLWrapper() {
            this(null);
        }

        public RLWrapper(class_2960 rl) {
            if (rl != null) {
                this.namespace = rl.method_12836();
                this.path = rl.method_12832();
            }
            this.rl = rl;
            this.init();
        }

        private void readObject(ObjectInputStream ois) throws ClassNotFoundException, IOException {
            ois.defaultReadObject();
            this.init();
        }

        public class_2960 resourceLocation() {
            return this.rlSup.get();
        }

        private void init() {
            this.rlSup = () -> {
                if (this.rl == null) {
                    this.rl = class_2960.method_60655((String)this.namespace, (String)this.path);
                }
                this.rlSup = () -> this.rl;
                return this.rl;
            };
        }
    }
}

