/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.srcmc.rctmod.api.data.save;

import com.gitlab.srcmc.rctapi.api.util.Text;
import com.gitlab.srcmc.rctmod.api.RCTMod;
import com.gitlab.srcmc.rctmod.api.data.sync.PlayerState;
import com.gitlab.srcmc.rctmod.api.service.SeriesManager;
import com.gitlab.srcmc.rctmod.api.service.TrainerManager;
import com.gitlab.srcmc.rctmod.api.utils.ChatUtils;
import com.gitlab.srcmc.rctmod.api.utils.LevelUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.class_1657;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_7225;

public class TrainerPlayerData
extends class_18 {
    private Set<String> defeatedTrainerIds = new HashSet<String>();
    private Map<String, Integer> completedSeries = new HashMap<String, Integer>();
    private String currentSeries = "";
    private String previousSeries = "";
    private class_1657 player;
    private boolean currentSeriesCompleted;
    static final int LUCK_DELTA = 8;

    public TrainerPlayerData(class_1657 player) {
        this.player = player;
    }

    public TrainerPlayerData forPlayer(class_1657 player) {
        this.player = player;
        return this;
    }

    public int getLevelCap() {
        return LevelUtils.levelCap(this.player);
    }

    public void updateLevelCap() {
        PlayerState.get(this.player).setLevelCap(this.getLevelCap());
    }

    public Set<String> getDefeatedTrainerIds() {
        return Collections.unmodifiableSet(this.defeatedTrainerIds);
    }

    public boolean addProgressDefeat(String trainerId) {
        return this.addProgressDefeat(trainerId, false);
    }

    private boolean addProgressDefeat(String trainerId, boolean allowPrevious) {
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        SeriesManager.SeriesGraph graph = sm.getGraph(this.currentSeries);
        if (graph == sm.FREEROAM_SERIES) {
            if (allowPrevious) {
                if (!this.previousSeries.isEmpty()) {
                    graph = sm.getGraph(this.previousSeries);
                }
            } else {
                return false;
            }
        }
        if (graph == sm.EMPTY_SERIES) {
            return false;
        }
        SeriesManager.TrainerNode node = graph.get(trainerId);
        boolean[] updated = new boolean[]{false};
        if (node != null) {
            PlayerState ps = PlayerState.get(this.player);
            Stream.concat(Stream.of(node), node.siblings()).filter(tn -> !tn.isAlone()).forEach(tn -> {
                if (this.defeatedTrainerIds.add(tn.id())) {
                    ps.addProgressDefeat(tn.id());
                    this.updateLevelCap();
                    this.updateCurrentSeries();
                    this.method_80();
                    updated[0] = true;
                }
            });
        }
        return updated[0];
    }

    public boolean removeProgressDefeat(String trainerId) {
        SeriesManager.SeriesGraph graph = RCTMod.getInstance().getSeriesManager().getGraph(this.currentSeries);
        SeriesManager.TrainerNode node = graph.get(trainerId);
        boolean[] updated = new boolean[]{false};
        if (node != null) {
            PlayerState ps = PlayerState.get(this.player);
            Stream.concat(Stream.of(node), node.siblings()).forEach(tn -> {
                if (this.defeatedTrainerIds.remove(tn.id())) {
                    ps.removeProgressDefeat(tn.id());
                    this.updateLevelCap();
                    this.method_80();
                    updated[0] = true;
                }
            });
        }
        if (!this.isCurrentSeriesCompleted()) {
            this.currentSeriesCompleted = false;
        }
        return updated[0];
    }

    public boolean removeProgressDefeats() {
        return this.removeProgressDefeats(false);
    }

    protected boolean removeProgressDefeats(boolean forceUpdate) {
        if (forceUpdate || this.defeatedTrainerIds.size() > 0) {
            PlayerState ps = PlayerState.get(this.player);
            ps.removeProgressDefeats();
            this.defeatedTrainerIds.clear();
            this.currentSeriesCompleted = false;
            this.updateLevelCap();
            this.method_80();
            return true;
        }
        return false;
    }

    public boolean isInEmptySeries() {
        return this.currentSeries.isEmpty() || "empty".equals(this.currentSeries);
    }

    public boolean isSeriesCompleted() {
        return this.currentSeriesCompleted || "freeroam".equals(this.currentSeries);
    }

    private boolean isCurrentSeriesCompleted() {
        if (this.canCompleteCurrentSeries()) {
            SeriesManager.SeriesGraph graph = RCTMod.getInstance().getSeriesManager().getGraph(this.currentSeries);
            return graph.size() > 0 && graph.getRemaining(this.defeatedTrainerIds).size() == 0;
        }
        return false;
    }

    private boolean canCompleteCurrentSeries() {
        return !this.currentSeries.isEmpty() && !"empty".equals(this.currentSeries) && !"freeroam".equals(this.currentSeries);
    }

    private boolean testSeriesCompleted() {
        if (this.canCompleteCurrentSeries() && !this.currentSeriesCompleted) {
            boolean bl = this.currentSeriesCompleted = RCTMod.getInstance().getSeriesManager().getGraph(this.currentSeries).getRemaining(this.defeatedTrainerIds).size() == 0;
            if (this.currentSeriesCompleted) {
                this.method_80();
            }
            return this.currentSeriesCompleted;
        }
        return false;
    }

    private void updateCurrentSeries() {
        if (this.testSeriesCompleted()) {
            this.addSeriesCompletion(this.getCurrentSeries());
            this.updateLevelCap();
            ChatUtils.sendTitle(this.player, Text.translatable((String)"gui.rctmod.title.series_completed"), RCTMod.getInstance().getSeriesManager().getGraph(this.getCurrentSeries()).getMetaData().title(), new Object[0]);
        }
    }

    public String getCurrentSeries() {
        return this.currentSeries;
    }

    public String getPreviousSeries() {
        return this.previousSeries;
    }

    public void setCurrentSeries(String seriesId) {
        boolean seriesPaused = "freeroam".equals(seriesId);
        boolean seriesContinued = "freeroam".equals(this.currentSeries) && seriesId != null && seriesId.equals(this.previousSeries);
        this.setCurrentSeries(seriesId, seriesPaused || seriesContinued);
    }

    public void setCurrentSeries(String seriesId, boolean keepProgress) {
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        if (seriesId.isEmpty()) {
            seriesId = "empty";
        }
        if (sm.getGraph(seriesId) == sm.UNKNOWN_SERIES) {
            ChatUtils.sendError(this.player, Text.translatable((String)"commands.rctmod.errors.unknown_series"), seriesId);
            return;
        }
        if (!seriesId.equals(this.currentSeries)) {
            this.previousSeries = this.currentSeries;
            this.currentSeries = seriesId;
            PlayerState.get(this.player).setCurrentSeries(this.currentSeries);
            this.method_80();
        }
        if (!keepProgress) {
            this.removeProgressDefeats(true);
            if (this.currentSeriesCompleted) {
                this.currentSeriesCompleted = false;
                this.method_80();
            }
        } else {
            this.updateLevelCap();
        }
    }

    public Map<String, Integer> getCompletedSeries() {
        return Collections.unmodifiableMap(this.completedSeries);
    }

    public void setSeriesCompletion(String seriesId, int n) {
        Integer m = this.completedSeries.getOrDefault(seriesId, 0);
        this.addSeriesCompletion(seriesId, n - m);
    }

    public void addSeriesCompletion(String seriesId) {
        this.addSeriesCompletion(seriesId, 1);
    }

    public void addSeriesCompletion(String seriesId, int n) {
        this.completedSeries.compute(seriesId, (k, v) -> v == null ? (n > 0 ? Integer.valueOf(n) : null) : (n + v > 0 ? Integer.valueOf(n + v) : null));
    }

    public void removeSeriesCompletion(String seriesId) {
        this.removeSeriesCompletion(seriesId, this.completedSeries.getOrDefault(seriesId, 0));
    }

    public void removeSeriesCompletion(String seriesId, int n) {
        this.addSeriesCompletion(seriesId, -n);
    }

    public float getBonusLuck() {
        return this.getBonusLuck(0);
    }

    public float getBonusLuck(int extra) {
        SeriesManager sm = RCTMod.getInstance().getSeriesManager();
        return (float)TrainerPlayerData.calculateLuck(extra + this.getCompletedSeries().entrySet().stream().map(e -> sm.getGraph((String)e.getKey()).getMetaData().difficulty() * (Integer)e.getValue()).reduce(0, (a, b) -> a + b));
    }

    public void sync() {
        PlayerState ps = PlayerState.get(this.player);
        ps.setLevelCap(this.getLevelCap());
        ps.setCurrentSeries(this.currentSeries);
        this.defeatedTrainerIds.forEach(ps::addProgressDefeat);
        RCTMod.getInstance().getTrainerManager().requiresUpdate(this.player);
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        byte b = 0;
        class_2487 progressDefeats = new class_2487();
        class_2487 completedSeries = new class_2487();
        this.defeatedTrainerIds.forEach(tid -> progressDefeats.method_10567(tid, b));
        this.completedSeries.forEach((s, c) -> completedSeries.method_10569(s, c.intValue()));
        compoundTag.method_10566("progressDefeats", (class_2520)progressDefeats);
        compoundTag.method_10566("completedSeries", (class_2520)completedSeries);
        compoundTag.method_10582("currentSeries", this.currentSeries);
        compoundTag.method_10582("previousSeries", this.previousSeries);
        compoundTag.method_10556("currentSeriesCompleted", this.currentSeriesCompleted);
        return compoundTag;
    }

    static double calculateLuck(int n) {
        double r = 0.0;
        for (int i = 1; i <= n; ++i) {
            r += (1.0 - r) / (double)(i * 8);
        }
        return r;
    }

    public static String filePath(class_1657 player) {
        return String.format("%s.player.%s.stat", "rctmod", player.method_5667().toString());
    }

    public static class Builder {
        private class_1657 player;

        public Builder(class_1657 player) {
            this.player = player;
        }

        public TrainerPlayerData create() {
            TrainerPlayerData tpd = new TrainerPlayerData(this.player);
            tpd.setCurrentSeries(RCTMod.getInstance().getServerConfig().initialSeries());
            tpd.updateLevelCap();
            return tpd;
        }

        public TrainerPlayerData of(class_2487 tag, class_7225.class_7874 provider) {
            TrainerPlayerData tpd = new TrainerPlayerData(this.player);
            TrainerManager tm = RCTMod.getInstance().getTrainerManager();
            if (tag.method_10545("currentSeries")) {
                tpd.setCurrentSeries(tag.method_10558("currentSeries"));
            } else {
                tpd.setCurrentSeries("radicalred");
            }
            tpd.previousSeries = tag.method_10545("previousSeries") ? tag.method_10558("previousSeries") : "";
            if (tag.method_10545("completedSeries")) {
                class_2487 seriesTag = tag.method_10562("completedSeries");
                seriesTag.method_10541().forEach(s -> tpd.setSeriesCompletion((String)s, seriesTag.method_10550(s)));
            }
            if (tag.method_10545("currentSeriesCompleted")) {
                tpd.currentSeriesCompleted = tag.method_10577("currentSeriesCompleted");
            }
            if (!tpd.currentSeries.isEmpty()) {
                if (tag.method_10545("progressDefeats")) {
                    tag.method_10562("progressDefeats").method_10541().forEach(tid -> tpd.addProgressDefeat((String)tid, true));
                } else {
                    class_3218 level = this.player.method_5682().method_30002();
                    tm.getAllData(new String[0]).map(entry -> (String)entry.getKey()).filter(tid -> tm.getBattleMemory(level, (String)tid).getDefeatByCount((String)tid, this.player) > 0).forEach(tid -> tpd.addProgressDefeat((String)tid, true));
                }
            }
            tpd.updateLevelCap();
            return tpd;
        }
    }
}

