/*
 * Decompiled with CFR 0.152.
 */
package com.voxelforge.moreberryuses;

import com.voxelforge.moreberryuses.init.VfMoreBerryUsesModItems;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.CreativeModeTabs;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.BuildCreativeModeTabContentsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="vfmoreberryuses")
public class VfMoreBerryUsesMod {
    public static final Logger LOGGER = LogManager.getLogger(VfMoreBerryUsesMod.class);
    public static final String MODID = "vfmoreberryuses";
    public static final DeferredRegister<CreativeModeTab> CREATIVE_MODE_TABS = DeferredRegister.create((ResourceKey)Registries.CREATIVE_MODE_TAB, (String)"vfmoreberryuses");
    private static final Collection<AbstractMap.SimpleEntry<Runnable, Integer>> workQueue = new ConcurrentLinkedQueue<AbstractMap.SimpleEntry<Runnable, Integer>>();

    public VfMoreBerryUsesMod(FMLJavaModLoadingContext context) {
        MinecraftForge.EVENT_BUS.register((Object)this);
        IEventBus bus = context.getModEventBus();
        VfMoreBerryUsesModItems.REGISTRY.register(bus);
        CREATIVE_MODE_TABS.register(bus);
        bus.addListener(this::addCreative);
    }

    private void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTabKey() == CreativeModeTabs.FOOD_AND_DRINKS) {
            event.accept(VfMoreBerryUsesModItems.BLACKFORESTCAKE);
            event.accept(VfMoreBerryUsesModItems.FRUITSALAD);
            event.accept(VfMoreBerryUsesModItems.GLOWBERRYMUFFIN);
            event.accept(VfMoreBerryUsesModItems.GLOWBERRYSMOOTHIE);
            event.accept(VfMoreBerryUsesModItems.JAM);
            event.accept(VfMoreBerryUsesModItems.SWEETBERRYPIE);
            event.accept(VfMoreBerryUsesModItems.TRAIL_MIX);
        }
    }

    public static void queueServerWork(int tick, Runnable action) {
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER) {
            workQueue.add(new AbstractMap.SimpleEntry<Runnable, Integer>(action, tick));
        }
    }

    @SubscribeEvent
    public void tick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ArrayList actions = new ArrayList();
            workQueue.forEach(work -> {
                work.setValue((Integer)work.getValue() - 1);
                if ((Integer)work.getValue() == 0) {
                    actions.add(work);
                }
            });
            actions.forEach(e -> ((Runnable)e.getKey()).run());
            workQueue.removeAll(actions);
        }
    }
}

