/*
 * Copyright © Magnus Ihse Bursie 2025.
 * This file is released under LGPLv3. See LICENSE for full license details.
 */
package se.icus.mag.elytraindicators.gauges;

import net.minecraft.class_1297;
import net.minecraft.class_310;

public final class ClimbGauge extends Gauge {
    private static final GaugeFacePart[] GAUGE_FACE_PARTS = {
        new GaugeFacePart(1, ALERT),
        new GaugeFacePart(3, CAUTION),
        new GaugeFacePart(5, OK),
        new GaugeFacePart(2, CAUTION),
        new GaugeFacePart(3, ALERT)
    };

    @Override
    public double getRealValue(class_310 mc) {
        class_1297 player = mc.field_1724;
        return (player.field_5971 - player.method_23318()) * 20.0;
    }

    @Override
    public double rescale(double realValue) {
        double offsettedValue = realValue - 1.5;
        double sqrtValue = Math.signum(offsettedValue) * Math.sqrt(Math.abs(offsettedValue));
        if (offsettedValue <= 0) {
            return Math.floor(9.0 - sqrtValue / 5.55 * 3);
        } else {
            return Math.floor(9.0 - offsettedValue * 1.6);
        }
    }

    @Override
    public GaugeFacePart[] getFaceParts() {
        return GAUGE_FACE_PARTS;
    }
}
