/*
 * Copyright © Magnus Ihse Bursie 2025.
 * This file is released under LGPLv3. See LICENSE for full license details.
 */
package se.icus.mag.elytraindicators.gauges;

import net.minecraft.class_310;

public final class PitchGauge extends Gauge {
    private static final GaugeFacePart[] GAUGE_FACE_PARTS = {
        new GaugeFacePart(2, ALERT),
        new GaugeFacePart(2, CAUTION),
        new GaugeFacePart(6, OK),
        new GaugeFacePart(1, CAUTION),
        new GaugeFacePart(3, ALERT)
    };

    @Override
    public double getRealValue(class_310 mc) {
        return mc.field_1724.method_36455();
    }

    @Override
    public double rescale(double realValue) {
        double sqrtValue = Math.signum(realValue) * Math.sqrt(Math.abs(realValue));
        return Math.round(6.2 - sqrtValue / 9.0 * 6.0);
    }

    @Override
    public GaugeFacePart[] getFaceParts() {
        return GAUGE_FACE_PARTS;
    }
}
