/*
 * Copyright © Magnus Ihse Bursie 2025.
 * This file is released under LGPLv3. See LICENSE for full license details.
 */
package se.icus.mag.elytraindicators.gauges;

import net.minecraft.class_1297;
import net.minecraft.class_310;

public final class SpeedGauge extends Gauge {
    private static final GaugeFacePart[] GAUGE_FACE_PARTS = {
        new GaugeFacePart(2, ALERT),
        new GaugeFacePart(3, CAUTION),
        new GaugeFacePart(7, OK),
        new GaugeFacePart(1, CAUTION),
        new GaugeFacePart(1, ALERT)
    };

    @Override
    public double getRealValue(class_310 mc) {
        class_1297 player = mc.field_1724;
        double dx = player.method_23317() - player.field_6038;
        double dy = player.method_23318() - player.field_5971;
        double dz = player.method_23321() - player.field_5989;
        return Math.sqrt(dx * dx + dy * dy + dz * dz) * 20.0;
    }

    @Override
    public double rescale(double realValue) {
        return Math.round(realValue / 48.0 * Gauge.MAX_GAUGE_VALUE);
    }

    @Override
    public GaugeFacePart[] getFaceParts() {
        return GAUGE_FACE_PARTS;
    }
}
