/*
 * Copyright © Magnus Ihse Bursie 2025.
 * This file is released under LGPLv3. See LICENSE for full license details.
 */
package se.icus.mag.elytraindicators.gauges;

import net.minecraft.class_1304;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_310;

public final class WearGauge extends Gauge {
    private static final GaugeFacePart[] GAUGE_FACE_PARTS = {
        new GaugeFacePart(7, OK), new GaugeFacePart(3, CAUTION), new GaugeFacePart(4, ALERT)
    };

    @Override
    public double getRealValue(class_310 mc) {
        class_1799 item = mc.field_1724.method_6118(class_1304.field_6174);
        if (!item.method_31574(class_1802.field_8833)) return 0;

        return ((double) (item.method_7936() - item.method_7919()) / item.method_7936());
    }

    @Override
    public double rescale(double realValue) {
        return Math.round((-19 * realValue * realValue + 36 * realValue - 0.4) / 17.0 * Gauge.MAX_GAUGE_VALUE);
    }

    @Override
    public GaugeFacePart[] getFaceParts() {
        return GAUGE_FACE_PARTS;
    }
}
