/*
 * Copyright © Magnus Ihse Bursie 2025.
 * This file is released under LGPLv3. See LICENSE for full license details.
 */
package se.icus.mag.elytraindicators.render;

import net.minecraft.class_10799;
import net.minecraft.class_1306;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_8012;
import net.minecraft.class_9848;
import se.icus.mag.elytraindicators.ElytraIndicatorsMod;
import se.icus.mag.elytraindicators.gauges.Gauge;

public class ElytraIndicatorsRenderer {
    private IndicatorSize getIndicatorSize() {
        return ElytraIndicatorsMod.getConfig().getIndicatorSize();
    }

    public void render(class_332 context, class_310 mc) {
        if (!(mc.method_1560() instanceof class_1657 playerEntity)) return;
        if (mc.field_1690.field_1842) return;
        if (!mc.field_1724.method_6128()) return;

        boolean rightHandSide = playerEntity.method_6068().method_5928() == class_1306.field_6182;
        int xOffset = rightHandSide ? 98 : -102 - getIndicatorSize().getWidth();
        int x = context.method_51421() / 2 + xOffset;
        int y = context.method_51443() - IndicatorSize.TEXTURE_HEIGHT;

        renderBackground(context, x, y);
        renderGauges(context, mc, x, y);
    }

    private void renderBackground(class_332 context, int x, int y) {
        class_2960 texture = getIndicatorSize().getIdentifier();
        int width = getIndicatorSize().getWidth();
        int height = IndicatorSize.TEXTURE_HEIGHT;

        context.method_25290(class_10799.field_56883, texture, x, y, 0, 0, width, height, width, height);
    }

    private void renderGauges(class_332 context, class_310 mc, int x, int y) {
        for (int slot = 0; slot < Gauge.getGaugeCount(); slot++) {
            Gauge gauge = Gauge.getGauge(slot);
            renderGauge(context, mc, gauge, x + 4 + slot * getIndicatorSize().getGaugeOffset(), y + 4);
        }
    }

    private void renderGauge(class_332 context, class_310 mc, Gauge gauge, int x, int y) {
        int value = gauge.getValue(mc);
        int width = getIndicatorSize().getGaugeWidth();

        // Draw the face (background) of the gauge
        drawQuad(context, x, y, width + 1, 15, class_8012.field_42974, 0xFF);

        int partStart = 0;
        Gauge.GaugeFacePart[] faceParts = gauge.getFaceParts();
        for (var facePart : faceParts) {
            drawQuad(context, x, y + partStart, width, facePart.steps(), facePart.color(), 0xFF);
            partStart += facePart.steps();
        }

        // Draw the marker frame and actual marker
        int markerY = y + Gauge.MAX_GAUGE_VALUE - value;
        drawQuad(context, x - 1, markerY - 1, width + 2, 4, class_8012.field_42973, 0xFF);
        drawQuad(context, x, markerY, width, 2, class_8012.field_42974, 0xB0);
    }

    private static void drawQuad(class_332 context, int x, int y, int width, int height, int color, int alpha) {
        context.method_25294(x, y, x + width, y + height, class_9848.method_61330(alpha, color));
    }
}
