/*
 * Decompiled with CFR 0.152.
 */
package se.icus.mag.elytraindicators.gauges;

import net.minecraft.class_310;
import se.icus.mag.elytraindicators.gauges.ClimbGauge;
import se.icus.mag.elytraindicators.gauges.HeightGauge;
import se.icus.mag.elytraindicators.gauges.PitchGauge;
import se.icus.mag.elytraindicators.gauges.SpeedGauge;
import se.icus.mag.elytraindicators.gauges.WearGauge;

public abstract sealed class Gauge
permits PitchGauge, SpeedGauge, ClimbGauge, HeightGauge, WearGauge {
    private static final Gauge[] GAUGES = new Gauge[]{new PitchGauge(), new SpeedGauge(), new ClimbGauge(), new HeightGauge(), new WearGauge()};
    protected static final int ALERT = 0xFF0000;
    protected static final int CAUTION = 0xFFFF00;
    protected static final int OK = 65280;
    public static final int MAX_GAUGE_VALUE = 12;

    public static int getGaugeCount() {
        return GAUGES.length;
    }

    public static Gauge getGauge(int slot) {
        return GAUGES[slot];
    }

    public int getValue(class_310 mc) {
        double realValue = this.getRealValue(mc);
        int value = (int)this.rescale(realValue);
        return this.clamp(value);
    }

    public abstract GaugeFacePart[] getFaceParts();

    protected abstract double getRealValue(class_310 var1);

    protected abstract double rescale(double var1);

    private int clamp(int value) {
        if (value < 0) {
            return 0;
        }
        if (value > 12) {
            return 12;
        }
        return value;
    }

    public record GaugeFacePart(int steps, int color) {
    }
}

