/*
 * Decompiled with CFR 0.152.
 */
package com.pixelknights.bridgesgame.client.command;

import com.mojang.brigadier.Command;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.pixelknights.bridgesgame.client.config.ModConfig;
import com.pixelknights.bridgesgame.client.di.Channels;
import com.pixelknights.bridgesgame.client.game.entity.GameBoard;
import com.pixelknights.bridgesgame.client.game.entity.GameColor;
import com.pixelknights.bridgesgame.client.game.entity.Team;
import com.pixelknights.bridgesgame.client.render.DotRenderer;
import com.pixelknights.bridgesgame.client.render.LineRenderer;
import java.util.concurrent.BlockingQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.qualifier.QualifierKt;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u00012\u00020\u0003B\u001f\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u000f\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0016\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0011\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0010J\u001b\u0010\u0012\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f\u00a2\u0006\u0004\b\u0012\u0010\u0010J%\u0010\u0015\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J%\u0010\u0017\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\f2\u0006\u0010\u0014\u001a\u00020\u0013H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0016J\u001d\u0010\u0018\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0010J\u000f\u0010\u001a\u001a\u00020\u0019H\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001d\u0010\u001c\u001a\u00020\u000e2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\fH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u0010R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001dR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001eR\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010\u001fR\u001b\u0010%\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$R\u001b\u0010*\u001a\u00020&8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b'\u0010\"\u001a\u0004\b(\u0010)R!\u00100\u001a\b\u0012\u0004\u0012\u00020,0+8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b-\u0010\"\u001a\u0004\b.\u0010/\u00a8\u00061"}, d2={"Lcom/pixelknights/bridgesgame/client/command/JudgeGameCommand;", "Lcom/mojang/brigadier/Command;", "Lnet/fabricmc/fabric/api/client/command/v2/FabricClientCommandSource;", "Lorg/koin/core/component/KoinComponent;", "Lcom/pixelknights/bridgesgame/client/game/entity/GameBoard;", "gameBoard", "Lcom/pixelknights/bridgesgame/client/render/DotRenderer;", "dotRenderer", "Lcom/pixelknights/bridgesgame/client/render/LineRenderer;", "lineRenderer", "<init>", "(Lcom/pixelknights/bridgesgame/client/game/entity/GameBoard;Lcom/pixelknights/bridgesgame/client/render/DotRenderer;Lcom/pixelknights/bridgesgame/client/render/LineRenderer;)V", "Lcom/mojang/brigadier/context/CommandContext;", "ctx", "", "run", "(Lcom/mojang/brigadier/context/CommandContext;)I", "handleScanAction", "handleClearAction", "", "isVisible", "handleTowerStateVisibility", "(Lcom/mojang/brigadier/context/CommandContext;Z)I", "handlePathLineVisibility", "handleSetCenterTowerAction", "Lnet/minecraft/class_2561;", "getScoreText", "()Lnet/minecraft/class_2561;", "commandNotImplemented", "Lcom/pixelknights/bridgesgame/client/game/entity/GameBoard;", "Lcom/pixelknights/bridgesgame/client/render/DotRenderer;", "Lcom/pixelknights/bridgesgame/client/render/LineRenderer;", "Lnet/minecraft/class_310;", "mc$delegate", "Lkotlin/Lazy;", "getMc", "()Lnet/minecraft/class_310;", "mc", "Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "config$delegate", "getConfig", "()Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "config", "Ljava/util/concurrent/BlockingQueue;", "", "errorChannel$delegate", "getErrorChannel", "()Ljava/util/concurrent/BlockingQueue;", "errorChannel", "bridges-judge_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nJudgeGameCommand.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JudgeGameCommand.kt\ncom/pixelknights/bridgesgame/client/command/JudgeGameCommand\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,160:1\n58#2,6:161\n58#2,6:167\n58#2,6:173\n1863#3,2:179\n*S KotlinDebug\n*F\n+ 1 JudgeGameCommand.kt\ncom/pixelknights/bridgesgame/client/command/JudgeGameCommand\n*L\n28#1:161,6\n29#1:167,6\n30#1:173,6\n56#1:179,2\n*E\n"})
public final class JudgeGameCommand
implements Command<FabricClientCommandSource>,
KoinComponent {
    @NotNull
    private final GameBoard gameBoard;
    @NotNull
    private final DotRenderer dotRenderer;
    @NotNull
    private final LineRenderer lineRenderer;
    @NotNull
    private final Lazy mc$delegate;
    @NotNull
    private final Lazy config$delegate;
    @NotNull
    private final Lazy errorChannel$delegate;

    public JudgeGameCommand(@NotNull GameBoard gameBoard, @NotNull DotRenderer dotRenderer, @NotNull LineRenderer lineRenderer) {
        Intrinsics.checkNotNullParameter((Object)gameBoard, (String)"gameBoard");
        Intrinsics.checkNotNullParameter((Object)dotRenderer, (String)"dotRenderer");
        Intrinsics.checkNotNullParameter((Object)lineRenderer, (String)"lineRenderer");
        this.gameBoard = gameBoard;
        this.dotRenderer = dotRenderer;
        this.lineRenderer = lineRenderer;
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.mc$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<class_310>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final class_310 invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(class_310.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(class_310.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = null;
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.config$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ModConfig>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final ModConfig invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ModConfig.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ModConfig.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        $this$inject_u24default$iv = this;
        qualifier$iv = QualifierKt.named((Enum)Channels.MultipleBridgeDetectedErrorChannel);
        mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        parameters$iv = null;
        $i$f$inject = false;
        this.errorChannel$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<BlockingQueue<String>>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final BlockingQueue<String> invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(BlockingQueue.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(BlockingQueue.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
    }

    private final class_310 getMc() {
        Lazy lazy = this.mc$delegate;
        return (class_310)lazy.getValue();
    }

    private final ModConfig getConfig() {
        Lazy lazy = this.config$delegate;
        return (ModConfig)lazy.getValue();
    }

    private final BlockingQueue<String> getErrorChannel() {
        Lazy lazy = this.errorChannel$delegate;
        return (BlockingQueue)lazy.getValue();
    }

    /*
     * Enabled aggressive block sorting
     */
    public int run(@NotNull CommandContext<FabricClientCommandSource> ctx) {
        int n;
        String action;
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        String string = action = StringArgumentType.getString(ctx, (String)"action");
        if (string != null) {
            int n2 = -1;
            switch (string.hashCode()) {
                case 1563968857: {
                    if (!string.equals("showTowerText")) break;
                    n2 = 1;
                    break;
                }
                case 3524221: {
                    if (!string.equals("scan")) break;
                    n2 = 2;
                    break;
                }
                case 94746189: {
                    if (!string.equals("clear")) break;
                    n2 = 3;
                    break;
                }
                case -1036772515: {
                    if (!string.equals("showPathLines")) break;
                    n2 = 4;
                    break;
                }
                case -750235150: {
                    if (!string.equals("setCenterTower")) break;
                    n2 = 5;
                    break;
                }
                case -146352456: {
                    if (!string.equals("hidePathLines")) break;
                    n2 = 6;
                    break;
                }
                case -1840578380: {
                    if (!string.equals("hideTowerText")) break;
                    n2 = 7;
                    break;
                }
            }
            switch (n2) {
                case 2: {
                    n = this.handleScanAction(ctx);
                    return n;
                }
                case 5: {
                    n = this.handleSetCenterTowerAction(ctx);
                    return n;
                }
                case 3: {
                    n = this.handleClearAction(ctx);
                    return n;
                }
                case 4: {
                    n = this.handlePathLineVisibility(ctx, true);
                    return n;
                }
                case 6: {
                    n = this.handlePathLineVisibility(ctx, false);
                    return n;
                }
                case 1: {
                    n = this.handleTowerStateVisibility(ctx, true);
                    return n;
                }
                case 7: {
                    n = this.handleTowerStateVisibility(ctx, false);
                    return n;
                }
            }
        }
        n = this.commandNotImplemented(ctx);
        return n;
    }

    private final int handleScanAction(CommandContext<FabricClientCommandSource> ctx) {
        class_2338 centerPosition = this.getConfig().getPlayerSettings().getCenterCoordinate();
        this.dotRenderer.getDotsToRender().clear();
        this.lineRenderer.getLinesToRender().clear();
        this.gameBoard.scanGame(centerPosition);
        int numErrors = 0;
        Iterable $this$forEach$iv = this.getErrorChannel();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String it = (String)element$iv;
            boolean bl = false;
            ++numErrors;
            ((FabricClientCommandSource)ctx.getSource()).sendError(class_2561.method_30163((String)("WARNING: " + it)));
        }
        this.getErrorChannel().clear();
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback(this.getScoreText());
        if (numErrors > 0) {
            ((FabricClientCommandSource)ctx.getSource()).sendError(class_2561.method_30163((String)(numErrors + " warnings detected (see above scores)")));
        }
        return 0;
    }

    public final int handleClearAction(@NotNull CommandContext<FabricClientCommandSource> ctx) {
        Intrinsics.checkNotNullParameter(ctx, (String)"ctx");
        this.gameBoard.resetGame();
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)"Game state cleared"));
        return 0;
    }

    private final int handleTowerStateVisibility(CommandContext<FabricClientCommandSource> ctx, boolean isVisible) {
        this.getConfig().getPlayerSettings().setShowTowerState(isVisible);
        this.getConfig().save();
        if (isVisible) {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)"Showing tower text"));
        } else {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)"Hiding tower text"));
        }
        return 0;
    }

    private final int handlePathLineVisibility(CommandContext<FabricClientCommandSource> ctx, boolean isVisible) {
        this.getConfig().getPlayerSettings().setShowBridgePaths(isVisible);
        this.getConfig().save();
        if (isVisible) {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)"Showing path lines"));
        } else {
            ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)"Hiding path lines"));
        }
        return 0;
    }

    private final int handleSetCenterTowerAction(CommandContext<FabricClientCommandSource> ctx) {
        class_243 playerPosition;
        class_746 class_7462 = this.getMc().field_1724;
        Object object = playerPosition = class_7462 != null ? class_7462.method_19538() : null;
        if (playerPosition == null) {
            ((FabricClientCommandSource)ctx.getSource()).sendError(class_2561.method_30163((String)"Player position is null"));
            return -1;
        }
        this.getConfig().getPlayerSettings().setCenterCoordinate(class_2338.method_49638((class_2374)((class_2374)playerPosition)));
        this.getConfig().save();
        class_2338 coordinate = this.getConfig().getPlayerSettings().getCenterCoordinate();
        ((FabricClientCommandSource)ctx.getSource()).sendFeedback(class_2561.method_30163((String)("Center tower coordinates set to: (" + coordinate.method_10263() + ", " + coordinate.method_10264() + ", " + coordinate.method_10260() + ")")));
        return 0;
    }

    private final class_2561 getScoreText() {
        Team team = this.gameBoard.getTeams().get((Object)GameColor.RED);
        Team team2 = this.gameBoard.getTeams().get((Object)GameColor.RED);
        Team team3 = this.gameBoard.getTeams().get((Object)GameColor.RED);
        Team team4 = this.gameBoard.getTeams().get((Object)GameColor.CYAN);
        Team team5 = this.gameBoard.getTeams().get((Object)GameColor.CYAN);
        Team team6 = this.gameBoard.getTeams().get((Object)GameColor.CYAN);
        Team team7 = this.gameBoard.getTeams().get((Object)GameColor.YELLOW);
        Team team8 = this.gameBoard.getTeams().get((Object)GameColor.YELLOW);
        Team team9 = this.gameBoard.getTeams().get((Object)GameColor.YELLOW);
        Team team10 = this.gameBoard.getTeams().get((Object)GameColor.GREEN);
        Team team11 = this.gameBoard.getTeams().get((Object)GameColor.GREEN);
        Team team12 = this.gameBoard.getTeams().get((Object)GameColor.GREEN);
        Team team13 = this.gameBoard.getTeams().get((Object)GameColor.MAGENTA);
        Team team14 = this.gameBoard.getTeams().get((Object)GameColor.MAGENTA);
        Team team15 = this.gameBoard.getTeams().get((Object)GameColor.MAGENTA);
        Team team16 = this.gameBoard.getTeams().get((Object)GameColor.ORANGE);
        Team team17 = this.gameBoard.getTeams().get((Object)GameColor.ORANGE);
        Team team18 = this.gameBoard.getTeams().get((Object)GameColor.ORANGE);
        String results = StringsKt.trimIndent((String)("\n\n            \u00a7l\u00a7nBRIDGES Scores:\u00a7r \n            \u00a7l\u00a7cRed:\n                Towers: " + (team != null ? Integer.valueOf(team.getCapturedTowers()) : "N/A") + "\n                Points: " + (team2 != null ? Integer.valueOf(team2.getPoints()) : "N/A") + "\n                Moves: " + (team3 != null ? Integer.valueOf(team3.getMoves()) : "N/A") + " \u00a7r\n            \u00a7l\u00a73Cyan:\n                Towers: " + (team4 != null ? Integer.valueOf(team4.getCapturedTowers()) : "N/A") + "\n                Points: " + (team5 != null ? Integer.valueOf(team5.getPoints()) : "N/A") + "\n                Moves: " + (team6 != null ? Integer.valueOf(team6.getMoves()) : "N/A") + " \u00a7r\n            \u00a7l\u00a7eYellow:\n                Towers: " + (team7 != null ? Integer.valueOf(team7.getCapturedTowers()) : "N/A") + "\n                Points: " + (team8 != null ? Integer.valueOf(team8.getPoints()) : "N/A") + "\n                Moves: " + (team9 != null ? Integer.valueOf(team9.getMoves()) : "N/A") + " \u00a7r\n            \u00a7l\u00a72Green:\n                Towers: " + (team10 != null ? Integer.valueOf(team10.getCapturedTowers()) : "N/A") + "\n                Points: " + (team11 != null ? Integer.valueOf(team11.getPoints()) : "N/A") + "\n                Moves: " + (team12 != null ? Integer.valueOf(team12.getMoves()) : "N/A") + " \u00a7r\n            \u00a7l\u00a7dMagenta:\n                Towers: " + (team13 != null ? Integer.valueOf(team13.getCapturedTowers()) : "N/A") + "\n                Points: " + (team14 != null ? Integer.valueOf(team14.getPoints()) : "N/A") + " \n                Moves: " + (team15 != null ? Integer.valueOf(team15.getMoves()) : "N/A") + " \u00a7r\n            \u00a7l\u00a76Orange:\n                Towers: " + (team16 != null ? Integer.valueOf(team16.getCapturedTowers()) : "N/A") + "\n                Points: " + (team17 != null ? Integer.valueOf(team17.getPoints()) : "N/A") + " \n                Moves: " + (team18 != null ? Integer.valueOf(team18.getMoves()) : "N/A") + " \u00a7r\n                \n        "));
        class_5250 class_52502 = class_2561.method_43470((String)results);
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"literal(...)");
        return (class_2561)class_52502;
    }

    private final int commandNotImplemented(CommandContext<FabricClientCommandSource> ctx) {
        ((FabricClientCommandSource)ctx.getSource()).sendError(class_2561.method_30163((String)"Not yet implemented"));
        return -999;
    }

    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin((KoinComponent)this);
    }
}

