/*
 * Decompiled with CFR 0.152.
 */
package com.pixelknights.bridgesgame.client.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.pixelknights.bridgesgame.client.BridgesJudgeClientKt;
import com.pixelknights.bridgesgame.client.config.BoardConfig;
import com.pixelknights.bridgesgame.client.config.PlayerSettings;
import com.pixelknights.bridgesgame.client.config.TowerConfig;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.Transient;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u000f\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B/\u0012\b\b\u0002\u0010\u0003\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0004\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0006\u0012\b\b\u0002\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\r\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u000f\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u0010\u0010\u0011\u001a\u00020\u0004H\u00c6\u0003\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\bH\u00c6\u0003\u00a2\u0006\u0004\b\u0015\u0010\u0016J8\u0010\u0017\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\t\u001a\u00020\bH\u00c6\u0001\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001a\u0010\u001b\u001a\u00020\u001a2\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u0010\u0010\u001d\u001a\u00020\bH\u00d6\u0001\u00a2\u0006\u0004\b\u001d\u0010\u0016J\u0010\u0010\u001f\u001a\u00020\u001eH\u00d6\u0001\u00a2\u0006\u0004\b\u001f\u0010 R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010!\u001a\u0004\b\"\u0010\u0010R\u0017\u0010\u0005\u001a\u00020\u00048\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010#\u001a\u0004\b$\u0010\u0012R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010%\u001a\u0004\b&\u0010\u0014R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010'\u001a\u0004\b(\u0010\u0016R\u001a\u0010+\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b*\u0010\u000e\u001a\u0004\b)\u0010\u0016\u00a8\u0006-"}, d2={"Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "", "Lcom/pixelknights/bridgesgame/client/config/BoardConfig;", "boardConfig", "Lcom/pixelknights/bridgesgame/client/config/TowerConfig;", "towerConfig", "Lcom/pixelknights/bridgesgame/client/config/PlayerSettings;", "playerSettings", "", "configVersion", "<init>", "(Lcom/pixelknights/bridgesgame/client/config/BoardConfig;Lcom/pixelknights/bridgesgame/client/config/TowerConfig;Lcom/pixelknights/bridgesgame/client/config/PlayerSettings;I)V", "", "save", "()V", "component1", "()Lcom/pixelknights/bridgesgame/client/config/BoardConfig;", "component2", "()Lcom/pixelknights/bridgesgame/client/config/TowerConfig;", "component3", "()Lcom/pixelknights/bridgesgame/client/config/PlayerSettings;", "component4", "()I", "copy", "(Lcom/pixelknights/bridgesgame/client/config/BoardConfig;Lcom/pixelknights/bridgesgame/client/config/TowerConfig;Lcom/pixelknights/bridgesgame/client/config/PlayerSettings;I)Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "Lcom/pixelknights/bridgesgame/client/config/BoardConfig;", "getBoardConfig", "Lcom/pixelknights/bridgesgame/client/config/TowerConfig;", "getTowerConfig", "Lcom/pixelknights/bridgesgame/client/config/PlayerSettings;", "getPlayerSettings", "I", "getConfigVersion", "getSpaceBetweenCenters", "getSpaceBetweenCenters$annotations", "spaceBetweenCenters", "Companion", "bridges-judge_client"})
@Environment(value=EnvType.CLIENT)
public final class ModConfig {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final BoardConfig boardConfig;
    @NotNull
    private final TowerConfig towerConfig;
    @NotNull
    private final PlayerSettings playerSettings;
    private final int configVersion;
    @NotNull
    private static final String CONFIG_FILE_NAME = "mod_config.json";
    private static final Path SAVE_DIR;

    public ModConfig(@NotNull BoardConfig boardConfig, @NotNull TowerConfig towerConfig, @NotNull PlayerSettings playerSettings, int configVersion) {
        Intrinsics.checkNotNullParameter((Object)boardConfig, (String)"boardConfig");
        Intrinsics.checkNotNullParameter((Object)towerConfig, (String)"towerConfig");
        Intrinsics.checkNotNullParameter((Object)playerSettings, (String)"playerSettings");
        this.boardConfig = boardConfig;
        this.towerConfig = towerConfig;
        this.playerSettings = playerSettings;
        this.configVersion = configVersion;
    }

    public /* synthetic */ ModConfig(BoardConfig boardConfig, TowerConfig towerConfig, PlayerSettings playerSettings, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            boardConfig = new BoardConfig(0, 0, 0, 0, 0, 0, 63, null);
        }
        if ((n2 & 2) != 0) {
            towerConfig = new TowerConfig(0, null, null, 7, null);
        }
        if ((n2 & 4) != 0) {
            playerSettings = new PlayerSettings(null, false, false, 7, null);
        }
        if ((n2 & 8) != 0) {
            n = 1;
        }
        this(boardConfig, towerConfig, playerSettings, n);
    }

    @NotNull
    public final BoardConfig getBoardConfig() {
        return this.boardConfig;
    }

    @NotNull
    public final TowerConfig getTowerConfig() {
        return this.towerConfig;
    }

    @NotNull
    public final PlayerSettings getPlayerSettings() {
        return this.playerSettings;
    }

    public final int getConfigVersion() {
        return this.configVersion;
    }

    public final int getSpaceBetweenCenters() {
        return this.boardConfig.getBlocksBetweenTowers() + this.boardConfig.getTowerDiameter();
    }

    @Transient
    public static /* synthetic */ void getSpaceBetweenCenters$annotations() {
    }

    public final void save() {
        if (!Files.exists(SAVE_DIR, new LinkOption[0])) {
            Files.createDirectories(SAVE_DIR, new FileAttribute[0]);
        }
        Path path = SAVE_DIR;
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"SAVE_DIR");
        String[] stringArray = new String[]{CONFIG_FILE_NAME};
        Path saveFile = Paths.get(((Object)path).toString(), stringArray);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        try {
            BridgesJudgeClientKt.getMOD_LOGGER().info("Saving mod configuration");
            OpenOption[] openOptionArray = new OpenOption[]{StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};
            Files.writeString(saveFile, (CharSequence)gson.toJson((Object)this), openOptionArray);
        }
        catch (IOException e) {
            BridgesJudgeClientKt.getMOD_LOGGER().error("Failed to save config file", (Throwable)e);
        }
    }

    @NotNull
    public final BoardConfig component1() {
        return this.boardConfig;
    }

    @NotNull
    public final TowerConfig component2() {
        return this.towerConfig;
    }

    @NotNull
    public final PlayerSettings component3() {
        return this.playerSettings;
    }

    public final int component4() {
        return this.configVersion;
    }

    @NotNull
    public final ModConfig copy(@NotNull BoardConfig boardConfig, @NotNull TowerConfig towerConfig, @NotNull PlayerSettings playerSettings, int configVersion) {
        Intrinsics.checkNotNullParameter((Object)boardConfig, (String)"boardConfig");
        Intrinsics.checkNotNullParameter((Object)towerConfig, (String)"towerConfig");
        Intrinsics.checkNotNullParameter((Object)playerSettings, (String)"playerSettings");
        return new ModConfig(boardConfig, towerConfig, playerSettings, configVersion);
    }

    public static /* synthetic */ ModConfig copy$default(ModConfig modConfig, BoardConfig boardConfig, TowerConfig towerConfig, PlayerSettings playerSettings, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            boardConfig = modConfig.boardConfig;
        }
        if ((n2 & 2) != 0) {
            towerConfig = modConfig.towerConfig;
        }
        if ((n2 & 4) != 0) {
            playerSettings = modConfig.playerSettings;
        }
        if ((n2 & 8) != 0) {
            n = modConfig.configVersion;
        }
        return modConfig.copy(boardConfig, towerConfig, playerSettings, n);
    }

    @NotNull
    public String toString() {
        return "ModConfig(boardConfig=" + this.boardConfig + ", towerConfig=" + this.towerConfig + ", playerSettings=" + this.playerSettings + ", configVersion=" + this.configVersion + ")";
    }

    public int hashCode() {
        int result = this.boardConfig.hashCode();
        result = result * 31 + this.towerConfig.hashCode();
        result = result * 31 + this.playerSettings.hashCode();
        result = result * 31 + Integer.hashCode(this.configVersion);
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ModConfig)) {
            return false;
        }
        ModConfig modConfig = (ModConfig)other;
        if (!Intrinsics.areEqual((Object)this.boardConfig, (Object)modConfig.boardConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.towerConfig, (Object)modConfig.towerConfig)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.playerSettings, (Object)modConfig.playerSettings)) {
            return false;
        }
        return this.configVersion == modConfig.configVersion;
    }

    public ModConfig() {
        this(null, null, null, 0, 15, null);
    }

    @JvmStatic
    @NotNull
    public static final ModConfig loadConfig(@NotNull Path saveFile) {
        return Companion.loadConfig(saveFile);
    }

    static {
        Path path = FabricLoader.getInstance().getConfigDir();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getConfigDir(...)");
        String[] stringArray = new String[]{"bridges-judge"};
        SAVE_DIR = Paths.get(((Object)path).toString(), stringArray);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0019\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\u0005\u001a\u00020\u0004H\u0007\u00a2\u0006\u0004\b\u0007\u0010\bR\u0014\u0010\n\u001a\u00020\t8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000bR\u001c\u0010\r\u001a\n \f*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/pixelknights/bridgesgame/client/config/ModConfig$Companion;", "", "<init>", "()V", "Ljava/nio/file/Path;", "saveFile", "Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "loadConfig", "(Ljava/nio/file/Path;)Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "", "CONFIG_FILE_NAME", "Ljava/lang/String;", "kotlin.jvm.PlatformType", "SAVE_DIR", "Ljava/nio/file/Path;", "bridges-judge_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ModConfig loadConfig(@NotNull Path saveFile) {
            Intrinsics.checkNotNullParameter((Object)saveFile, (String)"saveFile");
            BridgesJudgeClientKt.getMOD_LOGGER().info("Loading mod configuration");
            if (!Files.exists(saveFile, new LinkOption[0])) {
                BridgesJudgeClientKt.getMOD_LOGGER().info("No existing save file found, creating new one.");
                ModConfig config = new ModConfig(null, null, null, 0, 15, null);
                config.save();
                return config;
            }
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            String fileContents = Files.readString(saveFile, StandardCharsets.UTF_8);
            Object object = gson.fromJson(fileContents, ModConfig.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
            return (ModConfig)object;
        }

        public static /* synthetic */ ModConfig loadConfig$default(Companion companion, Path path, int n, Object object) {
            if ((n & 1) != 0) {
                Path path2 = SAVE_DIR;
                Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"access$getSAVE_DIR$cp(...)");
                String[] stringArray = new String[]{ModConfig.CONFIG_FILE_NAME};
                path = Paths.get(((Object)path2).toString(), stringArray);
            }
            return companion.loadConfig(path);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

