/*
 * Decompiled with CFR 0.152.
 */
package com.pixelknights.bridgesgame.client.config;

import com.pixelknights.bridgesgame.client.BridgesJudgeClientKt;
import com.pixelknights.bridgesgame.client.game.entity.GameColor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IndexedValue;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0010!\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 &2\u00020\u0001:\u0001&B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001f\u0010\t\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u001f\u0010\f\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\f\u0010\rJ\u001d\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000f\u0010\u0012\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u000f\u0010\u0014\u001a\u00020\u0011H\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0013R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\"\u0010\u0019\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00060\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0019\u0010\u001aR\"\u0010\u001b\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u000b0\u00180\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001b\u0010\u001aR&\u0010\u001e\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00060\u001d\u0012\u0004\u0012\u00020\u000b0\u001c8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u001e\u0010\u001fR\u001b\u0010%\u001a\u00020 8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\"\u001a\u0004\b#\u0010$\u00a8\u0006'"}, d2={"Lcom/pixelknights/bridgesgame/client/config/TowerLayoutConfig;", "Lorg/koin/core/component/KoinComponent;", "Lorg/apache/logging/log4j/Logger;", "logger", "<init>", "(Lorg/apache/logging/log4j/Logger;)V", "", "row", "col", "getHeight", "(II)Ljava/lang/Integer;", "Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "getColor", "(II)Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "", "isTeamBase", "(II)Z", "", "loadColorMap", "()V", "loadHeightmap", "Lorg/apache/logging/log4j/Logger;", "getLogger", "()Lorg/apache/logging/log4j/Logger;", "", "heightMap", "Ljava/util/List;", "colorMap", "", "", "baseMap", "Ljava/util/Map;", "Lnet/minecraft/class_310;", "mc$delegate", "Lkotlin/Lazy;", "getMc", "()Lnet/minecraft/class_310;", "mc", "Companion", "bridges-judge_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nTowerLayoutConfig.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TowerLayoutConfig.kt\ncom/pixelknights/bridgesgame/client/config/TowerLayoutConfig\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,100:1\n58#2,6:101\n535#3:107\n520#3,6:108\n1567#4:114\n1598#4,4:115\n1557#4:119\n1628#4,3:120\n*S KotlinDebug\n*F\n+ 1 TowerLayoutConfig.kt\ncom/pixelknights/bridgesgame/client/config/TowerLayoutConfig\n*L\n22#1:101,6\n44#1:107\n44#1:108,6\n61#1:114\n61#1:115,4\n84#1:119\n84#1:120,3\n*E\n"})
public final class TowerLayoutConfig
implements KoinComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Logger logger;
    @NotNull
    private final List<List<Integer>> heightMap;
    @NotNull
    private final List<List<GameColor>> colorMap;
    @NotNull
    private final Map<Integer[], GameColor> baseMap;
    @NotNull
    private final Lazy mc$delegate;
    @NotNull
    private static final String COLORMAP_PATH = "config/tower_color_layout.txt";
    @NotNull
    private static final String HEIGHTMAP_PATH = "config/tower_height_layout.txt";

    public TowerLayoutConfig(@NotNull Logger logger) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.logger = logger;
        this.heightMap = new ArrayList();
        this.colorMap = new ArrayList();
        this.baseMap = new LinkedHashMap();
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.mc$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<class_310>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final class_310 invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(class_310.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(class_310.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        BridgesJudgeClientKt.getMOD_LOGGER().info("Initializing TowerLayoutConfig");
        this.loadHeightmap();
        this.loadColorMap();
        BridgesJudgeClientKt.getMOD_LOGGER().info("Finished initializing TowerLayoutConfig");
    }

    @NotNull
    public final Logger getLogger() {
        return this.logger;
    }

    private final class_310 getMc() {
        Lazy lazy = this.mc$delegate;
        return (class_310)lazy.getValue();
    }

    @Nullable
    public final Integer getHeight(int row, int col) {
        return this.heightMap.get(row).get(col);
    }

    @Nullable
    public final GameColor getColor(int row, int col) {
        return this.colorMap.get(row).get(col);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean isTeamBase(int row, int col) {
        void $this$filterTo$iv$iv;
        Map<Integer[], GameColor> $this$filter$iv = this.baseMap;
        boolean $i$f$filter = false;
        Map<Integer[], GameColor> map = $this$filter$iv;
        Map destination$iv$iv = new LinkedHashMap();
        boolean $i$f$filterTo = false;
        Iterator iterator = $this$filterTo$iv$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv$iv;
            Map.Entry it = element$iv$iv = iterator.next();
            boolean bl = false;
            Object[] objectArray = (Object[])it.getKey();
            Object[] objectArray2 = new Integer[]{row, col};
            if (!Arrays.equals(objectArray, objectArray2)) continue;
            destination$iv$iv.put(element$iv$iv.getKey(), element$iv$iv.getValue());
        }
        return MapsKt.any((Map)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final void loadColorMap() {
        class_2960 id = class_2960.method_60655((String)"bridges-judge", (String)COLORMAP_PATH);
        Optional resource = this.getMc().method_1478().method_14486(id);
        if (resource.isEmpty()) {
            throw new IOException("Color map could not be loaded");
        }
        Iterator iterator = ((class_3298)resource.get()).method_43039().lines().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = CollectionsKt.withIndex(iterator);
        while (iterator2.hasNext()) {
            void $this$mapIndexedTo$iv$iv;
            void $this$mapIndexed$iv;
            IndexedValue indexedValue = (IndexedValue)iterator2.next();
            int row = indexedValue.component1();
            String line = (String)indexedValue.component2();
            Intrinsics.checkNotNull((Object)line);
            Object object = new char[]{' '};
            object = StringsKt.split$default((CharSequence)line, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$mapIndexed = false;
            void var10_10 = $this$mapIndexed$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$mapIndexed$iv, (int)10));
            boolean $i$f$mapIndexedTo = false;
            int index$iv$iv = 0;
            for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
                void code;
                int n;
                if ((n = index$iv$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                String string = (String)item$iv$iv;
                int n2 = n;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                GameColor color = GameColor.Companion.fromChar((String)code);
                if (color != null) {
                    String string2 = color.getColorCode().toUpperCase(Locale.ROOT);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toUpperCase(...)");
                    if (Intrinsics.areEqual((Object)string2, (Object)code)) {
                        void col;
                        Map<Integer[], GameColor> map = this.baseMap;
                        Integer[] integerArray = new Integer[]{row, (int)col};
                        map.put(integerArray, color);
                    }
                }
                collection.add(color);
            }
            List tmp = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            this.colorMap.add(tmp);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void loadHeightmap() {
        class_2960 id = class_2960.method_60655((String)"bridges-judge", (String)HEIGHTMAP_PATH);
        Optional resource = this.getMc().method_1478().method_14486(id);
        if (resource.isEmpty()) {
            throw new IOException("Height map could not be loaded");
        }
        Iterator iterator = ((class_3298)resource.get()).method_43039().lines().iterator();
        Intrinsics.checkNotNullExpressionValue(iterator, (String)"iterator(...)");
        Iterator iterator2 = iterator;
        while (iterator2.hasNext()) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String line = (String)iterator2.next();
            Intrinsics.checkNotNull((Object)line);
            Object object = new char[]{' '};
            object = StringsKt.split$default((CharSequence)line, (char[])object, (boolean)false, (int)0, (int)6, null);
            boolean $i$f$map = false;
            void var8_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void height;
                String string = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(Intrinsics.areEqual((Object)height, (Object)".") ? null : Integer.valueOf(Integer.parseInt((String)height)));
            }
            List tmp = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
            this.heightMap.add(tmp);
        }
    }

    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin((KoinComponent)this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006\u00a8\u0006\b"}, d2={"Lcom/pixelknights/bridgesgame/client/config/TowerLayoutConfig$Companion;", "", "<init>", "()V", "", "COLORMAP_PATH", "Ljava/lang/String;", "HEIGHTMAP_PATH", "bridges-judge_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

