/*
 * Decompiled with CFR 0.152.
 */
package com.pixelknights.bridgesgame.client.game.entity;

import com.pixelknights.bridgesgame.client.config.ModConfig;
import com.pixelknights.bridgesgame.client.di.Channels;
import com.pixelknights.bridgesgame.client.game.entity.Bridge;
import com.pixelknights.bridgesgame.client.game.entity.BridgeError;
import com.pixelknights.bridgesgame.client.game.entity.Floor;
import com.pixelknights.bridgesgame.client.game.entity.GameColor;
import com.pixelknights.bridgesgame.client.game.entity.Node;
import com.pixelknights.bridgesgame.client.game.entity.Path;
import com.pixelknights.bridgesgame.client.game.entity.Team;
import com.pixelknights.bridgesgame.client.game.entity.Tower;
import com.pixelknights.bridgesgame.client.game.entity.scanner.BridgeScanner;
import com.pixelknights.bridgesgame.client.game.entity.scanner.TowerScanner;
import com.pixelknights.bridgesgame.client.render.Color;
import com.pixelknights.bridgesgame.client.render.DebugLine;
import com.pixelknights.bridgesgame.client.render.DotRenderer;
import com.pixelknights.bridgesgame.client.render.HoveringText;
import com.pixelknights.bridgesgame.client.render.HoveringTextRenderer;
import com.pixelknights.bridgesgame.client.render.LineRenderer;
import com.pixelknights.bridgesgame.client.util.MathExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.qualifier.QualifierKt;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0092\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001BG\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\r\u001a\u00020\f\u0012\u0006\u0010\u000f\u001a\u00020\u000e\u0012\u0006\u0010\u0011\u001a\u00020\u0010\u00a2\u0006\u0004\b\u0012\u0010\u0013J\u0015\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0014\u00a2\u0006\u0004\b\u0017\u0010\u0018J\r\u0010\u0019\u001a\u00020\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\r\u0010\u001b\u001a\u00020\u0016\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u000f\u0010\u001c\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001aJ\u000f\u0010\u001d\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001aJ\u0017\u0010 \u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b \u0010!J%\u0010%\u001a\u00020\u00162\f\u0010$\u001a\b\u0012\u0004\u0012\u00020#0\"2\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b%\u0010&J\u000f\u0010'\u001a\u00020\u0016H\u0002\u00a2\u0006\u0004\b'\u0010\u001aR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010(R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010)R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010*R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010+R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010,R\u0014\u0010\r\u001a\u00020\f8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\r\u0010-R\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010.R\u0014\u0010\u0011\u001a\u00020\u00108\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0011\u0010/R\"\u00101\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020#00008\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b1\u00102R\u001c\u00105\u001a\b\u0012\u0004\u0012\u000204038\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b5\u00106R\u001a\u00108\u001a\b\u0012\u0004\u0012\u000207008\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b8\u00102R!\u0010?\u001a\b\u0012\u0004\u0012\u00020:098BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b;\u0010<\u001a\u0004\b=\u0010>R#\u0010C\u001a\u000e\u0012\u0004\u0012\u00020A\u0012\u0004\u0012\u00020B0@8\u0006\u00a2\u0006\f\n\u0004\bC\u0010D\u001a\u0004\bE\u0010F\u00a8\u0006G"}, d2={"Lcom/pixelknights/bridgesgame/client/game/entity/GameBoard;", "Lorg/koin/core/component/KoinComponent;", "Lcom/pixelknights/bridgesgame/client/game/entity/scanner/TowerScanner;", "towerScanner", "Lcom/pixelknights/bridgesgame/client/game/entity/scanner/BridgeScanner;", "bridgeScanner", "Lcom/pixelknights/bridgesgame/client/render/DotRenderer;", "dotRenderer", "Lcom/pixelknights/bridgesgame/client/render/LineRenderer;", "lineRenderer", "Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "config", "Lnet/minecraft/class_310;", "mc", "Lorg/apache/logging/log4j/Logger;", "logger", "Lcom/pixelknights/bridgesgame/client/render/HoveringTextRenderer;", "textRenderer", "<init>", "(Lcom/pixelknights/bridgesgame/client/game/entity/scanner/TowerScanner;Lcom/pixelknights/bridgesgame/client/game/entity/scanner/BridgeScanner;Lcom/pixelknights/bridgesgame/client/render/DotRenderer;Lcom/pixelknights/bridgesgame/client/render/LineRenderer;Lcom/pixelknights/bridgesgame/client/config/ModConfig;Lnet/minecraft/class_310;Lorg/apache/logging/log4j/Logger;Lcom/pixelknights/bridgesgame/client/render/HoveringTextRenderer;)V", "Lnet/minecraft/class_2338;", "centerCoordinate", "", "scanGame", "(Lnet/minecraft/class_2338;)V", "resetGame", "()V", "createDebugLines", "connectBridges", "calculateScores", "Lnet/minecraft/class_638;", "world", "validateTowerCaptures", "(Lnet/minecraft/class_638;)V", "", "Lcom/pixelknights/bridgesgame/client/game/entity/Tower;", "towerList", "createTowerStatsText", "(Ljava/util/List;Lnet/minecraft/class_2338;)V", "buildTeamPaths", "Lcom/pixelknights/bridgesgame/client/game/entity/scanner/TowerScanner;", "Lcom/pixelknights/bridgesgame/client/game/entity/scanner/BridgeScanner;", "Lcom/pixelknights/bridgesgame/client/render/DotRenderer;", "Lcom/pixelknights/bridgesgame/client/render/LineRenderer;", "Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "Lnet/minecraft/class_310;", "Lorg/apache/logging/log4j/Logger;", "Lcom/pixelknights/bridgesgame/client/render/HoveringTextRenderer;", "", "towers", "Ljava/util/List;", "", "Lcom/pixelknights/bridgesgame/client/game/entity/Bridge;", "bridges", "Ljava/util/Set;", "Lcom/pixelknights/bridgesgame/client/game/entity/Path;", "paths", "Ljava/util/concurrent/BlockingQueue;", "", "errorChannel$delegate", "Lkotlin/Lazy;", "getErrorChannel", "()Ljava/util/concurrent/BlockingQueue;", "errorChannel", "", "Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "Lcom/pixelknights/bridgesgame/client/game/entity/Team;", "teams", "Ljava/util/Map;", "getTeams", "()Ljava/util/Map;", "bridges-judge_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nGameBoard.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GameBoard.kt\ncom/pixelknights/bridgesgame/client/game/entity/GameBoard\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 6 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n+ 7 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,247:1\n58#2,6:248\n1187#3,2:254\n1261#3,2:256\n1264#3:259\n1863#3,2:260\n1863#3:262\n1368#3:263\n1454#3,5:264\n1864#3:269\n1863#3,2:270\n1863#3:272\n1864#3:276\n774#3:278\n865#3,2:279\n1782#3,4:281\n774#3:285\n865#3,2:286\n1782#3,4:288\n1368#3:292\n1454#3,5:293\n1782#3,4:298\n1368#3:302\n1454#3,5:303\n1782#3,4:308\n1782#3,4:312\n1863#3,2:319\n1734#3,3:321\n1948#3,14:324\n1485#3:338\n1510#3,3:339\n1513#3,3:349\n774#3:352\n865#3,2:353\n1557#3:355\n1628#3,3:356\n774#3:359\n865#3,2:360\n1557#3:362\n1628#3,3:363\n1863#3:366\n1864#3:369\n1557#3:370\n1628#3,3:371\n1#4:258\n1272#5,3:273\n1317#5,2:317\n127#5,2:367\n216#6:277\n217#6:316\n381#7,7:342\n*S KotlinDebug\n*F\n+ 1 GameBoard.kt\ncom/pixelknights/bridgesgame/client/game/entity/GameBoard\n*L\n34#1:248,6\n42#1:254,2\n42#1:256,2\n42#1:259\n65#1:260,2\n88#1:262\n91#1:263\n91#1:264,5\n88#1:269\n97#1:270,2\n129#1:272\n129#1:276\n143#1:278\n143#1:279,2\n143#1:281,4\n144#1:285\n144#1:286,2\n144#1:288,4\n145#1:292\n145#1:293,5\n145#1:298,4\n146#1:302\n146#1:303,5\n146#1:308,4\n147#1:312,4\n178#1:319,2\n185#1:321,3\n189#1:324,14\n204#1:338\n204#1:339,3\n204#1:349,3\n212#1:352\n212#1:353,2\n214#1:355\n214#1:356,3\n228#1:359\n228#1:360,2\n229#1:362\n229#1:363,3\n234#1:366\n234#1:369\n205#1:370\n205#1:371,3\n134#1:273,3\n161#1:317,2\n239#1:367,2\n142#1:277\n142#1:316\n204#1:342,7\n*E\n"})
public final class GameBoard
implements KoinComponent {
    @NotNull
    private final TowerScanner towerScanner;
    @NotNull
    private final BridgeScanner bridgeScanner;
    @NotNull
    private final DotRenderer dotRenderer;
    @NotNull
    private final LineRenderer lineRenderer;
    @NotNull
    private final ModConfig config;
    @NotNull
    private final class_310 mc;
    @NotNull
    private final Logger logger;
    @NotNull
    private final HoveringTextRenderer textRenderer;
    @NotNull
    private List<List<Tower>> towers;
    @NotNull
    private Set<Bridge> bridges;
    @NotNull
    private final List<Path> paths;
    @NotNull
    private final Lazy errorChannel$delegate;
    @NotNull
    private final Map<GameColor, Team> teams;

    /*
     * WARNING - void declaration
     */
    public GameBoard(@NotNull TowerScanner towerScanner, @NotNull BridgeScanner bridgeScanner, @NotNull DotRenderer dotRenderer, @NotNull LineRenderer lineRenderer, @NotNull ModConfig config, @NotNull class_310 mc, @NotNull Logger logger, @NotNull HoveringTextRenderer textRenderer) {
        void $this$inject_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)towerScanner, (String)"towerScanner");
        Intrinsics.checkNotNullParameter((Object)bridgeScanner, (String)"bridgeScanner");
        Intrinsics.checkNotNullParameter((Object)dotRenderer, (String)"dotRenderer");
        Intrinsics.checkNotNullParameter((Object)lineRenderer, (String)"lineRenderer");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)textRenderer, (String)"textRenderer");
        this.towerScanner = towerScanner;
        this.bridgeScanner = bridgeScanner;
        this.dotRenderer = dotRenderer;
        this.lineRenderer = lineRenderer;
        this.config = config;
        this.mc = mc;
        this.logger = logger;
        this.textRenderer = textRenderer;
        this.towers = new ArrayList();
        this.bridges = new LinkedHashSet();
        this.paths = new ArrayList();
        KoinComponent koinComponent = this;
        Qualifier qualifier$iv = QualifierKt.named((Enum)Channels.MultipleBridgeDetectedErrorChannel);
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.errorChannel$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<BlockingQueue<String>>((KoinComponent)$this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final BlockingQueue<String> invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(BlockingQueue.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(BlockingQueue.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
        this.teams = new LinkedHashMap();
    }

    private final BlockingQueue<String> getErrorChannel() {
        Lazy lazy = this.errorChannel$delegate;
        return (BlockingQueue)lazy.getValue();
    }

    @NotNull
    public final Map<GameColor, Team> getTeams() {
        return this.teams;
    }

    /*
     * WARNING - void declaration
     */
    public final void scanGame(@NotNull class_2338 centerCoordinate) {
        void $this$associateTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)centerCoordinate, (String)"centerCoordinate");
        this.resetGame();
        Map<GameColor, Team> map = this.teams;
        Object $this$associate$iv = (Iterable)GameColor.getEntries();
        boolean $i$f$associate = false;
        int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
        Iterable iterable = $this$associate$iv;
        Map destination$iv$iv = new LinkedHashMap(capacity$iv);
        boolean $i$f$associateTo = false;
        for (Object element$iv$iv : $this$associateTo$iv$iv) {
            void $this$scanGame_u24lambda_u241_u24lambda_u240;
            Team team;
            Map map2 = destination$iv$iv;
            GameColor color = (GameColor)((Object)element$iv$iv);
            boolean bl = false;
            Team team2 = team = new Team(0, 0, 0, 7, null);
            GameColor gameColor = color;
            boolean bl2 = false;
            $this$scanGame_u24lambda_u241_u24lambda_u240.setBaseColor(color);
            Pair pair = TuplesKt.to((Object)((Object)gameColor), (Object)team);
            map2.put(pair.getFirst(), pair.getSecond());
        }
        $this$associate$iv = destination$iv$iv;
        map.putAll((Map<GameColor, Team>)$this$associate$iv);
        this.towers = this.towerScanner.getTowers(centerCoordinate);
        List nodeMap = SequencesKt.toList((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.towers)), GameBoard::scanGame$lambda$2), GameBoard::scanGame$lambda$3));
        Iterable $this$forEach$iv = nodeMap;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Node node = (Node)element$iv;
            boolean bl = false;
            CollectionsKt.addAll((Collection)this.bridges, (Iterable)this.bridgeScanner.getBridgesForNode(node, nodeMap));
        }
        this.connectBridges();
        this.calculateScores();
        this.createDebugLines();
        this.createTowerStatsText(CollectionsKt.toList((Iterable)CollectionsKt.flatten((Iterable)this.towers)), centerCoordinate);
    }

    public final void resetGame() {
        this.bridges.clear();
        this.paths.clear();
        this.teams.clear();
        this.towers.clear();
        this.lineRenderer.getLinesToRender().clear();
        this.dotRenderer.getDotsToRender().clear();
        this.textRenderer.getTextToRender().clear();
    }

    /*
     * WARNING - void declaration
     */
    public final void createDebugLines() {
        Iterable $this$forEach$iv = this.paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$flatMapTo$iv$iv;
            Path path = (Path)element$iv;
            boolean bl = false;
            class_638 class_6382 = this.mc.field_1687;
            Intrinsics.checkNotNull((Object)class_6382);
            List<DebugLine> lines = path.createDebugLines((class_1937)class_6382, this.config);
            CollectionsKt.addAll((Collection)this.lineRenderer.getLinesToRender(), (Iterable)lines);
            Collection collection = this.dotRenderer.getDotsToRender();
            Iterable $this$flatMap$iv = lines;
            boolean $i$f$flatMap = false;
            Iterable iterable = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                DebugLine it = (DebugLine)element$iv$iv;
                boolean bl2 = false;
                Iterable list$iv$iv = it.getDots();
                CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
            }
            Iterable iterable2 = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable2);
        }
    }

    private final void connectBridges() {
        Iterable $this$forEach$iv = this.bridges;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Bridge bridge = (Bridge)element$iv;
            boolean bl = false;
            Node startNode = bridge.getStartNode();
            Node endNode = bridge.getEndNode();
            ((Collection)startNode.getConnectedBridges()).add(bridge);
            Node node = endNode;
            if (node == null) continue;
            ((Collection)node.getConnectedBridges()).add(bridge);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void calculateScores() {
        boolean bl;
        Object path;
        this.logger.info("Validating game...");
        class_638 world = this.mc.field_1687;
        if (world == null) {
            this.logger.error("World is null");
            return;
        }
        this.buildTeamPaths();
        this.validateTowerCaptures(world);
        Object $this$forEach$iv = this.paths;
        boolean $i$f$forEach = false;
        Iterator<Object> iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            void $this$count$iv;
            Object t = iterator.next();
            path = (Path)t;
            bl = false;
            if (((Path)path).getPathOwner() == null) continue;
            Sequence sequence = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.towers));
            boolean $i$f$count = false;
            int count$iv = 0;
            for (Object element$iv2 : $this$count$iv) {
                Tower it = (Tower)element$iv2;
                boolean bl2 = false;
                if (!(it.getCapturingTeam() == ((Path)path).getPathOwner()) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            int numCapturedTowers = count$iv;
            Team team = this.teams.get((Object)((Path)path).getPathOwner());
            if (team != null) {
                team.setCapturedTowers(numCapturedTowers);
            }
            Team team2 = this.teams.get((Object)((Path)path).getPathOwner());
            if (team2 == null) continue;
            team2.setPoints(((Path)path).calculateScore());
        }
        $this$forEach$iv = this.teams;
        $i$f$forEach = false;
        for (Map.Entry entry : $this$forEach$iv.entrySet()) {
            int n;
            int n2;
            void $this$count$iv;
            void $this$flatMapTo$iv$iv;
            int n3;
            void $this$count$iv2;
            void $this$flatMapTo$iv$iv2;
            int n4;
            void $this$count$iv3;
            void $this$filterTo$iv$iv;
            int n5;
            void $this$count$iv4;
            void $this$filterTo$iv$iv2;
            path = entry;
            bl = false;
            GameColor teamColor = (GameColor)((Object)path.getKey());
            Team team = (Team)path.getValue();
            Iterable $this$filter$iv = this.bridges;
            boolean $i$f$filter = false;
            Iterable element$iv2 = $this$filter$iv;
            Object destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv2) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl3 = false;
                if (!(!it.getErrors().contains((Object)BridgeError.BRIDGE_TO_CLOSED_NODE))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$count = false;
            if ($this$count$iv4 instanceof Collection && ((Collection)$this$count$iv4).isEmpty()) {
                n5 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv4 : $this$count$iv4) {
                    Bridge it = (Bridge)element$iv4;
                    boolean bl4 = false;
                    if (!(it.getOwner() == teamColor) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n5 = count$iv;
            }
            int numBridgeClaims = n5;
            Iterable $this$filter$iv2 = this.bridges;
            boolean $i$f$filter2 = false;
            destination$iv$iv = $this$filter$iv2;
            Object destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Bridge it = (Bridge)element$iv$iv;
                boolean bl5 = false;
                if (!(!it.getErrors().contains((Object)BridgeError.BRIDGE_TO_CLOSED_NODE))) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            $this$filter$iv2 = (List)destination$iv$iv2;
            boolean $i$f$count2 = false;
            if ($this$count$iv3 instanceof Collection && ((Collection)$this$count$iv3).isEmpty()) {
                n4 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv5 : $this$count$iv3) {
                    Bridge it = (Bridge)element$iv5;
                    boolean bl6 = false;
                    if (!(it.getPainter() == teamColor) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n4 = count$iv;
            }
            int numBridgePaints = n4;
            Iterable $this$flatMap$iv = CollectionsKt.flatten((Iterable)this.towers);
            boolean $i$f$flatMap = false;
            destination$iv$iv2 = $this$flatMap$iv;
            Object destination$iv$iv3 = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv2) {
                Tower it = (Tower)element$iv$iv;
                boolean bl7 = false;
                Iterable list$iv$iv = it.getFloors();
                CollectionsKt.addAll((Collection)destination$iv$iv3, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv = (List)destination$iv$iv3;
            boolean $i$f$count3 = false;
            if ($this$count$iv2 instanceof Collection && ((Collection)$this$count$iv2).isEmpty()) {
                n3 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv6 : $this$count$iv2) {
                    Floor it = (Floor)element$iv6;
                    boolean bl8 = false;
                    if (!(it.getCaptureColor() == teamColor) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n3 = count$iv;
            }
            int floorClaims = n3;
            Iterable $this$flatMap$iv2 = CollectionsKt.flatten((Iterable)this.towers);
            boolean $i$f$flatMap2 = false;
            destination$iv$iv3 = $this$flatMap$iv2;
            Collection destination$iv$iv4 = new ArrayList();
            boolean $i$f$flatMapTo2 = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                Tower it = (Tower)element$iv$iv;
                boolean bl9 = false;
                Iterable list$iv$iv = it.getFloors();
                CollectionsKt.addAll((Collection)destination$iv$iv4, (Iterable)list$iv$iv);
            }
            $this$flatMap$iv2 = (List)destination$iv$iv4;
            boolean $i$f$count4 = false;
            if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
                n2 = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv7 : $this$count$iv) {
                    Floor it = (Floor)element$iv7;
                    boolean bl10 = false;
                    if (!(it.getPaintColor() == teamColor) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n2 = count$iv;
            }
            int floorPaints = n2;
            Iterable $this$count$iv5 = CollectionsKt.flatten((Iterable)this.towers);
            boolean $i$f$count5 = false;
            if ($this$count$iv5 instanceof Collection && ((Collection)$this$count$iv5).isEmpty()) {
                n = 0;
            } else {
                int count$iv = 0;
                for (Object element$iv8 : $this$count$iv5) {
                    Tower it = (Tower)element$iv8;
                    boolean bl11 = false;
                    if (!(it.getAttemptedClaimingTeam(world, this.config) == teamColor) || ++count$iv >= 0) continue;
                    CollectionsKt.throwCountOverflow();
                }
                n = count$iv;
            }
            int towerClaims = n;
            team.setMoves(numBridgeClaims + numBridgePaints + floorClaims + floorPaints + towerClaims);
        }
        this.logger.info("Teams = " + this.teams);
        $this$forEach$iv = SequencesKt.filter((Sequence)SequencesKt.flatMapIterable((Sequence)SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.towers)), GameBoard::calculateScores$lambda$20), GameBoard::calculateScores$lambda$21);
        $i$f$forEach = false;
        iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object object = iterator.next();
            Floor it = (Floor)object;
            bl = false;
            if (it.isCaptured() && !Intrinsics.areEqual((Object)it.isCaptureValidated(), (Object)true)) {
                ((Collection)this.getErrorChannel()).add("Floor " + it.getCoords() + " " + it.getWorldCoords() + " disconnected from " + it.getCaptureColor() + " network");
            }
            if (!it.isPainted() || Intrinsics.areEqual((Object)it.isPaintValidated(), (Object)true)) continue;
            ((Collection)this.getErrorChannel()).add("Floor " + it.getCoords() + " " + it.getWorldCoords() + " disconnected from " + it.getPaintColor() + " network");
        }
    }

    private final void validateTowerCaptures(class_638 world) {
        Iterable $this$forEach$iv = CollectionsKt.flatten((Iterable)this.towers);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Tower tower = (Tower)element$iv;
            boolean bl = false;
            tower.setCapturingTeam(world, this.config);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void createTowerStatsText(List<Tower> towerList, class_2338 centerCoordinate) {
        for (Tower tower : towerList) {
            void $this$filterTo$iv$iv;
            void $this$groupByTo$iv$iv;
            void $this$groupBy$iv;
            Object color;
            Object t;
            if (tower.getCapturingTeam() == null) {
                boolean bl;
                block17: {
                    Iterable $this$all$iv = tower.getFloors();
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            Floor it = (Floor)element$iv;
                            boolean bl2 = false;
                            if (it.getCaptureColor() == null) continue;
                            bl = false;
                            break block17;
                        }
                        bl = true;
                    }
                }
                if (bl) continue;
            }
            Iterable $this$maxBy$iv = tower.getFloors();
            boolean $i$f$maxByOrThrow = false;
            Iterator iterator$iv = $this$maxBy$iv.iterator();
            if (!iterator$iv.hasNext()) {
                throw new NoSuchElementException();
            }
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                t = maxElem$iv;
            } else {
                Floor it = (Floor)maxElem$iv;
                boolean bl = false;
                int maxValue$iv = it.getFloorNumber();
                do {
                    Object e$iv = iterator$iv.next();
                    Floor it2 = (Floor)e$iv;
                    $i$a$-maxByOrThrow-GameBoard$createTowerStatsText$topFloor$1 = false;
                    int v$iv = it2.getFloorNumber();
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                t = maxElem$iv;
            }
            Floor topFloor = (Floor)t;
            int textHeight = (topFloor.getFloorNumber() + 1) * this.config.getTowerConfig().getBlocksBetweenFloors() + 7;
            class_2338 position = MathExtKt.plus(tower.worldCoordinates(centerCoordinate, this.config), new class_2382(1, textHeight, 1));
            HoveringText textBlock = new HoveringText((class_2382)position, null, 2, null);
            if (tower.getCapturingTeam() == null) {
                v2 = textBlock.addLine("Tower not captured", Color.Companion.getWHITE());
            } else {
                GameColor gameColor = tower.getCapturingTeam();
                Intrinsics.checkNotNull((Object)((Object)gameColor));
                color = Color.Companion.fromHex(gameColor.getRgba());
                GameColor gameColor2 = tower.getCapturingTeam();
                Intrinsics.checkNotNull((Object)((Object)gameColor2));
                int pointValue = tower.getCapturePoints(gameColor2);
                v2 = textBlock.addLine("Tower captured by: " + tower.getCapturingTeam() + " (+" + pointValue + ")", (Color)color);
            }
            textBlock.addLine("\u00a7nFloors:", Color.Companion.getWHITE());
            color = tower.getFloors();
            boolean $i$f$groupBy = false;
            void e$iv = $this$groupBy$iv;
            Object destination$iv$iv = new LinkedHashMap();
            boolean $i$f$groupByTo = false;
            for (Object element$iv$iv : $this$groupByTo$iv$iv) {
                Object object;
                Floor it = (Floor)element$iv$iv;
                boolean bl = false;
                GameColor key$iv$iv = it.getOwner();
                Map $this$getOrPut$iv$iv$iv = destination$iv$iv;
                boolean $i$f$getOrPut = false;
                Object value$iv$iv$iv = $this$getOrPut$iv$iv$iv.get((Object)key$iv$iv);
                if (value$iv$iv$iv == null) {
                    boolean bl3 = false;
                    List answer$iv$iv$iv = new ArrayList();
                    $this$getOrPut$iv$iv$iv.put(key$iv$iv, answer$iv$iv$iv);
                    object = answer$iv$iv$iv;
                } else {
                    object = value$iv$iv$iv;
                }
                List list$iv$iv = (List)object;
                list$iv$iv.add(element$iv$iv);
            }
            destination$iv$iv.forEach((arg_0, arg_1) -> GameBoard.createTowerStatsText$lambda$29((arg_0, arg_1) -> GameBoard.createTowerStatsText$lambda$28(textBlock, arg_0, arg_1), arg_0, arg_1));
            Iterable $this$filter$iv = tower.getFloors();
            boolean $i$f$filter = false;
            destination$iv$iv = $this$filter$iv;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Floor it = (Floor)element$iv$iv;
                boolean bl = false;
                if (!(it.getOwner() != null && !it.isOwnerValidated())) continue;
                destination$iv$iv2.add(element$iv$iv);
            }
            List unvalidatedFloors = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
            if (!unvalidatedFloors.isEmpty()) {
                void $this$mapTo$iv$iv;
                void $this$map$iv;
                $this$filter$iv = unvalidatedFloors;
                HoveringText hoveringText = textBlock;
                boolean $i$f$map = false;
                $this$filterTo$iv$iv = $this$map$iv;
                destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    Floor it = (Floor)item$iv$iv;
                    Collection collection = destination$iv$iv2;
                    boolean bl = false;
                    collection.add(it.getFloorNumber() + 1);
                }
                hoveringText.addLine("\u26a0 Disconnected Floors: " + CollectionsKt.toList((Iterable)((List)destination$iv$iv2)) + " \u26a0", Color.Companion.getWHITE());
            }
            this.textRenderer.getTextToRender().add(textBlock);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void buildTeamPaths() {
        void $this$mapTo$iv$iv;
        GameColor it;
        Iterable $this$filterTo$iv$iv;
        Collection collection = this.paths;
        Iterable $this$filter$iv = (Iterable)GameColor.getEntries();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (GameColor)((Object)element$iv$iv);
            boolean bl = false;
            if (!it.isTeam()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void team;
            it = (GameColor)((Object)item$iv$iv);
            Collection collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(new Path((GameColor)team));
        }
        $this$map$iv = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
        CollectionsKt.addAll((Collection)collection, (Iterable)$this$map$iv);
        Sequence allTowers = SequencesKt.flattenSequenceOfIterable((Sequence)CollectionsKt.asSequence((Iterable)this.towers));
        Iterable $this$forEach$iv = this.paths;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Object element$iv22;
            Path path;
            block4: {
                void $this$first$iv;
                Object item$iv$iv;
                path = (Path)element$iv;
                boolean bl = false;
                item$iv$iv = SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)allTowers, arg_0 -> GameBoard.buildTeamPaths$lambda$37$lambda$34(path, arg_0)), GameBoard::buildTeamPaths$lambda$37$lambda$35);
                boolean $i$f$first = false;
                for (Object element$iv22 : $this$first$iv) {
                    Floor floor = (Floor)element$iv22;
                    boolean bl2 = false;
                    if (!floor.isBase()) continue;
                    break block4;
                }
                throw new NoSuchElementException("Sequence contains no element matching the predicate.");
            }
            Floor baseFloor = (Floor)element$iv22;
            path.buildPath(baseFloor, SequencesKt.toList((Sequence)allTowers), this.getErrorChannel());
        }
    }

    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin((KoinComponent)this);
    }

    private static final Iterable scanGame$lambda$2(Tower it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFloors();
    }

    private static final Iterable scanGame$lambda$3(Floor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getNodes();
    }

    private static final Iterable calculateScores$lambda$20(Tower it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFloors();
    }

    private static final boolean calculateScores$lambda$21(Floor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.isCaptured() && !Intrinsics.areEqual((Object)it.isCaptureValidated(), (Object)true) || it.isPainted() && !Intrinsics.areEqual((Object)it.isPaintValidated(), (Object)true);
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit createTowerStatsText$lambda$28(HoveringText $textBlock, GameColor team, List groupFloors) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)groupFloors, (String)"groupFloors");
        Iterable $this$map$iv = groupFloors;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Floor floor = (Floor)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getFloorNumber() + 1);
        }
        List floorNumbers = (List)destination$iv$iv;
        HoveringText hoveringText = team == null ? $textBlock.addLine("Uncaptured floors: " + floorNumbers, Color.Companion.getWHITE()) : $textBlock.addLine("Team " + team + " captured: " + floorNumbers, Color.Companion.fromHex(team.getRgba()));
        return Unit.INSTANCE;
    }

    private static final void createTowerStatsText$lambda$29(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final boolean buildTeamPaths$lambda$37$lambda$34(Path $path, Tower tower) {
        Intrinsics.checkNotNullParameter((Object)tower, (String)"tower");
        return tower.getColor() == $path.getPathOwner() && tower.isBase();
    }

    private static final Iterable buildTeamPaths$lambda$37$lambda$35(Tower tower) {
        Intrinsics.checkNotNullParameter((Object)tower, (String)"tower");
        return tower.getFloors();
    }
}

