/*
 * Decompiled with CFR 0.152.
 */
package com.pixelknights.bridgesgame.client.game.entity;

import com.pixelknights.bridgesgame.client.config.ModConfig;
import com.pixelknights.bridgesgame.client.game.entity.Bridge;
import com.pixelknights.bridgesgame.client.game.entity.Floor;
import com.pixelknights.bridgesgame.client.game.entity.GameColor;
import com.pixelknights.bridgesgame.client.game.entity.Node;
import com.pixelknights.bridgesgame.client.game.entity.Tower;
import com.pixelknights.bridgesgame.client.render.Color;
import com.pixelknights.bridgesgame.client.render.DebugLine;
import com.pixelknights.bridgesgame.client.util.MathExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2399;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0011\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\r\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ1\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011\u00a2\u0006\u0004\b\u0015\u0010\u0016J#\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u001b0\u000e2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001c\u0010\u001dR\u0019\u0010\u0003\u001a\u0004\u0018\u00010\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001e\u001a\u0004\b\u001f\u0010 R\u001d\u0010#\u001a\b\u0012\u0004\u0012\u00020\"0!8\u0006\u00a2\u0006\f\n\u0004\b#\u0010$\u001a\u0004\b%\u0010&R\u001d\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00060!8\u0006\u00a2\u0006\f\n\u0004\b'\u0010$\u001a\u0004\b(\u0010&\u00a8\u0006)"}, d2={"Lcom/pixelknights/bridgesgame/client/game/entity/Path;", "", "Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "pathOwner", "<init>", "(Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;)V", "Lcom/pixelknights/bridgesgame/client/game/entity/Floor;", "startingFloor", "", "containsBaseFloor", "(Lcom/pixelknights/bridgesgame/client/game/entity/Floor;)Z", "", "calculateScore", "()I", "", "Lcom/pixelknights/bridgesgame/client/game/entity/Tower;", "allTowers", "Ljava/util/concurrent/BlockingQueue;", "", "errorChannel", "", "buildPath", "(Lcom/pixelknights/bridgesgame/client/game/entity/Floor;Ljava/util/List;Ljava/util/concurrent/BlockingQueue;)V", "Lnet/minecraft/class_1937;", "world", "Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "config", "Lcom/pixelknights/bridgesgame/client/render/DebugLine;", "createDebugLines", "(Lnet/minecraft/class_1937;Lcom/pixelknights/bridgesgame/client/config/ModConfig;)Ljava/util/List;", "Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "getPathOwner", "()Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "", "Lcom/pixelknights/bridgesgame/client/game/entity/Bridge;", "bridges", "Ljava/util/Set;", "getBridges", "()Ljava/util/Set;", "floors", "getFloors", "bridges-judge_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nPath.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Path.kt\ncom/pixelknights/bridgesgame/client/game/entity/Path\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,170:1\n1755#2,3:171\n1782#2,4:174\n774#2:182\n865#2,2:183\n1187#2,2:185\n1261#2,4:187\n1557#2:192\n1628#2,3:193\n774#2:196\n865#2,2:197\n1557#2:199\n1628#2,3:200\n127#3,2:178\n183#3,2:180\n1#4:191\n*S KotlinDebug\n*F\n+ 1 Path.kt\ncom/pixelknights/bridgesgame/client/game/entity/Path\n*L\n20#1:171,3\n29#1:174,4\n92#1:182\n92#1:183,2\n93#1:185,2\n93#1:187,4\n147#1:192\n147#1:193,3\n155#1:196\n155#1:197,2\n156#1:199\n156#1:200,3\n69#1:178,2\n79#1:180,2\n*E\n"})
public final class Path {
    @Nullable
    private final GameColor pathOwner;
    @NotNull
    private final Set<Bridge> bridges;
    @NotNull
    private final Set<Floor> floors;

    public Path(@Nullable GameColor pathOwner) {
        this.pathOwner = pathOwner;
        this.bridges = new LinkedHashSet();
        this.floors = new LinkedHashSet();
    }

    @Nullable
    public final GameColor getPathOwner() {
        return this.pathOwner;
    }

    @NotNull
    public final Set<Bridge> getBridges() {
        return this.bridges;
    }

    @NotNull
    public final Set<Floor> getFloors() {
        return this.floors;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean containsBaseFloor(@NotNull Floor startingFloor) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)startingFloor, (String)"startingFloor");
        if (startingFloor.getTower().getColor() == this.pathOwner) {
            if (startingFloor.isBase()) return true;
        }
        Iterable $this$any$iv = this.floors;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator = $this$any$iv.iterator();
        do {
            if (!iterator.hasNext()) return false;
            Object element$iv = iterator.next();
            Floor it = (Floor)element$iv;
            boolean bl2 = false;
            if (it.getTower().getColor() == this.pathOwner && it.isBase()) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public final int calculateScore() {
        int n;
        if (this.pathOwner == null) {
            return 0;
        }
        Iterable $this$count$iv = this.floors;
        boolean $i$f$count = false;
        if ($this$count$iv instanceof Collection && ((Collection)$this$count$iv).isEmpty()) {
            n = 0;
        } else {
            int count$iv = 0;
            for (Object element$iv : $this$count$iv) {
                Floor it = (Floor)element$iv;
                boolean bl = false;
                if (!(it.getOwner() == this.pathOwner) || ++count$iv >= 0) continue;
                CollectionsKt.throwCountOverflow();
            }
            n = count$iv;
        }
        int capturedFloorPoints = n;
        Set towers = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)CollectionsKt.asSequence((Iterable)this.floors), Path::calculateScore$lambda$2));
        Iterable iterable = towers;
        int n2 = 0;
        for (Object t : iterable) {
            void tower;
            Tower bl = (Tower)t;
            int n3 = n2;
            boolean bl2 = false;
            int n4 = tower.getCapturingTeam() == this.pathOwner ? tower.getCapturePoints(this.pathOwner) : 0;
            n2 = n3 + n4;
        }
        int capturedTowerPoints = n2;
        return capturedFloorPoints + capturedTowerPoints;
    }

    /*
     * WARNING - void declaration
     */
    public final void buildPath(@NotNull Floor startingFloor, @NotNull List<Tower> allTowers, @NotNull BlockingQueue<String> errorChannel) {
        Floor belowFloor;
        Object v0;
        Object it;
        block20: {
            void $this$firstOrNull$iv;
            Sequence $this$first$iv;
            Intrinsics.checkNotNullParameter((Object)startingFloor, (String)"startingFloor");
            Intrinsics.checkNotNullParameter(allTowers, (String)"allTowers");
            Intrinsics.checkNotNullParameter(errorChannel, (String)"errorChannel");
            if (this.floors.contains(startingFloor)) {
                return;
            }
            boolean containsBaseFloor = this.containsBaseFloor(startingFloor);
            if (startingFloor.getCaptureColor() == this.pathOwner) {
                startingFloor.setCaptureValidated(containsBaseFloor);
            }
            if (startingFloor.getPaintColor() == this.pathOwner) {
                startingFloor.setPaintValidated(containsBaseFloor);
            }
            ((Collection)this.floors).add(startingFloor);
            if (startingFloor.getHasLadder()) {
                Object element$iv2;
                block19: {
                    Sequence sequence = SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allTowers), arg_0 -> Path.buildPath$lambda$4(startingFloor, arg_0)), Path::buildPath$lambda$5);
                    boolean $i$f$first = false;
                    for (Object element$iv2 : $this$first$iv) {
                        it = (Floor)element$iv2;
                        boolean bl = false;
                        if (!(((Floor)it).getFloorNumber() == startingFloor.getFloorNumber() + 1)) continue;
                        break block19;
                    }
                    throw new NoSuchElementException("Sequence contains no element matching the predicate.");
                }
                Floor aboveFloor = (Floor)element$iv2;
                this.buildPath(aboveFloor, allTowers, errorChannel);
            }
            $this$first$iv = SequencesKt.flatMapIterable((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)allTowers), arg_0 -> Path.buildPath$lambda$7(startingFloor, arg_0)), Path::buildPath$lambda$8);
            boolean $i$f$firstOrNull = false;
            for (Object element$iv2 : $this$firstOrNull$iv) {
                it = (Floor)element$iv2;
                boolean bl = false;
                if (!(((Floor)it).getFloorNumber() == startingFloor.getFloorNumber() - 1)) continue;
                v0 = element$iv2;
                break block20;
            }
            v0 = null;
        }
        Floor floor = belowFloor = (Floor)v0;
        boolean bl = floor != null ? floor.getHasLadder() : false;
        if (bl) {
            this.buildPath(belowFloor, allTowers, errorChannel);
        }
        for (Node node : startingFloor.getNodes()) {
            Bridge nextBridge = null;
            if (node.getConnectedBridges().size() > 1) {
                Object t;
                Iterator iterator;
                void $this$associateTo$iv$iv;
                void $this$associate$iv;
                Object element$iv$iv2;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                it = node.getConnectedBridges();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv2 : $this$filterTo$iv$iv) {
                    Bridge it2 = (Bridge)element$iv$iv2;
                    boolean bl2 = false;
                    if (!it2.getErrors().isEmpty()) continue;
                    destination$iv$iv.add(element$iv$iv2);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$associate = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associate$iv, (int)10)), (int)16);
                destination$iv$iv = $this$associate$iv;
                Map destination$iv$iv2 = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateTo = false;
                element$iv$iv2 = $this$associateTo$iv$iv.iterator();
                while (element$iv$iv2.hasNext()) {
                    Pair pair;
                    Path path;
                    Object element$iv$iv3 = element$iv$iv2.next();
                    Map bl2 = destination$iv$iv2;
                    Bridge bridge = (Bridge)element$iv$iv3;
                    boolean bl3 = false;
                    Path copy = path = new Path(this.pathOwner);
                    boolean bl4 = false;
                    CollectionsKt.addAll((Collection)copy.bridges, (Iterable)SetsKt.plus(this.bridges, (Object)bridge));
                    CollectionsKt.addAll((Collection)copy.floors, (Iterable)SetsKt.plus(this.floors, (Object)startingFloor));
                    Path pathOption = path;
                    if (bridge.getEndNode() != null) {
                        pathOption.buildPath(bridge.getEndNode().getFloor(), allTowers, errorChannel);
                        pathOption.buildPath(bridge.getStartNode().getFloor(), allTowers, errorChannel);
                        pair = TuplesKt.to((Object)bridge, (Object)pathOption);
                    } else {
                        pair = TuplesKt.to((Object)bridge, null);
                    }
                    Pair pair2 = pair;
                    bl2.put(pair2.getFirst(), pair2.getSecond());
                }
                Map allOptions = destination$iv$iv2;
                if (allOptions.size() > 1) {
                    ((Collection)errorChannel).add("Node " + node.getCoords() + " " + node.getWorldCoords() + " has multiple bridges");
                }
                if (!(iterator = (iterable = (Iterable)allOptions.entrySet()).iterator()).hasNext()) {
                    throw new NoSuchElementException();
                }
                Object t2 = iterator.next();
                if (!iterator.hasNext()) {
                    t = t2;
                } else {
                    Map.Entry option = (Map.Entry)t2;
                    boolean bl5 = false;
                    Path path = (Path)option.getValue();
                    int n = path != null ? path.calculateScore() : Integer.MIN_VALUE;
                    do {
                        int n2;
                        Object t3 = iterator.next();
                        Map.Entry option2 = (Map.Entry)t3;
                        $i$a$-maxByOrThrow-Path$buildPath$bestOption$1 = false;
                        Path path2 = (Path)option2.getValue();
                        int n3 = n2 = path2 != null ? path2.calculateScore() : Integer.MIN_VALUE;
                        if (n >= n2) continue;
                        t2 = t3;
                        n = n2;
                    } while (iterator.hasNext());
                    t = t2;
                }
                Map.Entry bestOption = (Map.Entry)t;
                nextBridge = (Bridge)bestOption.getKey();
            } else {
                nextBridge = (Bridge)CollectionsKt.firstOrNull((Iterable)node.getConnectedBridges());
            }
            if (this.pathOwner == null || nextBridge == null || !nextBridge.canTeamUseBridge(this.pathOwner)) continue;
            ((Collection)this.bridges).add(nextBridge);
            this.buildPath(nextBridge.getStartNode().getFloor(), allTowers, errorChannel);
            Object object = nextBridge.getEndNode();
            if (object == null || (object = ((Node)object).getFloor()) == null) continue;
            this.buildPath((Floor)object, allTowers, errorChannel);
        }
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DebugLine> createDebugLines(@NotNull class_1937 world, @NotNull ModConfig config) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection;
        void $this$mapTo$iv$iv2;
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        GameColor gameColor = this.pathOwner;
        Color color = Color.Companion.fromHex(gameColor != null ? gameColor.getRgba() : 0L);
        Iterable $this$map$iv2 = this.bridges;
        boolean $i$f$map22 = false;
        Iterable iterable = $this$map$iv2;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it;
            Bridge bridge = (Bridge)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getEndNode() == null ? null : new DebugLine(it.getStartNode().getWorldPosition(), it.getEndNode().getWorldPosition(), color, 0.0f, 8, null));
        }
        List bridgeLines = CollectionsKt.toList((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
        Iterable $i$f$map22 = this.floors;
        boolean $i$f$filter = false;
        destination$iv$iv = $this$filter$iv;
        Collection destination$iv$iv2 = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Floor it = (Floor)element$iv$iv;
            boolean bl = false;
            if (!it.getHasLadder()) continue;
            destination$iv$iv2.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv2;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void floor;
            Floor it = (Floor)item$iv$iv;
            collection = destination$iv$iv2;
            boolean bl = false;
            class_2680 ladderBlock = world.method_8320(floor.getWorldCenter());
            class_2680 class_26802 = ladderBlock;
            if (class_26802 == null || (class_26802 = (class_2350)class_26802.method_11654((class_2769)class_2399.field_11253)) == null) {
                class_26802 = class_2350.field_11043;
            }
            class_2680 facing = class_26802;
            class_2338 class_23382 = floor.getWorldCenter();
            class_2382 class_23822 = facing.method_62675();
            Intrinsics.checkNotNullExpressionValue((Object)class_23822, (String)"getVector(...)");
            class_2338 startPos = MathExtKt.plus(class_23382, class_23822);
            class_2338 endPath = startPos.method_10086(config.getTowerConfig().getBlocksBetweenFloors());
            Intrinsics.checkNotNull((Object)endPath);
            collection.add(new DebugLine(startPos, endPath, color, 0.0f, 8, null));
        }
        List ladderLines = CollectionsKt.toList((Iterable)((List)destination$iv$iv2));
        return CollectionsKt.plus((Collection)bridgeLines, (Iterable)ladderLines);
    }

    private static final Tower calculateScore$lambda$2(Floor it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getTower();
    }

    private static final boolean buildPath$lambda$4(Floor $startingFloor, Tower it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$startingFloor.getTower());
    }

    private static final Iterable buildPath$lambda$5(Tower it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFloors();
    }

    private static final boolean buildPath$lambda$7(Floor $startingFloor, Tower it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Intrinsics.areEqual((Object)it, (Object)$startingFloor.getTower());
    }

    private static final Iterable buildPath$lambda$8(Tower it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getFloors();
    }
}

