/*
 * Decompiled with CFR 0.152.
 */
package com.pixelknights.bridgesgame.client.game.entity;

import com.google.common.base.Objects;
import com.pixelknights.bridgesgame.client.config.ModConfig;
import com.pixelknights.bridgesgame.client.game.entity.Floor;
import com.pixelknights.bridgesgame.client.game.entity.GameColor;
import com.pixelknights.bridgesgame.client.util.GameColorHelpersKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_638;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u000f\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001d\u0010\u0010\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0010\u0010\u0011J\u0015\u0010\u0013\u001a\u00020\u00022\u0006\u0010\u0012\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001f\u0010\u0017\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u001d\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u001a\u0010\u001d\u001a\u00020\b2\b\u0010\u001c\u001a\u0004\u0018\u00010\u0001H\u0096\u0002\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u000f\u0010\u001f\u001a\u00020\u0002H\u0016\u00a2\u0006\u0004\b\u001f\u0010 J\u000f\u0010\"\u001a\u00020!H\u0016\u00a2\u0006\u0004\b\"\u0010#R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010$\u001a\u0004\b%\u0010 R\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010$\u001a\u0004\b&\u0010 R\u0017\u0010\u0005\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0005\u0010$\u001a\u0004\b'\u0010 R\u0017\u0010\u0007\u001a\u00020\u00068\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010(\u001a\u0004\b)\u0010*R\u0017\u0010\t\u001a\u00020\b8\u0006\u00a2\u0006\f\n\u0004\b\t\u0010+\u001a\u0004\b\t\u0010,R(\u0010/\u001a\b\u0012\u0004\u0012\u00020.0-8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b/\u00100\u001a\u0004\b1\u00102\"\u0004\b3\u00104R$\u00105\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b5\u0010(\u001a\u0004\b6\u0010*\"\u0004\b\u001a\u00107R\"\u00108\u001a\u00020!8\u0006@\u0006X\u0086\u000e\u00a2\u0006\u0012\n\u0004\b8\u00109\u001a\u0004\b:\u0010#\"\u0004\b;\u0010<\u00a8\u0006="}, d2={"Lcom/pixelknights/bridgesgame/client/game/entity/Tower;", "", "", "row", "column", "numFloors", "Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "color", "", "isBase", "<init>", "(IIILcom/pixelknights/bridgesgame/client/game/entity/GameColor;Z)V", "Lnet/minecraft/class_2338;", "centerTowerPos", "Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "config", "worldCoordinates", "(Lnet/minecraft/class_2338;Lcom/pixelknights/bridgesgame/client/config/ModConfig;)Lnet/minecraft/class_2338;", "team", "getCapturePoints", "(Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;)I", "Lnet/minecraft/class_638;", "world", "getAttemptedClaimingTeam", "(Lnet/minecraft/class_638;Lcom/pixelknights/bridgesgame/client/config/ModConfig;)Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "", "setCapturingTeam", "(Lnet/minecraft/class_638;Lcom/pixelknights/bridgesgame/client/config/ModConfig;)V", "other", "equals", "(Ljava/lang/Object;)Z", "hashCode", "()I", "", "toString", "()Ljava/lang/String;", "I", "getRow", "getColumn", "getNumFloors", "Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "getColor", "()Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "Z", "()Z", "", "Lcom/pixelknights/bridgesgame/client/game/entity/Floor;", "floors", "Ljava/util/List;", "getFloors", "()Ljava/util/List;", "setFloors", "(Ljava/util/List;)V", "capturingTeam", "getCapturingTeam", "(Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;)V", "coords", "Ljava/lang/String;", "getCoords", "setCoords", "(Ljava/lang/String;)V", "bridges-judge_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nTower.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Tower.kt\ncom/pixelknights/bridgesgame/client/game/entity/Tower\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,87:1\n1734#2,3:88\n*S KotlinDebug\n*F\n+ 1 Tower.kt\ncom/pixelknights/bridgesgame/client/game/entity/Tower\n*L\n61#1:88,3\n*E\n"})
public final class Tower {
    private final int row;
    private final int column;
    private final int numFloors;
    @NotNull
    private final GameColor color;
    private final boolean isBase;
    @NotNull
    private List<Floor> floors;
    @Nullable
    private GameColor capturingTeam;
    @NotNull
    private String coords;

    public Tower(int row, int column, int numFloors, @NotNull GameColor color, boolean isBase) {
        Intrinsics.checkNotNullParameter((Object)((Object)color), (String)"color");
        this.row = row;
        this.column = column;
        this.numFloors = numFloors;
        this.color = color;
        this.isBase = isBase;
        this.floors = new ArrayList();
        this.coords = "" + (char)(65 + this.column) + (1 + this.row);
    }

    public final int getRow() {
        return this.row;
    }

    public final int getColumn() {
        return this.column;
    }

    public final int getNumFloors() {
        return this.numFloors;
    }

    @NotNull
    public final GameColor getColor() {
        return this.color;
    }

    public final boolean isBase() {
        return this.isBase;
    }

    @NotNull
    public final List<Floor> getFloors() {
        return this.floors;
    }

    public final void setFloors(@NotNull List<Floor> list) {
        Intrinsics.checkNotNullParameter(list, (String)"<set-?>");
        this.floors = list;
    }

    @Nullable
    public final GameColor getCapturingTeam() {
        return this.capturingTeam;
    }

    public final void setCapturingTeam(@Nullable GameColor gameColor) {
        this.capturingTeam = gameColor;
    }

    @NotNull
    public final String getCoords() {
        return this.coords;
    }

    public final void setCoords(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.coords = string;
    }

    @NotNull
    public final class_2338 worldCoordinates(@NotNull class_2338 centerTowerPos, @NotNull ModConfig config) {
        Intrinsics.checkNotNullParameter((Object)centerTowerPos, (String)"centerTowerPos");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        int centerTowerRow = config.getBoardConfig().getWidth() / 2;
        int centerTowerCol = config.getBoardConfig().getHeight() / 2;
        int rowsFromCenter = this.row - centerTowerRow;
        int colsFromCenter = this.column - centerTowerCol;
        int worldX = centerTowerPos.method_10263() + config.getSpaceBetweenCenters() * colsFromCenter;
        int worldZ = centerTowerPos.method_10260() + config.getSpaceBetweenCenters() * rowsFromCenter;
        return new class_2338(worldX, centerTowerPos.method_10264(), worldZ);
    }

    public final int getCapturePoints(@NotNull GameColor team) {
        Intrinsics.checkNotNullParameter((Object)((Object)team), (String)"team");
        GameColor gameColor = this.color;
        return WhenMappings.$EnumSwitchMapping$0[gameColor.ordinal()] == 1 ? 3 : (gameColor == team ? 1 : 2);
    }

    @Nullable
    public final GameColor getAttemptedClaimingTeam(@NotNull class_638 world, @NotNull ModConfig config) {
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Floor topFloor = this.floors.get(this.numFloors - 1);
        int ceilingBlockOffset = config.getTowerConfig().getBlocksBetweenFloors() / 2;
        class_2338 ceilingBlock = topFloor.getWorldCenter().method_10086(ceilingBlockOffset);
        class_2680 class_26802 = world.method_8320(ceilingBlock);
        return GameColorHelpersKt.getTeamColorForBlock((class_2248)(class_26802 != null ? class_26802.method_26204() : null));
    }

    public final void setCapturingTeam(@NotNull class_638 world, @NotNull ModConfig config) {
        boolean bl;
        GameColor firstColor;
        block4: {
            Intrinsics.checkNotNullParameter((Object)world, (String)"world");
            Intrinsics.checkNotNullParameter((Object)config, (String)"config");
            Floor floor = (Floor)CollectionsKt.firstOrNull(this.floors);
            GameColor gameColor = firstColor = floor != null ? floor.getCaptureColor() : null;
            if (firstColor == null) {
                return;
            }
            Iterable $this$all$iv = this.floors;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Floor it = (Floor)element$iv;
                    boolean bl2 = false;
                    if (it.getOwner() == firstColor && it.isOwnerValidated()) continue;
                    bl = false;
                    break block4;
                }
                bl = true;
            }
        }
        boolean areAllFloorsCaptured = bl;
        GameColor attemptedClaimingTeam = this.getAttemptedClaimingTeam(world, config);
        boolean doesCeilingBlockMatch = attemptedClaimingTeam == firstColor;
        this.capturingTeam = areAllFloorsCaptured && doesCeilingBlockMatch ? firstColor : null;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof Tower)) {
            return false;
        }
        if (this.row != ((Tower)other).row) {
            return false;
        }
        return this.column == ((Tower)other).column;
    }

    public int hashCode() {
        Object[] objectArray = new Object[]{this.row, this.column};
        return Objects.hashCode((Object[])objectArray);
    }

    @NotNull
    public String toString() {
        return "Tower(coords=" + this.coords + ")";
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    @Environment(value=EnvType.CLIENT)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GameColor.values().length];
            try {
                nArray[GameColor.WHITE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

