/*
 * Decompiled with CFR 0.152.
 */
package com.pixelknights.bridgesgame.client.game.entity.scanner;

import com.pixelknights.bridgesgame.client.game.entity.Bridge;
import com.pixelknights.bridgesgame.client.game.entity.BridgeError;
import com.pixelknights.bridgesgame.client.game.entity.GameColor;
import com.pixelknights.bridgesgame.client.game.entity.Node;
import com.pixelknights.bridgesgame.client.game.entity.NodeSide;
import com.pixelknights.bridgesgame.client.game.rules.BridgeTemplate;
import com.pixelknights.bridgesgame.client.util.MathExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_310;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u000f2\u00020\u0001:\u0001\u000fB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J)\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\b\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u000e\u00a8\u0006\u0010"}, d2={"Lcom/pixelknights/bridgesgame/client/game/entity/scanner/BridgeScanner;", "", "Lnet/minecraft/class_310;", "mc", "<init>", "(Lnet/minecraft/class_310;)V", "Lcom/pixelknights/bridgesgame/client/game/entity/Node;", "node", "", "allNodes", "", "Lcom/pixelknights/bridgesgame/client/game/entity/Bridge;", "getBridgesForNode", "(Lcom/pixelknights/bridgesgame/client/game/entity/Node;Ljava/util/List;)Ljava/util/Set;", "Lnet/minecraft/class_310;", "Companion", "bridges-judge_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nBridgeScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BridgeScanner.kt\ncom/pixelknights/bridgesgame/client/game/entity/scanner/BridgeScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,59:1\n1557#2:60\n1628#2,2:61\n774#2:63\n865#2,2:64\n1557#2:66\n1628#2,3:67\n1630#2:70\n*S KotlinDebug\n*F\n+ 1 BridgeScanner.kt\ncom/pixelknights/bridgesgame/client/game/entity/scanner/BridgeScanner\n*L\n17#1:60\n17#1:61,2\n36#1:63\n36#1:64,2\n43#1:66\n43#1:67,3\n17#1:70\n*E\n"})
public final class BridgeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_310 mc;
    @NotNull
    private static final NodeSide[] CORNER_NODES;

    public BridgeScanner(@NotNull class_310 mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        this.mc = mc;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Set<Bridge> getBridgesForNode(@NotNull Node node, @NotNull List<Node> allNodes) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(allNodes, (String)"allNodes");
        Iterable $this$map$iv = CollectionsKt.flatten((Iterable)BridgeTemplate.Companion.getALL_BRIDGE_COMBINATIONS());
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            Bridge bridge;
            void template;
            BridgeTemplate bridgeTemplate = (BridgeTemplate)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            if (ArraysKt.contains((Object[])CORNER_NODES, (Object)((Object)node.getSide())) && !template.isCornerTemplate()) {
                bridge = null;
            } else if (!ArraysKt.contains((Object[])CORNER_NODES, (Object)((Object)node.getSide())) && template.isCornerTemplate()) {
                bridge = null;
            } else {
                List errors = new ArrayList();
                class_2338 class_23382 = node.getWorldPosition().method_10087(2);
                Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"down(...)");
                GameColor owner = template.findBridgeOwner(this.mc, class_23382);
                if (owner == null) {
                    bridge = null;
                } else {
                    void $this$mapTo$iv$iv2;
                    Node it;
                    Iterable $this$filterTo$iv$iv;
                    class_2338 class_23383 = node.getWorldPosition().method_10087(1);
                    Intrinsics.checkNotNullExpressionValue((Object)class_23383, (String)"down(...)");
                    GameColor painter = template.findBridgePainter(this.mc, class_23383);
                    Iterable $this$filter$iv = allNodes;
                    boolean $i$f$filter = false;
                    Iterable iterable2 = $this$filter$iv;
                    Collection destination$iv$iv2 = new ArrayList();
                    boolean $i$f$filterTo = false;
                    for (Object element$iv$iv : $this$filterTo$iv$iv) {
                        it = (Node)element$iv$iv;
                        boolean bl2 = false;
                        if (!Intrinsics.areEqual((Object)it.getWorldPosition(), (Object)MathExtKt.plus(node.getWorldPosition(), template.getTargetNodeOffset()))) continue;
                        destination$iv$iv2.add(element$iv$iv);
                    }
                    List endNode = (List)destination$iv$iv2;
                    if (endNode.isEmpty()) {
                        ((Collection)errors).add(BridgeError.BRIDGE_TO_CLOSED_NODE);
                    }
                    Iterable $this$map$iv2 = template.getBlockCoords();
                    boolean $i$f$map2 = false;
                    $this$filterTo$iv$iv = $this$map$iv2;
                    destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (Object item$iv$iv2 : $this$mapTo$iv$iv2) {
                        void p0;
                        it = (class_2382)item$iv$iv2;
                        Collection collection2 = destination$iv$iv2;
                        boolean bl3 = false;
                        collection2.add(new class_2338((class_2382)p0));
                    }
                    List list = errors;
                    GameColor gameColor = painter;
                    GameColor gameColor2 = owner;
                    Node node2 = (Node)CollectionsKt.firstOrNull((List)endNode);
                    Node node3 = node;
                    List list2 = (List)destination$iv$iv2;
                    bridge = new Bridge(list2, node3, node2, gameColor2, gameColor, list);
                }
            }
            collection.add(bridge);
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv)));
    }

    static {
        NodeSide[] nodeSideArray = new NodeSide[]{NodeSide.NE, NodeSide.SE, NodeSide.NW, NodeSide.SW};
        CORNER_NODES = nodeSideArray;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001a\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/pixelknights/bridgesgame/client/game/entity/scanner/BridgeScanner$Companion;", "", "<init>", "()V", "", "Lcom/pixelknights/bridgesgame/client/game/entity/NodeSide;", "CORNER_NODES", "[Lcom/pixelknights/bridgesgame/client/game/entity/NodeSide;", "bridges-judge_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

