/*
 * Decompiled with CFR 0.152.
 */
package com.pixelknights.bridgesgame.client.game.entity.scanner;

import com.pixelknights.bridgesgame.client.config.ModConfig;
import com.pixelknights.bridgesgame.client.game.entity.Floor;
import com.pixelknights.bridgesgame.client.game.entity.GameColor;
import com.pixelknights.bridgesgame.client.game.entity.Node;
import com.pixelknights.bridgesgame.client.game.entity.NodeSide;
import com.pixelknights.bridgesgame.client.game.entity.Tower;
import com.pixelknights.bridgesgame.client.util.GameColorHelpersKt;
import com.pixelknights.bridgesgame.client.util.MathExtKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_310;
import net.minecraft.class_638;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ%\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u001f\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0014H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018J\u0019\u0010\u001b\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u0019\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u001dR\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u001eR\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u001f\u00a8\u0006 "}, d2={"Lcom/pixelknights/bridgesgame/client/game/entity/scanner/FloorScanner;", "Lorg/koin/core/component/KoinComponent;", "Lorg/apache/logging/log4j/Logger;", "logger", "Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "config", "Lnet/minecraft/class_310;", "mc", "<init>", "(Lorg/apache/logging/log4j/Logger;Lcom/pixelknights/bridgesgame/client/config/ModConfig;Lnet/minecraft/class_310;)V", "Lcom/pixelknights/bridgesgame/client/game/entity/Tower;", "tower", "Lnet/minecraft/class_2338;", "centerCoordinate", "", "floorNum", "Lcom/pixelknights/bridgesgame/client/game/entity/Floor;", "getFloor", "(Lcom/pixelknights/bridgesgame/client/game/entity/Tower;Lnet/minecraft/class_2338;I)Lcom/pixelknights/bridgesgame/client/game/entity/Floor;", "floor", "Lcom/pixelknights/bridgesgame/client/game/entity/NodeSide;", "side", "Lcom/pixelknights/bridgesgame/client/game/entity/Node;", "getNode", "(Lcom/pixelknights/bridgesgame/client/game/entity/Floor;Lcom/pixelknights/bridgesgame/client/game/entity/NodeSide;)Lcom/pixelknights/bridgesgame/client/game/entity/Node;", "worldFloorPosition", "Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "getCapturingTeam", "(Lnet/minecraft/class_2338;)Lcom/pixelknights/bridgesgame/client/game/entity/GameColor;", "Lorg/apache/logging/log4j/Logger;", "Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "Lnet/minecraft/class_310;", "bridges-judge_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nFloorScanner.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FloorScanner.kt\ncom/pixelknights/bridgesgame/client/game/entity/scanner/FloorScanner\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,86:1\n1557#2:87\n1628#2,3:88\n1611#2,9:91\n1863#2:100\n1864#2:102\n1620#2:103\n1#3:101\n*S KotlinDebug\n*F\n+ 1 FloorScanner.kt\ncom/pixelknights/bridgesgame/client/game/entity/scanner/FloorScanner\n*L\n44#1:87\n44#1:88,3\n73#1:91,9\n73#1:100\n73#1:102\n73#1:103\n73#1:101\n*E\n"})
public final class FloorScanner
implements KoinComponent {
    @NotNull
    private final Logger logger;
    @NotNull
    private final ModConfig config;
    @NotNull
    private final class_310 mc;

    public FloorScanner(@NotNull Logger logger, @NotNull ModConfig config, @NotNull class_310 mc) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        this.logger = logger;
        this.config = config;
        this.mc = mc;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Floor getFloor(@NotNull Tower tower, @NotNull class_2338 centerCoordinate, int floorNum) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)tower, (String)"tower");
        Intrinsics.checkNotNullParameter((Object)centerCoordinate, (String)"centerCoordinate");
        int blocksBetweenFloors = this.config.getTowerConfig().getBlocksBetweenFloors();
        class_2338 worldFloorPosition = tower.worldCoordinates(centerCoordinate, this.config).method_10086(floorNum * blocksBetweenFloors);
        class_2338 worldCenterPosition = worldFloorPosition.method_10086(blocksBetweenFloors / 2);
        class_638 class_6382 = this.mc.field_1687;
        boolean hasLadder = Intrinsics.areEqual(class_6382 != null && (class_6382 = class_6382.method_8320(worldCenterPosition)) != null ? class_6382.method_26204() : null, (Object)class_2246.field_9983);
        Intrinsics.checkNotNull((Object)worldFloorPosition);
        GameColor claimingTeam = this.getCapturingTeam(worldFloorPosition);
        class_2338 class_23382 = worldFloorPosition.method_10084();
        Intrinsics.checkNotNullExpressionValue((Object)class_23382, (String)"up(...)");
        GameColor paintingTeam = this.getCapturingTeam(class_23382);
        Intrinsics.checkNotNull((Object)worldCenterPosition);
        GameColor gameColor = paintingTeam;
        if (gameColor == null) {
            gameColor = claimingTeam;
        }
        Floor floor = new Floor(floorNum, hasLadder, tower, worldCenterPosition, gameColor, paintingTeam, tower.isBase() && floorNum == 0);
        Iterable iterable = (Iterable)NodeSide.getEntries();
        Floor floor2 = floor;
        boolean $i$f$map = false;
        void var13_14 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void side;
            NodeSide nodeSide = (NodeSide)((Object)item$iv$iv);
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(this.getNode(floor, (NodeSide)side));
        }
        floor2.setNodes(CollectionsKt.toList((Iterable)((List)destination$iv$iv)));
        return floor;
    }

    private final Node getNode(Floor floor, NodeSide side) {
        Boolean isOpen;
        class_2338 worldCoords = MathExtKt.plus(floor.getWorldCenter(), MathExtKt.times(side.getVector(), 2));
        class_638 class_6382 = this.mc.field_1687;
        Boolean bl = isOpen = class_6382 != null && (class_6382 = class_6382.method_8320(worldCoords)) != null ? Boolean.valueOf(class_6382.method_26215()) : null;
        return new Node(side, bl != null ? bl : false, floor, worldCoords);
    }

    /*
     * WARNING - void declaration
     */
    private final GameColor getCapturingTeam(class_2338 worldFloorPosition) {
        void $this$mapNotNullTo$iv$iv;
        Object[] objectArray = new class_2338[]{worldFloorPosition.method_10095(), worldFloorPosition.method_10078(), worldFloorPosition.method_10072(), worldFloorPosition.method_10067()};
        Iterable $this$mapNotNull$iv = CollectionsKt.listOf((Object[])objectArray);
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            GameColor it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            class_2338 coords = (class_2338)element$iv$iv;
            boolean bl2 = false;
            class_638 class_6382 = this.mc.field_1687;
            if (GameColorHelpersKt.getTeamColorForBlock(class_6382 != null && (class_6382 = class_6382.method_8320(coords)) != null ? class_6382.method_26204() : null) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        Set teamClaims = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        if (teamClaims.size() > 1) {
            this.logger.warn("The floor at (" + worldFloorPosition + ") has multiple claiming teams. Determining the floor unclaimed.");
            return null;
        }
        return (GameColor)((Object)CollectionsKt.firstOrNull((Iterable)teamClaims));
    }

    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin((KoinComponent)this);
    }
}

