/*
 * Decompiled with CFR 0.152.
 */
package com.pixelknights.bridgesgame.client.render;

import com.pixelknights.bridgesgame.client.config.ModConfig;
import com.pixelknights.bridgesgame.client.render.HoveringText;
import com.pixelknights.bridgesgame.client.render.TextLine;
import com.pixelknights.bridgesgame.client.util.MathExtKt;
import java.util.ArrayList;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.LazyThreadSafetyMode;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_4184;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;
import org.joml.Math;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.koin.core.Koin;
import org.koin.core.component.KoinComponent;
import org.koin.core.component.KoinScopeComponent;
import org.koin.core.qualifier.Qualifier;
import org.koin.core.scope.Scope;
import org.koin.mp.KoinPlatformTools;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0015\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\nJ%\u0010\u000f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0011R\u001d\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00130\u00128\u0006\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0016\u0010\u0017R\u001b\u0010\u001d\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001f"}, d2={"Lcom/pixelknights/bridgesgame/client/render/HoveringTextRenderer;", "Lorg/koin/core/component/KoinComponent;", "Lnet/minecraft/class_310;", "mc", "<init>", "(Lnet/minecraft/class_310;)V", "Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;", "context", "", "renderAllText", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;)V", "Lcom/pixelknights/bridgesgame/client/render/TextLine;", "text", "Lorg/joml/Vector3f;", "pos", "renderText", "(Lnet/fabricmc/fabric/api/client/rendering/v1/WorldRenderContext;Lcom/pixelknights/bridgesgame/client/render/TextLine;Lorg/joml/Vector3f;)V", "Lnet/minecraft/class_310;", "", "Lcom/pixelknights/bridgesgame/client/render/HoveringText;", "textToRender", "Ljava/util/List;", "getTextToRender", "()Ljava/util/List;", "Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "config$delegate", "Lkotlin/Lazy;", "getConfig", "()Lcom/pixelknights/bridgesgame/client/config/ModConfig;", "config", "Companion", "bridges-judge_client"})
@Environment(value=EnvType.CLIENT)
@SourceDebugExtension(value={"SMAP\nHoveringText.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HoveringText.kt\ncom/pixelknights/bridgesgame/client/render/HoveringTextRenderer\n+ 2 KoinComponent.kt\norg/koin/core/component/KoinComponentKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n58#2,6:93\n1863#3:99\n1872#3,3:100\n1864#3:103\n*S KotlinDebug\n*F\n+ 1 HoveringText.kt\ncom/pixelknights/bridgesgame/client/render/HoveringTextRenderer\n*L\n39#1:93,6\n49#1:99\n51#1:100,3\n49#1:103\n*E\n"})
public final class HoveringTextRenderer
implements KoinComponent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final class_310 mc;
    @NotNull
    private final List<HoveringText> textToRender;
    @NotNull
    private final Lazy config$delegate;
    private static final double MAX_DISTANCE = 4096.0;
    private static final double TEXT_HEIGHT = 1.0;
    private static final int LIGHT = 0xF000F0;
    @NotNull
    private static final class_243 TEXT_OFFSET = new class_243(0.5, 1.0, 0.5);
    private static final float SCALE = 0.04f;

    public HoveringTextRenderer(@NotNull class_310 mc) {
        Intrinsics.checkNotNullParameter((Object)mc, (String)"mc");
        this.mc = mc;
        this.textToRender = new ArrayList();
        KoinComponent $this$inject_u24default$iv = this;
        Qualifier qualifier$iv = null;
        LazyThreadSafetyMode mode$iv = KoinPlatformTools.INSTANCE.defaultLazyMode();
        Function0 parameters$iv = null;
        boolean $i$f$inject = false;
        this.config$delegate = LazyKt.lazy((LazyThreadSafetyMode)mode$iv, (Function0)((Function0)new Function0<ModConfig>($this$inject_u24default$iv, qualifier$iv, parameters$iv){
            final /* synthetic */ KoinComponent $this_inject;
            final /* synthetic */ Qualifier $qualifier;
            final /* synthetic */ Function0 $parameters;
            {
                this.$this_inject = $receiver;
                this.$qualifier = $qualifier;
                this.$parameters = $parameters;
            }

            /*
             * WARNING - void declaration
             */
            public final ModConfig invoke() {
                Object object;
                void $this$get$iv;
                KoinComponent koinComponent = this.$this_inject;
                Qualifier qualifier = this.$qualifier;
                Function0 parameters$iv = this.$parameters;
                boolean $i$f$get = false;
                if ($this$get$iv instanceof KoinScopeComponent) {
                    Scope this_$iv$iv = ((KoinScopeComponent)$this$get$iv).getScope();
                    boolean $i$f$get2 = false;
                    object = this_$iv$iv.get(Reflection.getOrCreateKotlinClass(ModConfig.class), (Qualifier)qualifier$iv, parameters$iv);
                } else {
                    Koin this_$iv$iv = $this$get$iv.getKoin();
                    boolean $i$f$get3 = false;
                    Scope this_$iv$iv$iv = this_$iv$iv.getScopeRegistry().getRootScope();
                    boolean $i$f$get4 = false;
                    object = this_$iv$iv$iv.get(Reflection.getOrCreateKotlinClass(ModConfig.class), (Qualifier)qualifier$iv, parameters$iv);
                }
                return object;
            }
        }));
    }

    @NotNull
    public final List<HoveringText> getTextToRender() {
        return this.textToRender;
    }

    @NotNull
    public final ModConfig getConfig() {
        Lazy lazy = this.config$delegate;
        return (ModConfig)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    public final void renderAllText(@NotNull WorldRenderContext context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!this.getConfig().getPlayerSettings().getShowTowerState()) {
            return;
        }
        float fontHeight = (float)this.mc.field_1772.field_2000 * 0.04f;
        Iterable $this$forEach$iv = this.textToRender;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            HoveringText textBlock = (HoveringText)element$iv;
            boolean bl = false;
            Vector3f position = MathExtKt.toVector3f(textBlock.getWorldPos());
            Iterable $this$forEachIndexed$iv = textBlock.getLines();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void line;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                TextLine textLine = (TextLine)item$iv;
                int index = n;
                boolean bl2 = false;
                Vector3f offset = new Vector3f(0.0f, (float)(textBlock.getLines().size() - index) * fontHeight, 0.0f);
                this.renderText(context, (TextLine)line, MathExtKt.minus(position, offset));
            }
        }
    }

    public final void renderText(@NotNull WorldRenderContext context, @NotNull TextLine text, @NotNull Vector3f pos) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        Intrinsics.checkNotNullParameter((Object)pos, (String)"pos");
        Matrix4f matrix = new Matrix4f();
        class_4184 camera = context.camera();
        Vector3f cameraPos = camera.method_19326().method_46409();
        class_4597 class_45972 = context.consumers();
        if (class_45972 == null) {
            return;
        }
        class_4597 vertexConsumers = class_45972;
        class_327 textRenderer = this.mc.field_1772;
        matrix.translate(pos.x, pos.y, pos.z);
        matrix.translate(-cameraPos.x, -cameraPos.y, -cameraPos.z);
        matrix.translate(0.5f, 1.0f, 0.5f);
        float angleX = Math.atan2((float)(pos.x - cameraPos.x), (float)(pos.z - cameraPos.z));
        Quaternionf rotation = new Quaternionf().rotationY(angleX);
        matrix.rotate((Quaternionfc)rotation);
        matrix.scale(-0.04f, -0.04f, 0.04f);
        float xPos = (float)(-textRenderer.method_1727(text.getText())) / 2.0f;
        textRenderer.method_27521(text.getText(), xPos, 0.0f, text.getColor().getArgb(), false, matrix, vertexConsumers, class_327.class_6415.field_33993, 8488329, 0xF000F0);
    }

    @NotNull
    public Koin getKoin() {
        return KoinComponent.DefaultImpls.getKoin((KoinComponent)this);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\u0006R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\t\u0010\nR\u0014\u0010\f\u001a\u00020\u000b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\f\u0010\rR\u0014\u0010\u000f\u001a\u00020\u000e8\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lcom/pixelknights/bridgesgame/client/render/HoveringTextRenderer$Companion;", "", "<init>", "()V", "", "MAX_DISTANCE", "D", "TEXT_HEIGHT", "", "LIGHT", "I", "Lnet/minecraft/class_243;", "TEXT_OFFSET", "Lnet/minecraft/class_243;", "", "SCALE", "F", "bridges-judge_client"})
    @Environment(value=EnvType.CLIENT)
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

