/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.block.entity;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import sen.manaita_plus.common.block.ManaitaPlusBrewingStandBlock;
import sen.manaita_plus.common.core.ManaitaPlusBlockEntityCore;
import sen.manaita_plus.common.gui.ManaitaPlusBrewingStandMenu;

public class ManaitaPlusBrewingStandBlockEntity
extends BaseContainerBlockEntity
implements WorldlyContainer {
    private static final int[] SLOTS_FOR_UP = new int[]{3};
    private static final int[] SLOTS_FOR_DOWN = new int[]{0, 1, 2, 3};
    private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
    private NonNullList<ItemStack> items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
    int brewTime;
    private boolean[] lastPotionCount;
    int fuel;
    protected final ContainerData dataAccess = new ContainerData(){

        public int m_6413_(int p_59038_) {
            switch (p_59038_) {
                case 0: {
                    return ManaitaPlusBrewingStandBlockEntity.this.brewTime;
                }
                case 1: {
                    return ManaitaPlusBrewingStandBlockEntity.this.fuel;
                }
            }
            return 0;
        }

        public void m_8050_(int p_59040_, int p_59041_) {
            switch (p_59040_) {
                case 0: {
                    ManaitaPlusBrewingStandBlockEntity.this.brewTime = p_59041_;
                    break;
                }
                case 1: {
                    ManaitaPlusBrewingStandBlockEntity.this.fuel = p_59041_;
                }
            }
        }

        public int m_6499_() {
            return 2;
        }
    };
    LazyOptional<? extends IItemHandler>[] handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});

    public ManaitaPlusBrewingStandBlockEntity(BlockPos p_155283_, BlockState p_155284_) {
        super((BlockEntityType)ManaitaPlusBlockEntityCore.BREWING_BLOCK_ENTITY.get(), p_155283_, p_155284_);
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.brewing_manaita");
    }

    public int m_6643_() {
        return this.items.size();
    }

    public boolean m_7983_() {
        for (ItemStack itemstack : this.items) {
            if (itemstack.m_41619_()) continue;
            return false;
        }
        return true;
    }

    public static void serverTick(Level p_155286_, BlockPos p_155287_, BlockState p_155288_, ManaitaPlusBrewingStandBlockEntity p_155289_) {
        boolean[] aboolean;
        if (ManaitaPlusBrewingStandBlockEntity.isBrewable(p_155289_.items)) {
            ManaitaPlusBrewingStandBlockEntity.doBrew(p_155286_, p_155287_, p_155289_.items);
            ManaitaPlusBrewingStandBlockEntity.m_155232_((Level)p_155286_, (BlockPos)p_155287_, (BlockState)p_155288_);
        }
        if (!Arrays.equals(aboolean = p_155289_.getPotionBits(), p_155289_.lastPotionCount)) {
            p_155289_.lastPotionCount = aboolean;
            BlockState blockstate = p_155288_;
            if (!(p_155288_.m_60734_() instanceof ManaitaPlusBrewingStandBlock)) {
                return;
            }
            for (int i = 0; i < ManaitaPlusBrewingStandBlock.HAS_BOTTLE.length; ++i) {
                blockstate = (BlockState)blockstate.m_61124_((Property)ManaitaPlusBrewingStandBlock.HAS_BOTTLE[i], (Comparable)Boolean.valueOf(aboolean[i]));
            }
            p_155286_.m_7731_(p_155287_, blockstate, 2);
        }
    }

    private boolean[] getPotionBits() {
        boolean[] aboolean = new boolean[3];
        for (int i = 0; i < 3; ++i) {
            if (((ItemStack)this.items.get(i)).m_41619_()) continue;
            aboolean[i] = true;
        }
        return aboolean;
    }

    private static boolean isBrewable(NonNullList<ItemStack> p_155295_) {
        ItemStack itemstack = (ItemStack)p_155295_.get(3);
        if (!itemstack.m_41619_()) {
            return BrewingRecipeRegistry.canBrew(p_155295_, (ItemStack)itemstack, (int[])SLOTS_FOR_SIDES);
        }
        if (itemstack.m_41619_()) {
            return false;
        }
        if (!PotionBrewing.m_43506_((ItemStack)itemstack)) {
            return false;
        }
        for (int i = 0; i < 3; ++i) {
            ItemStack itemstack1 = (ItemStack)p_155295_.get(i);
            if (itemstack1.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
            return true;
        }
        return false;
    }

    private static void doBrew(Level p_155291_, BlockPos p_155292_, NonNullList<ItemStack> p_155293_) {
        if (ForgeEventFactory.onPotionAttemptBrew(p_155293_)) {
            return;
        }
        ItemStack itemstack = (ItemStack)p_155293_.get(3);
        BrewingRecipeRegistry.brewPotions(p_155293_, (ItemStack)itemstack, (int[])SLOTS_FOR_SIDES);
        for (int slotsForSide : SLOTS_FOR_SIDES) {
            ItemStack itemStack = (ItemStack)p_155293_.get(slotsForSide);
            if (itemstack == ItemStack.f_41583_) continue;
            itemStack.m_41764_(itemStack.m_41613_() * 64);
        }
        ForgeEventFactory.onPotionBrewed(p_155293_);
        if (itemstack.hasCraftingRemainingItem()) {
            ItemStack itemstack1 = itemstack.getCraftingRemainingItem().m_41777_();
            itemstack.m_41774_(1);
            if (itemstack.m_41619_()) {
                itemstack = itemstack1;
            } else {
                Containers.m_18992_((Level)p_155291_, (double)p_155292_.m_123341_(), (double)p_155292_.m_123342_(), (double)p_155292_.m_123343_(), (ItemStack)itemstack1);
            }
        } else {
            itemstack.m_41774_(1);
        }
        p_155293_.set(3, (Object)itemstack);
        p_155291_.m_46796_(1035, p_155292_, 0);
    }

    public void m_142466_(CompoundTag p_155297_) {
        super.m_142466_(p_155297_);
        this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        ContainerHelper.m_18980_((CompoundTag)p_155297_, this.items);
    }

    protected void m_183515_(CompoundTag p_187484_) {
        super.m_183515_(p_187484_);
        ContainerHelper.m_18973_((CompoundTag)p_187484_, this.items);
    }

    public ItemStack m_8020_(int p_58985_) {
        return p_58985_ >= 0 && p_58985_ < this.items.size() ? (ItemStack)this.items.get(p_58985_) : ItemStack.f_41583_;
    }

    public ItemStack m_7407_(int p_58987_, int p_58988_) {
        return ContainerHelper.m_18969_(this.items, (int)p_58987_, (int)p_58988_);
    }

    public ItemStack m_8016_(int p_59015_) {
        return ContainerHelper.m_18966_(this.items, (int)p_59015_);
    }

    public void m_6836_(int p_58993_, ItemStack p_58994_) {
        if (p_58993_ >= 0 && p_58993_ < this.items.size()) {
            this.items.set(p_58993_, (Object)p_58994_);
        }
    }

    public boolean m_6542_(Player p_59000_) {
        return Container.m_272074_((BlockEntity)this, (Player)p_59000_);
    }

    public boolean m_7013_(int p_59017_, ItemStack p_59018_) {
        if (p_59017_ == 3) {
            return BrewingRecipeRegistry.isValidIngredient((ItemStack)p_59018_);
        }
        if (p_59017_ == 4) {
            return p_59018_.m_150930_(Items.f_42593_);
        }
        return BrewingRecipeRegistry.isValidInput((ItemStack)p_59018_) && this.m_8020_(p_59017_).m_41619_();
    }

    public int[] m_7071_(Direction p_59010_) {
        if (p_59010_ == Direction.UP) {
            return SLOTS_FOR_UP;
        }
        return p_59010_ == Direction.DOWN ? SLOTS_FOR_DOWN : SLOTS_FOR_SIDES;
    }

    public boolean m_7155_(int p_58996_, ItemStack p_58997_, @Nullable Direction p_58998_) {
        return this.m_7013_(p_58996_, p_58997_);
    }

    public boolean m_7157_(int p_59020_, ItemStack p_59021_, Direction p_59022_) {
        return p_59020_ == 3 ? p_59021_.m_150930_(Items.f_42590_) : true;
    }

    public void m_6211_() {
        this.items.clear();
    }

    protected AbstractContainerMenu m_6555_(int p_58990_, Inventory p_58991_) {
        return new ManaitaPlusBrewingStandMenu(p_58990_, p_58991_, (Container)this, this.dataAccess);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction facing) {
        if (!this.f_58859_ && facing != null && capability == ForgeCapabilities.ITEM_HANDLER) {
            if (facing == Direction.UP) {
                return this.handlers[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.handlers[1].cast();
            }
            return this.handlers[2].cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        for (int x = 0; x < this.handlers.length; ++x) {
            this.handlers[x].invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        this.handlers = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    }
}

