/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sen.manaita_plus.common.core.ManaitaPlusEntityCore;
import sen.manaita_plus.common.entity.ManaitaPlusLightningBolt;
import sen.manaita_plus.common.item.data.IManaitaPlusKey;
import sen.manaita_plus.common.util.ManaitaPlusText;
import sen.manaita_plus.common.util.ManaitaPlusUtils;

public class ManaitaPlusGodSwordItem
extends SwordItem
implements IManaitaPlusKey {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public ManaitaPlusGodSwordItem() {
        super((Tier)new ManaitaPlusGodItemTier(), 0, 0.0f, new Item.Properties().m_41486_());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", Double.POSITIVE_INFINITY, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Double.POSITIVE_INFINITY, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
    }

    public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
        if (p_41406_ instanceof Player) {
            Player player = (Player)p_41406_;
            player.m_150110_().f_35936_ = true;
        }
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            ManaitaPlusUtils.godKill(player, ManaitaPlusGodSwordItem.isRemove(stack));
        }
        return super.onEntitySwing(stack, entity);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        ManaitaPlusUtils.kill(entity, player.m_6144_(), ManaitaPlusGodSwordItem.isRemove(stack));
        return super.onLeftClickEntity(stack, player, entity);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player player, InteractionHand p_41434_) {
        ItemStack itemstack = player.m_21120_(p_41434_);
        player.m_6672_(p_41434_);
        if (!p_41432_.f_46443_) {
            Random random = new Random();
            Vec3 position = player.m_20182_();
            for (int i = 0; i < 100; ++i) {
                ManaitaPlusLightningBolt bolt = (ManaitaPlusLightningBolt)((EntityType)ManaitaPlusEntityCore.ManaitaLightningBolt.get()).m_20615_(p_41432_);
                if (bolt == null) continue;
                double angle = random.nextDouble() * 20.0 * Math.PI;
                double distance = random.nextGaussian() * 100.0 + 3.0;
                double x = Math.sin(angle) * distance + position.f_82479_;
                double z = Math.cos(angle) * distance + position.f_82481_;
                int y = p_41432_.m_6924_(Heightmap.Types.WORLD_SURFACE_WG, (int)x, (int)z);
                bolt.m_6034_(x, y, z);
                p_41432_.m_7967_((Entity)bolt);
            }
        }
        ManaitaPlusUtils.godKill(player, ManaitaPlusGodSwordItem.isRemove(itemstack));
        return InteractionResultHolder.m_19098_((Object)itemstack);
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_43274_) {
        return p_43274_ == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(p_43274_);
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.doubling", (Object[])new Object[0]) + ":" + (ManaitaPlusGodSwordItem.getDoubling(p_41421_) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.remove.name", (Object[])new Object[0]) + ":" + (ManaitaPlusGodSwordItem.isRemove(p_41421_) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
        p_41423_.add((Component)Component.m_237119_());
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_enchantment.formatting(I18n.m_118938_((String)"info.item.manaita_sword_god.1", (Object[])new Object[0]))));
    }

    public Component m_7626_(ItemStack p_41458_) {
        return Component.m_237113_((String)ManaitaPlusText.manaita_infinity.formatting(I18n.m_118938_((String)"item.manaita_sword_god.name", (Object[])new Object[0])));
    }

    public int m_8105_(ItemStack p_41454_) {
        return 72000;
    }

    public UseAnim m_6164_(ItemStack p_41452_) {
        return UseAnim.BLOCK;
    }

    public boolean m_5812_(ItemStack p_41453_) {
        return true;
    }

    public boolean m_8120_(ItemStack p_41456_) {
        return true;
    }

    @Override
    public void onManaitaKeyPress(ItemStack itemStack, Player player) {
        if (player.m_6144_()) {
            boolean remove = !ManaitaPlusGodSwordItem.isRemove(itemStack);
            ManaitaPlusGodSwordItem.setRemove(itemStack, remove);
            ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(String.format("[%s] %s: %s", I18n.m_118938_((String)"item.manaita_sword_god.name", (Object[])new Object[0]), I18n.m_118938_((String)"mode.remove.name", (Object[])new Object[0]), remove ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
        } else {
            boolean doubling = !ManaitaPlusGodSwordItem.getDoubling(itemStack);
            ManaitaPlusGodSwordItem.setDoubling(itemStack, doubling);
            ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(String.format("[%s] %s: %s", I18n.m_118938_((String)"item.manaita_sword_god.name", (Object[])new Object[0]), I18n.m_118938_((String)"mode.doubling", (Object[])new Object[0]), doubling ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
        }
    }

    public static boolean getDoubling(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        return itemStack.m_41783_().m_128471_("Doubling");
    }

    public static boolean isRemove(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        return itemStack.m_41783_().m_128471_("Remove");
    }

    public static void setRemove(ItemStack itemStack, boolean remove) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        itemStack.m_41783_().m_128379_("Remove", remove);
    }

    public static void setDoubling(ItemStack itemStack, boolean doubling) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        itemStack.m_41783_().m_128379_("Doubling", doubling);
    }

    public static final class ManaitaPlusGodItemTier
    implements Tier {
        public int m_6609_() {
            return -1;
        }

        public float m_6624_() {
            return Float.MAX_VALUE;
        }

        public float m_6631_() {
            return Float.MAX_VALUE;
        }

        public int m_6604_() {
            return Integer.MAX_VALUE;
        }

        public int m_6601_() {
            return 0;
        }

        public Ingredient m_6282_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_});
        }

        @Nullable
        public TagKey<Block> getTag() {
            return BlockTags.create((ResourceLocation)new ResourceLocation("forge", "needs_manaita_tool"));
        }
    }
}

