/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.Nullable;
import sen.manaita_plus.common.item.data.IManaitaPlusKey;
import sen.manaita_plus.common.util.ManaitaPlusText;

public class ManaitaPlusSwordItem
extends SwordItem
implements IManaitaPlusKey {
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;
    public static final Predicate<Entity> YES = p_20434_ -> true;

    public ManaitaPlusSwordItem() {
        super((Tier)new ItemManaitaSwordTier(), 0, 0.0f, new Item.Properties().m_41486_());
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", Double.POSITIVE_INFINITY, AttributeModifier.Operation.ADDITION));
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", Double.POSITIVE_INFINITY, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    public boolean onEntitySwing(ItemStack stack, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            int sweep = ManaitaPlusSwordItem.getSweep(stack);
            for (int i1 = 0; i1 < sweep; ++i1) {
                Vec3 vec3 = player.m_20154_();
                AABB aabb = player.m_20191_().m_82363_(3.0, 3.0, 3.0).m_82386_(vec3.f_82479_ * (double)i1, vec3.f_82480_ * (double)i1, vec3.f_82481_ * (double)i1);
                for (Entity entity1 : player.m_9236_().m_6249_((Entity)player, aabb, YES)) {
                    int i;
                    if (!(entity1 instanceof LivingEntity)) continue;
                    LivingEntity living = (LivingEntity)entity1;
                    if (player.m_9236_() instanceof ServerLevel) {
                        living.m_6469_(living.m_269291_().m_269075_(player), Float.POSITIVE_INFINITY);
                        living.m_6667_(living.m_269291_().m_269075_(player));
                        living.m_21153_(Float.NaN);
                        living.f_20919_ = 15;
                    }
                    for (i = 0; i < 5; ++i) {
                        living.m_7822_((byte)2);
                    }
                    for (i = 47; i < 53; ++i) {
                        living.m_7822_((byte)i);
                    }
                    living.m_7822_((byte)3);
                }
                double d0 = -Mth.m_14031_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                double d1 = Mth.m_14089_((float)(player.m_146908_() * ((float)Math.PI / 180)));
                Level level = player.m_9236_();
                if (level instanceof ServerLevel) {
                    ServerLevel serverLevel = (ServerLevel)level;
                    serverLevel.m_8767_((ParticleOptions)ParticleTypes.f_123766_, player.m_20185_() + d0 + vec3.f_82479_ * (double)i1, player.m_20227_(0.5) + vec3.f_82480_ * (double)i1, player.m_20189_() + d1 + vec3.f_82481_ * (double)i1, 0, d0, 0.0, d1, 0.0);
                }
                player.m_9236_().m_6263_(null, player.m_20185_() + d0 + vec3.f_82479_ * (double)i1, player.m_20227_(0.5) + vec3.f_82480_ * (double)i1, player.m_20189_() + d1 + vec3.f_82481_ * (double)i1, SoundEvents.f_12317_, player.m_5720_(), 1.0f, 1.0f);
            }
        }
        return false;
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> m_7167_(EquipmentSlot p_43274_) {
        return p_43274_ == EquipmentSlot.MAINHAND ? this.defaultModifiers : super.m_7167_(p_43274_);
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.manaita_sword", (Object[])new Object[0]) + ":" + ManaitaPlusSwordItem.getSweep(p_41421_))));
        p_41423_.add((Component)Component.m_237119_());
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_infinity.formatting(I18n.m_118938_((String)"info.attack", (Object[])new Object[0]))));
    }

    public Component m_7626_(ItemStack p_41458_) {
        return Component.m_237113_((String)ManaitaPlusText.manaita_infinity.formatting(I18n.m_118938_((String)"item.manaita_sword.name", (Object[])new Object[0])));
    }

    @Override
    public void onManaitaKeyPress(ItemStack itemStack, Player player) {
        ManaitaPlusSwordItem.toggleSweep(itemStack);
        Minecraft.m_91087_().f_91065_.m_93063_((Component)Component.m_237113_((String)String.format("[%s%s] %s%s: %s", ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"item.manaita_sword.name", (Object[])new Object[0])), ChatFormatting.RESET, ChatFormatting.RESET, I18n.m_118938_((String)"mode.manaita_sword", (Object[])new Object[0]), ManaitaPlusSwordItem.getSweep(itemStack))), false);
    }

    public boolean onLeftClickEntity(ItemStack stack, Player player, Entity entity) {
        entity.m_6469_(new DamageSource((Holder)player.m_9236_().m_9598_().m_175515_(Registries.f_268580_).m_246971_(DamageTypes.f_268724_), entity), 1.0f);
        return super.onLeftClickEntity(stack, player, entity);
    }

    public static int getSweep(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        int sweep = itemStack.m_41783_().m_128451_("Sweep");
        return sweep;
    }

    public static void toggleSweep(ItemStack itemStack) {
        int sweep;
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        if ((sweep = itemStack.m_41783_().m_128451_("Sweep")) == 0) {
            sweep = 1;
        }
        itemStack.m_41783_().m_128405_("Sweep", sweep * 4 % 2048);
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
    }

    public static final class ItemManaitaSwordTier
    implements Tier {
        public int m_6609_() {
            return -1;
        }

        public float m_6624_() {
            return Float.MAX_VALUE;
        }

        public float m_6631_() {
            return Float.MAX_VALUE;
        }

        public int m_6604_() {
            return Integer.MAX_VALUE;
        }

        public int m_6601_() {
            return 0;
        }

        public Ingredient m_6282_() {
            return Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42418_});
        }

        @Nullable
        public TagKey<Block> getTag() {
            return BlockTags.create((ResourceLocation)new ResourceLocation("forge", "needs_manaita_tool"));
        }
    }
}

