/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.item.armor;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import sen.manaita_plus.common.item.data.IManaitaPlusKey;
import sen.manaita_plus.common.util.ManaitaPlusText;
import sen.manaita_plus.common.util.ManaitaPlusUtils;

public class ManaitaPlusArmor
extends ArmorItem {
    public ManaitaPlusArmor(ArmorItem.Type p_266831_) {
        super((ArmorMaterial)new ManaitaPlusArmorMaterial(), p_266831_, new Item.Properties().m_41486_());
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_infinity.formatting(I18n.m_118938_((String)"info.armor", (Object[])new Object[0]))));
    }

    static class ManaitaPlusArmorMaterial
    implements ArmorMaterial {
        ManaitaPlusArmorMaterial() {
        }

        public int m_266425_(ArmorItem.Type p_266807_) {
            return -1;
        }

        public int m_7366_(ArmorItem.Type p_267168_) {
            return 0;
        }

        public int m_6646_() {
            return 0;
        }

        public SoundEvent m_7344_() {
            return SoundEvents.f_11680_;
        }

        public Ingredient m_6230_() {
            return null;
        }

        public String m_6082_() {
            return "manaita_armor";
        }

        public float m_6651_() {
            return 0.0f;
        }

        public float m_6649_() {
            return 0.0f;
        }
    }

    public static class Boots
    extends ManaitaPlusArmor
    implements IManaitaPlusKey {
        public Boots() {
            super(ArmorItem.Type.BOOTS);
        }

        public Component m_7626_(ItemStack p_41458_) {
            return Component.m_237113_((String)I18n.m_118938_((String)"item.boots.name", (Object[])new Object[0]));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "manaita_plus:textures/models/armor/manaita_armor_layer_2.png";
        }

        public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
            if (p_41407_ == 0 && p_41406_ instanceof Player) {
                Player player = (Player)p_41406_;
                player.m_150110_().f_35936_ = true;
                int speed = Boots.getSpeed(p_41404_);
                float p22101 = 0.1f * (float)speed;
                player.m_21051_(Attributes.f_22279_).m_22100_((double)p22101);
                player.m_150110_().m_35948_(p22101);
                player.m_150110_().m_35943_(p22101 / 2.0f);
            }
        }

        @Override
        public void onManaitaKeyPress(ItemStack paramItemStack, Player paramEntityPlayer) {
            if (!paramEntityPlayer.m_6144_()) {
                Boots.setSpeed(paramItemStack);
            }
        }

        public static int getSpeed(ItemStack itemStack) {
            return Math.max(itemStack.m_41784_().m_128451_("Speed"), 1);
        }

        public static void setSpeed(ItemStack itemStack) {
            int speed = Math.max(1, itemStack.m_41784_().m_128451_("Speed") + 1) % 9;
            itemStack.m_41783_().m_128405_("Speed", speed);
            ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(String.format("[%s] %s: %d", I18n.m_118938_((String)"item.boots.name", (Object[])new Object[0]), I18n.m_118938_((String)"mode.speed", (Object[])new Object[0]), speed))));
        }
    }

    public static class Leggings
    extends ManaitaPlusArmor
    implements IManaitaPlusKey {
        public Leggings() {
            super(ArmorItem.Type.LEGGINGS);
        }

        public Component m_7626_(ItemStack p_41458_) {
            return Component.m_237113_((String)I18n.m_118938_((String)"item.leggings.name", (Object[])new Object[0]));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "manaita_plus:textures/models/armor/manaita_armor_layer_2.png";
        }

        public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
            if (p_41407_ == 1 && p_41406_ instanceof Player) {
                Player player = (Player)p_41406_;
                player.m_7311_(0);
                if (Leggings.getInvisibility(p_41404_)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19609_, 400, 0, false, false));
                    player.m_6842_(true);
                } else {
                    player.m_6842_(false);
                }
            }
        }

        @Override
        public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
            super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
            p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.invisibility", (Object[])new Object[0]) + ": " + (Leggings.getInvisibility(p_41421_) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
        }

        public static boolean getInvisibility(ItemStack itemStack) {
            return itemStack.m_41784_().m_128471_("Invisibility");
        }

        public static void toggleInvisibility(ItemStack itemStack) {
            boolean nightVision = !itemStack.m_41784_().m_128471_("Invisibility");
            itemStack.m_41783_().m_128379_("Invisibility", nightVision);
            ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(String.format("[%s] %s: %b", I18n.m_118938_((String)"item.leggings.name", (Object[])new Object[0]), I18n.m_118938_((String)"mode.invisibility", (Object[])new Object[0]), nightVision))));
        }

        @Override
        public void onManaitaKeyPress(ItemStack paramItemStack, Player paramEntityPlayer) {
            if (paramEntityPlayer.m_6144_()) {
                Leggings.toggleInvisibility(paramItemStack);
            }
        }
    }

    public static class Chestplate
    extends ManaitaPlusArmor {
        public Chestplate() {
            super(ArmorItem.Type.CHESTPLATE);
        }

        public Component m_7626_(ItemStack p_41458_) {
            return Component.m_237113_((String)I18n.m_118938_((String)"item.chestplate.name", (Object[])new Object[0]));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "manaita_plus:textures/models/armor/manaita_armor_layer_1.png";
        }

        public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
            if (p_41407_ == 2 && p_41406_ instanceof Player) {
                Player player = (Player)p_41406_;
                ArrayList badEffects = Lists.newArrayList();
                for (MobEffectInstance effect : player.m_21220_()) {
                    if (effect.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
                    badEffects.add(effect.m_19544_());
                }
                for (MobEffectInstance effect : badEffects) {
                    player.m_21195_((MobEffect)effect);
                }
            }
        }
    }

    public static class Helmet
    extends ManaitaPlusArmor
    implements IManaitaPlusKey {
        public Helmet() {
            super(ArmorItem.Type.HELMET);
        }

        @Override
        public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
            super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
            p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.nightvision", (Object[])new Object[0]) + ": " + (Helmet.getNightVision(p_41421_) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
        }

        public Component m_7626_(ItemStack p_41458_) {
            return Component.m_237113_((String)I18n.m_118938_((String)"item.helmet.name", (Object[])new Object[0]));
        }

        public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
            return "manaita_plus:textures/models/armor/manaita_armor_layer_1.png";
        }

        public void m_6883_(ItemStack p_41404_, Level p_41405_, Entity p_41406_, int p_41407_, boolean p_41408_) {
            if (p_41407_ == 3 && p_41406_ instanceof Player) {
                Player player = (Player)p_41406_;
                player.m_20301_(300);
                FoodData foodData = player.m_36324_();
                if (foodData.m_38702_() < 20) {
                    foodData.m_38705_(20);
                }
                if (foodData.m_38722_() < 20.0f) {
                    foodData.m_38717_(20.0f);
                }
                foodData.m_150378_(0.0f);
                if (Helmet.getNightVision(p_41404_)) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, 400, 0, false, false));
                }
            }
        }

        public static boolean getNightVision(ItemStack itemStack) {
            return itemStack.m_41784_().m_128471_("NightVision");
        }

        public static void toggleNightVision(ItemStack itemStack) {
            boolean nightVision = !itemStack.m_41784_().m_128471_("NightVision");
            itemStack.m_41783_().m_128379_("NightVision", nightVision);
            ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(String.format("[%s] %s: %b", I18n.m_118938_((String)"item.helmet.name", (Object[])new Object[0]), I18n.m_118938_((String)"mode.nightvision", (Object[])new Object[0]), nightVision))));
        }

        @Override
        public void onManaitaKeyPress(ItemStack paramItemStack, Player paramEntityPlayer) {
            if (paramEntityPlayer.m_6144_()) {
                Helmet.toggleNightVision(paramItemStack);
            }
        }
    }
}

