/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.item.portabl;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionBrewing;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.network.NetworkHooks;
import sen.manaita_plus.common.core.ManaitaPlusBlockEntityCore;
import sen.manaita_plus.common.gui.ManaitaPlusBrewingStandMenu;

public class ManaitaPlusBrewingPortabl
extends Item {
    public ManaitaPlusBrewingPortabl() {
        super(new Item.Properties().m_41499_(-1).m_41486_().m_41487_(1));
    }

    public Component m_7626_(ItemStack p_41458_) {
        return Component.m_237115_((String)("item.portableBrewing." + p_41458_.m_41784_().m_128451_("ManaitaType") + ".name"));
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        if (p_41433_ instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)p_41433_;
            final ItemStack itemInHand = p_41433_.m_21120_(p_41434_);
            NetworkHooks.openScreen((ServerPlayer)serverPlayer, (MenuProvider)new MenuProvider(){

                public Component m_5446_() {
                    return Component.m_237115_((String)"container.brewing_manaita");
                }

                @Nullable
                public AbstractContainerMenu m_7208_(int p_39954_, Inventory p_39955_, Player p_39956_) {
                    ManaitaPlusBrewingStandBlockEntity blockEntity = new ManaitaPlusBrewingStandBlockEntity(p_39955_.f_35978_, itemInHand);
                    return blockEntity.m_7208_(p_39954_, p_39955_, p_39956_);
                }
            });
        }
        return super.m_7203_(p_41432_, p_41433_, p_41434_);
    }

    public class ManaitaPlusBrewingStandBlockEntity
    extends BaseContainerBlockEntity {
        private static final int[] SLOTS_FOR_SIDES = new int[]{0, 1, 2, 4};
        private NonNullList<ItemStack> items;
        private boolean[] lastPotionCount;
        private final Player player;
        private final ItemStack stack;
        protected final ContainerData dataAccess;

        public ManaitaPlusBrewingStandBlockEntity(Player player, ItemStack stack) {
            super((BlockEntityType)ManaitaPlusBlockEntityCore.BREWING_BLOCK_ENTITY.get(), player.m_20183_(), null);
            this.items = NonNullList.m_122780_((int)5, (Object)ItemStack.f_41583_);
            this.dataAccess = new ContainerData(){

                public int m_6413_(int p_59038_) {
                    return 0;
                }

                public void m_8050_(int p_59040_, int p_59041_) {
                }

                public int m_6499_() {
                    return 2;
                }
            };
            this.player = player;
            this.stack = stack;
            this.m_142466_(stack.m_41784_());
        }

        protected Component m_6820_() {
            return Component.m_237115_((String)"container.brewing_manaita");
        }

        public int m_6643_() {
            return this.items.size();
        }

        public boolean m_7983_() {
            for (ItemStack itemstack : this.items) {
                if (itemstack.m_41619_()) continue;
                return false;
            }
            return true;
        }

        private boolean[] getPotionBits() {
            boolean[] aboolean = new boolean[3];
            for (int i = 0; i < 3; ++i) {
                if (((ItemStack)this.items.get(i)).m_41619_()) continue;
                aboolean[i] = true;
            }
            return aboolean;
        }

        private static boolean isBrewable(NonNullList<ItemStack> p_155295_) {
            ItemStack itemstack = (ItemStack)p_155295_.get(3);
            if (!itemstack.m_41619_()) {
                return BrewingRecipeRegistry.canBrew(p_155295_, (ItemStack)itemstack, (int[])SLOTS_FOR_SIDES);
            }
            if (itemstack.m_41619_()) {
                return false;
            }
            if (!PotionBrewing.m_43506_((ItemStack)itemstack)) {
                return false;
            }
            for (int i = 0; i < 3; ++i) {
                ItemStack itemstack1 = (ItemStack)p_155295_.get(i);
                if (itemstack1.m_41619_() || !PotionBrewing.m_43508_((ItemStack)itemstack1, (ItemStack)itemstack)) continue;
                return true;
            }
            return false;
        }

        private void doBrew(Level p_155291_, NonNullList<ItemStack> p_155293_) {
            if (ForgeEventFactory.onPotionAttemptBrew(p_155293_)) {
                return;
            }
            ItemStack itemstack = (ItemStack)p_155293_.get(3);
            BrewingRecipeRegistry.brewPotions(p_155293_, (ItemStack)itemstack, (int[])SLOTS_FOR_SIDES);
            for (int slotsForSide : SLOTS_FOR_SIDES) {
                ItemStack itemStack = (ItemStack)p_155293_.get(slotsForSide);
                if (itemstack == ItemStack.f_41583_) continue;
                itemStack.m_41764_(itemStack.m_41613_() * 64);
            }
            ForgeEventFactory.onPotionBrewed(p_155293_);
            if (itemstack.hasCraftingRemainingItem()) {
                ItemStack itemstack1 = itemstack.getCraftingRemainingItem().m_41777_();
                itemstack.m_41774_(1);
                if (itemstack.m_41619_()) {
                    itemstack = itemstack1;
                } else {
                    Containers.m_18992_((Level)p_155291_, (double)this.player.m_20185_(), (double)this.player.m_20186_(), (double)this.player.m_20189_(), (ItemStack)itemstack1);
                }
            } else {
                itemstack.m_41774_(1);
            }
            p_155293_.set(3, (Object)itemstack);
        }

        public void m_142466_(CompoundTag p_155297_) {
            super.m_142466_(p_155297_);
            this.items = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
            ContainerHelper.m_18980_((CompoundTag)p_155297_, this.items);
        }

        protected void m_183515_(CompoundTag p_187484_) {
            super.m_183515_(p_187484_);
            ContainerHelper.m_18973_((CompoundTag)p_187484_, this.items);
        }

        public ItemStack m_8020_(int p_58985_) {
            return p_58985_ >= 0 && p_58985_ < this.items.size() ? (ItemStack)this.items.get(p_58985_) : ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int p_58987_, int p_58988_) {
            return ContainerHelper.m_18969_(this.items, (int)p_58987_, (int)p_58988_);
        }

        public ItemStack m_8016_(int p_59015_) {
            return ContainerHelper.m_18966_(this.items, (int)p_59015_);
        }

        public void m_6836_(int p_58993_, ItemStack p_58994_) {
            if (p_58993_ >= 0 && p_58993_ < this.items.size()) {
                boolean[] aboolean;
                this.items.set(p_58993_, (Object)p_58994_);
                if (ManaitaPlusBrewingStandBlockEntity.isBrewable(this.items)) {
                    this.doBrew(this.player.m_9236_(), this.items);
                }
                if (!Arrays.equals(aboolean = this.getPotionBits(), this.lastPotionCount)) {
                    this.lastPotionCount = aboolean;
                }
            }
            this.m_183515_(this.stack.m_41784_());
        }

        public boolean m_6542_(Player p_59000_) {
            return true;
        }

        public boolean m_7013_(int p_59017_, ItemStack p_59018_) {
            if (p_59017_ == 3) {
                return BrewingRecipeRegistry.isValidIngredient((ItemStack)p_59018_);
            }
            if (p_59017_ == 4) {
                return p_59018_.m_150930_(Items.f_42593_);
            }
            return BrewingRecipeRegistry.isValidInput((ItemStack)p_59018_) && this.m_8020_(p_59017_).m_41619_();
        }

        public boolean canPlaceItemThroughFace(int p_58996_, ItemStack p_58997_, @Nullable Direction p_58998_) {
            return this.m_7013_(p_58996_, p_58997_);
        }

        public boolean canTakeItemThroughFace(int p_59020_, ItemStack p_59021_, Direction p_59022_) {
            return p_59020_ == 3 ? p_59021_.m_150930_(Items.f_42590_) : true;
        }

        public void m_6211_() {
            this.items.clear();
        }

        protected AbstractContainerMenu m_6555_(int p_58990_, Inventory p_58991_) {
            return new ManaitaPlusBrewingStandMenu(p_58990_, p_58991_, (Container)this, this.dataAccess);
        }
    }
}

