/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.item.tool;

import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;
import sen.manaita_plus.common.item.data.IManaitaPlusDestroy;
import sen.manaita_plus.common.item.data.IManaitaPlusKey;
import sen.manaita_plus.common.item.tier.ManaitaPlusItemTier;
import sen.manaita_plus.common.util.ManaitaPlusText;
import sen.manaita_plus.common.util.ManaitaPlusUtils;

public class ManaitaPlusHoeItem
extends DiggerItem
implements IManaitaPlusKey,
IManaitaPlusDestroy {
    public ManaitaPlusHoeItem() {
        super(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, (Tier)new ManaitaPlusItemTier(), BlockTags.f_144281_, new Item.Properties().m_41486_());
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_204336_(BlockTags.f_144281_);
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
    }

    public boolean m_6813_(ItemStack p_40998_, Level p_40999_, BlockState p_41000_, BlockPos p_41001_, LivingEntity p_41002_) {
        return true;
    }

    public boolean m_6777_(BlockState p_41441_, Level p_41442_, BlockPos p_41443_, Player p_41444_) {
        return true;
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return false;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        String range = String.valueOf(this.getRange(p_41421_));
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.manaita_tool", (Object[])new Object[0]) + ": " + range + "x" + range + "x" + range)));
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.doubling", (Object[])new Object[0]) + ":" + (ManaitaPlusHoeItem.getDoubling(p_41421_) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
    }

    @Override
    public void onManaitaKeyPress(ItemStack itemStack, Player player) {
        boolean doubling = !ManaitaPlusHoeItem.getDoubling(itemStack);
        ManaitaPlusHoeItem.setDoubling(itemStack, doubling);
        ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(String.format("[%s] %s: %s", I18n.m_118938_((String)"item.manaita_plus.manaita_hoe", (Object[])new Object[0]), I18n.m_118938_((String)"mode.doubling", (Object[])new Object[0]), ManaitaPlusHoeItem.getDoubling(itemStack) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
    }

    public static boolean getDoubling(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        return itemStack.m_41783_().m_128471_("Doubling");
    }

    public static void setDoubling(ItemStack itemStack, boolean invisibility) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        itemStack.m_41783_().m_128379_("Doubling", invisibility);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        ItemStack itemInHand = p_41433_.m_21120_(p_41434_);
        if (!p_41432_.f_46443_) {
            if (p_41433_.m_6144_()) {
                this.setRange(itemInHand, (this.getRange(itemInHand) + 2) % 21);
            } else {
                HashMap<Enchantment, Integer> enchantmentMap = new HashMap<Enchantment, Integer>();
                enchantmentMap.put(Enchantments.f_44987_, 10);
                String s = I18n.m_118938_((String)"enchantments.fortune", (Object[])new Object[0]);
                if (!EnchantmentHelper.m_272262_((ItemStack)itemInHand)) {
                    enchantmentMap.put(Enchantments.f_44985_, 1);
                    s = I18n.m_118938_((String)"enchantments.silktouch", (Object[])new Object[0]);
                }
                EnchantmentHelper.m_44865_(enchantmentMap, (ItemStack)itemInHand);
                ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_enchantment.formatting(itemInHand.m_41611_().getString() + I18n.m_118938_((String)"info.enchantment", (Object[])new Object[0]) + ": " + s)));
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemInHand);
    }

    @Override
    public int getRange(ItemStack itemStack) {
        int range;
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        if ((range = itemStack.m_41783_().m_128451_("Range")) == 0) {
            itemStack.m_41783_().m_128405_("Range", 1);
            return 1;
        }
        return range;
    }

    public void setRange(ItemStack itemStack, int range) {
        if (range == 0) {
            range = 1;
        }
        itemStack.m_41783_().m_128405_("Range", range);
        ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting("[" + I18n.m_118938_((String)"item.manaita_plus.manaita_hoe", (Object[])new Object[0]) + "] " + I18n.m_118938_((String)"mode.range.name", (Object[])new Object[0]) + ": " + range + "x" + range + "x" + range)));
    }

    @Override
    public boolean accept(BlockState state) {
        return state.m_204336_(BlockTags.f_144281_);
    }

    public InteractionResult m_6225_(UseOnContext p_41341_) {
        Pair pair;
        BlockPos blockpos;
        Level level = p_41341_.m_43725_();
        BlockState toolModifiedState = level.m_8055_(blockpos = p_41341_.m_8083_()).getToolModifiedState(p_41341_, ToolActions.HOE_TILL, false);
        Pair pair2 = pair = toolModifiedState == null ? null : Pair.of(ctx -> true, (Object)HoeItem.m_150858_((BlockState)toolModifiedState));
        if (pair == null) {
            return InteractionResult.PASS;
        }
        Predicate predicate = (Predicate)pair.getFirst();
        Consumer consumer = (Consumer)pair.getSecond();
        if (predicate.test(p_41341_)) {
            Player player = p_41341_.m_43723_();
            level.m_5594_(player, blockpos, SoundEvents.f_11955_, SoundSource.BLOCKS, 1.0f, 1.0f);
            if (!level.f_46443_) {
                consumer.accept(p_41341_);
                if (player != null) {
                    p_41341_.m_43722_().m_41622_(1, (LivingEntity)player, p_150845_ -> p_150845_.m_21190_(p_41341_.m_43724_()));
                }
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public static Consumer<UseOnContext> changeIntoStateAndDropItem(BlockState p_150850_, ItemLike p_150851_) {
        return p_238246_ -> {
            p_238246_.m_43725_().m_7731_(p_238246_.m_8083_(), p_150850_, 11);
            p_238246_.m_43725_().m_220407_(GameEvent.f_157792_, p_238246_.m_8083_(), GameEvent.Context.m_223719_((Entity)p_238246_.m_43723_(), (BlockState)p_150850_));
            Block.m_152435_((Level)p_238246_.m_43725_(), (BlockPos)p_238246_.m_8083_(), (Direction)p_238246_.m_43719_(), (ItemStack)new ItemStack(p_150851_));
        };
    }

    public static boolean onlyIfAirAbove(UseOnContext p_150857_) {
        return p_150857_.m_43719_() != Direction.DOWN && p_150857_.m_43725_().m_8055_(p_150857_.m_8083_().m_7494_()).m_60795_();
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_HOE_ACTIONS.contains(toolAction);
    }
}

