/*
 * Decompiled with CFR 0.152.
 */
package sen.manaita_plus.common.item.tool;

import java.util.HashMap;
import java.util.List;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.jetbrains.annotations.Nullable;
import sen.manaita_plus.common.item.data.IManaitaPlusDestroy;
import sen.manaita_plus.common.item.data.IManaitaPlusKey;
import sen.manaita_plus.common.item.tier.ManaitaPlusItemTier;
import sen.manaita_plus.common.util.ManaitaPlusText;
import sen.manaita_plus.common.util.ManaitaPlusUtils;

public class ManaitaPlusPickaxeItem
extends DiggerItem
implements IManaitaPlusKey,
IManaitaPlusDestroy {
    public ManaitaPlusPickaxeItem() {
        super(Float.POSITIVE_INFINITY, Float.POSITIVE_INFINITY, (Tier)new ManaitaPlusItemTier(), BlockTags.f_144282_, new Item.Properties().m_41486_());
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return ToolActions.DEFAULT_PICKAXE_ACTIONS.contains(toolAction);
    }

    public boolean isCorrectToolForDrops(ItemStack stack, BlockState state) {
        return state.m_204336_(BlockTags.f_144282_);
    }

    public void onDestroyed(ItemEntity itemEntity, DamageSource damageSource) {
    }

    public boolean m_6813_(ItemStack p_40998_, Level p_40999_, BlockState p_41000_, BlockPos p_41001_, LivingEntity p_41002_) {
        return true;
    }

    public boolean m_6777_(BlockState p_41441_, Level p_41442_, BlockPos p_41443_, Player p_41444_) {
        return true;
    }

    public void m_7373_(ItemStack p_41421_, @Nullable Level p_41422_, List<Component> p_41423_, TooltipFlag p_41424_) {
        super.m_7373_(p_41421_, p_41422_, p_41423_, p_41424_);
        String range = String.valueOf(this.getRange(p_41421_));
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.manaita_tool", (Object[])new Object[0]) + ": " + range + "x" + range + "x" + range)));
        p_41423_.add((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(I18n.m_118938_((String)"mode.doubling", (Object[])new Object[0]) + ":" + (ManaitaPlusPickaxeItem.getDoubling(p_41421_) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
    }

    @Override
    public void onManaitaKeyPress(ItemStack itemStack, Player player) {
        boolean doubling = !ManaitaPlusPickaxeItem.getDoubling(itemStack);
        ManaitaPlusPickaxeItem.setDoubling(itemStack, doubling);
        ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting(String.format("[%s] %s: %s", I18n.m_118938_((String)"item.manaita_plus.manaita_pickaxe", (Object[])new Object[0]), I18n.m_118938_((String)"mode.doubling", (Object[])new Object[0]), ManaitaPlusPickaxeItem.getDoubling(itemStack) ? I18n.m_118938_((String)"info.on", (Object[])new Object[0]) : I18n.m_118938_((String)"info.off", (Object[])new Object[0])))));
    }

    public static boolean getDoubling(ItemStack itemStack) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        return itemStack.m_41783_().m_128471_("Doubling");
    }

    public static void setDoubling(ItemStack itemStack, boolean invisibility) {
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        itemStack.m_41783_().m_128379_("Doubling", invisibility);
    }

    public boolean onBlockStartBreak(ItemStack itemstack, BlockPos pos, Player player) {
        return false;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level p_41432_, Player p_41433_, InteractionHand p_41434_) {
        ItemStack itemInHand = p_41433_.m_21120_(p_41434_);
        if (!p_41432_.f_46443_) {
            if (p_41433_.m_6144_()) {
                this.setRange(itemInHand, (this.getRange(itemInHand) + 2) % 21);
            } else {
                HashMap<Enchantment, Integer> enchantmentMap = new HashMap<Enchantment, Integer>();
                enchantmentMap.put(Enchantments.f_44987_, 10);
                String s = I18n.m_118938_((String)"enchantments.fortune", (Object[])new Object[0]);
                if (!EnchantmentHelper.m_272262_((ItemStack)itemInHand)) {
                    enchantmentMap.put(Enchantments.f_44985_, 1);
                    s = I18n.m_118938_((String)"enchantments.silktouch", (Object[])new Object[0]);
                }
                EnchantmentHelper.m_44865_(enchantmentMap, (ItemStack)itemInHand);
                ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_enchantment.formatting(itemInHand.m_41611_().getString() + I18n.m_118938_((String)"info.enchantment", (Object[])new Object[0]) + ": " + s)));
            }
        }
        return InteractionResultHolder.m_19098_((Object)itemInHand);
    }

    @Override
    public int getRange(ItemStack itemStack) {
        int range;
        if (itemStack.m_41783_() == null) {
            itemStack.m_41751_(new CompoundTag());
        }
        if ((range = itemStack.m_41783_().m_128451_("Range")) == 0) {
            itemStack.m_41783_().m_128405_("Range", 1);
            return 1;
        }
        return range;
    }

    public void setRange(ItemStack itemStack, int range) {
        if (range == 0) {
            range = 1;
        }
        itemStack.m_41783_().m_128405_("Range", range);
        ManaitaPlusUtils.chat((Component)Component.m_237113_((String)ManaitaPlusText.manaita_mode.formatting("[" + I18n.m_118938_((String)"item.manaita_plus.manaita_pickaxe", (Object[])new Object[0]) + "] " + I18n.m_118938_((String)"mode.range.name", (Object[])new Object[0]) + ": " + range + "x" + range + "x" + range)));
    }

    @Override
    public boolean accept(BlockState state) {
        return state.m_204336_(BlockTags.f_144282_);
    }
}

